/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.util;

import com.google.common.hash.HashCode;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.covers1624.wt.util.Utils;

public class HashContainer {
    private static final Type gsonType = new TypeToken<Map<String, HashCode>>(){}.getType();
    private final Path hashFile;
    public Map<String, HashCode> hashes;

    public HashContainer(File hashFile) {
        this(hashFile.toPath());
    }

    public HashContainer(Path hashFile) {
        this.hashFile = hashFile;
        if (Files.exists(hashFile, new LinkOption[0])) {
            this.hashes = (Map)Utils.fromJson(hashFile, gsonType);
        }
        if (this.hashes == null) {
            this.hashes = new HashMap<String, HashCode>();
        }
    }

    public boolean check(String key, HashCode other) {
        return !Objects.equals(this.hashes.get(key), other);
    }

    public HashCode get(String key) {
        return this.hashes.get(key);
    }

    public void set(String key, HashCode hashCode) {
        this.hashes.put(key, hashCode);
        this.save();
    }

    public void remove(String key) {
        this.hashes.remove(key);
        this.save();
    }

    public void save() {
        Utils.toJson(this.hashes, gsonType, this.hashFile);
    }
}

