/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.util.SneakyUtils;

public class JarStripper {
    public static void stripJar(Path input, Path output, Predicate<Path> predicate) {
        if (Files.notExists(output, new LinkOption[0]) && Files.notExists(output.getParent(), new LinkOption[0])) {
            SneakyUtils.sneaky(() -> Files.createDirectories(output.getParent(), new FileAttribute[0]));
        }
        if (Files.exists(output, new LinkOption[0])) {
            SneakyUtils.sneaky(() -> Files.delete(output));
        }
        try (FileSystem inFs = IOUtils.getJarFileSystem((Path)input, (boolean)true);
             FileSystem outFs = IOUtils.getJarFileSystem((Path)output, (boolean)true);){
            Path inRoot = inFs.getPath("/", new String[0]);
            Path outRoot = outFs.getPath("/", new String[0]);
            Files.walkFileTree(inRoot, new Visitor(inRoot, outRoot, predicate));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Visitor
    extends SimpleFileVisitor<Path> {
        private final Path inRoot;
        private final Path outRoot;
        private final Predicate<Path> predicate;

        private Visitor(Path inRoot, Path outRoot, Predicate<Path> predicate) {
            this.inRoot = inRoot;
            this.outRoot = outRoot;
            this.predicate = predicate;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path outDir = this.outRoot.resolve(this.inRoot.relativize(dir).toString());
            if (Files.notExists(outDir, new LinkOption[0])) {
                Files.createDirectories(outDir, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path inFile, BasicFileAttributes attrs) throws IOException {
            Path rel = this.inRoot.relativize(inFile);
            Path outFile = this.outRoot.resolve(rel.toString());
            if (this.predicate.test(rel)) {
                Files.copy(inFile, outFile, new CopyOption[0]);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

