/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.util;

import com.google.common.collect.Table;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.covers1624.quack.gson.FileAdapter;
import net.covers1624.quack.gson.HashCodeAdapter;
import net.covers1624.quack.gson.LowerCaseEnumAdapterFactory;
import net.covers1624.quack.gson.MavenNotationAdapter;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.quack.util.HashUtils;
import net.covers1624.quack.util.SneakyUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static final Logger LOGGER = LogManager.getLogger(Utils.class);
    public static final Gson gson = (Gson)SneakyUtils.sneaky(() -> {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(File.class, (Object)new FileAdapter()).registerTypeAdapter(HashCode.class, (Object)new HashCodeAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumAdapterFactory()).registerTypeAdapter(MavenNotation.class, (Object)new MavenNotationAdapter());
        return builder.create();
    });

    public static <T> T fromJson(File file, Class<T> classOfT) {
        return Utils.fromJson(file.toPath(), classOfT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromJson(Path path, Class<T> classOfT) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Object object = gson.fromJson((Reader)reader, classOfT);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read json from file. " + String.valueOf(path));
        }
    }

    public static <T> T fromJson(File file, Type typeOfT) {
        return Utils.fromJson(file.toPath(), typeOfT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromJson(Path path, Type typeOfT) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Object object = gson.fromJson((Reader)reader, typeOfT);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read json from file. " + String.valueOf(path), e);
        }
    }

    public static void toJson(Object obj, File file) {
        Utils.toJson(obj, obj.getClass(), file);
    }

    public static void toJson(Object obj, Type typeOfObj, File file) {
        Utils.toJson(obj, typeOfObj, file.toPath());
    }

    public static void toJson(Object obj, Type typeOfObj, Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete file: " + String.valueOf(path), e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            gson.toJson(obj, typeOfObj, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write json to file. " + String.valueOf(path));
        }
    }

    public static void deleteFolder(File directory) {
        ArrayDeque<File> toDelete = new ArrayDeque<File>();
        toDelete.push(directory);
        while (!toDelete.isEmpty()) {
            File peek = (File)toDelete.peek();
            if (peek.isDirectory()) {
                File[] list = peek.listFiles();
                if (list == null || list.length == 0) {
                    ((File)toDelete.pop()).delete();
                    continue;
                }
                for (File f : list) {
                    toDelete.push(f);
                }
                continue;
            }
            ((File)toDelete.pop()).delete();
        }
    }

    public static Path makeFile(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            Path parent = path.toAbsolutePath().getParent();
            if (Files.notExists(parent, new LinkOption[0])) {
                SneakyUtils.sneaky(() -> Files.createDirectories(parent, new FileAttribute[0]));
            }
        } else {
            SneakyUtils.sneaky(() -> Files.delete(path));
        }
        SneakyUtils.sneaky(() -> Files.createFile(path, new FileAttribute[0]));
        return path;
    }

    public static void addToHasher(Hasher hasher, String resource) {
        try (InputStream is = Utils.class.getResourceAsStream(resource);){
            HashUtils.addToHasher((Hasher)hasher, (InputStream)is);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read resource: " + resource, e);
        }
    }

    public static void addToHasher(Hasher hasher, Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                HashUtils.addToHasher((Hasher)hasher, (InputStream)is);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read file: " + String.valueOf(path), e);
            }
        }
    }

    public static List<Path> toPaths(List<File> from) {
        return from.parallelStream().map(File::toPath).collect(Collectors.toList());
    }

    public static Path getJarPathForClass(String aClass) {
        String resourceRoot = Utils.getResourceRoot(Utils.class, "/" + aClass.replace('.', '/') + ".class");
        return resourceRoot != null ? new File(resourceRoot).getAbsoluteFile().toPath() : null;
    }

    public static Path getJarPathForClass(Class<?> aClass) {
        String resourceRoot = Utils.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        return resourceRoot != null ? new File(resourceRoot).getAbsoluteFile().toPath() : null;
    }

    public static Path getJarPathForResource(String resource) {
        String resourceRoot = Utils.getResourceRoot(Utils.class, "/" + resource);
        return resourceRoot != null ? new File(resourceRoot).getAbsoluteFile().toPath() : null;
    }

    public static String getResourceRoot(Class<?> context, String path) {
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? Utils.extractRoot(url, path) : null;
    }

    public static String extractRoot(URL resourceURL, String resourcePath) {
        if (!StringUtils.startsWith((CharSequence)resourcePath, (CharSequence)"/") && !StringUtils.startsWith((CharSequence)resourcePath, (CharSequence)"\\")) {
            LOGGER.warn("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = Utils.urlToFile(resourceURL).getPath();
            String testPath = path.replace('\\', '/');
            if (StringUtils.endsWithIgnoreCase((CharSequence)testPath, (CharSequence)(testResourcePath = resourcePath.replace('\\', '/')))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = Utils.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.getLeft() != null) {
                resultPath = ((String)paths.getLeft()).replace("\\", "/");
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            LOGGER.warn("cannot extract '" + resourcePath + "' from '" + String.valueOf(resourceURL) + "'");
            return null;
        }
        return StringUtils.removeEnd(resultPath, (String)"/");
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block6: {
            int pivot = url.indexOf("!/");
            if (pivot < 0) {
                return null;
            }
            resourcePath = url.substring(pivot + 2);
            jarPath = url.substring(0, pivot);
            if (jarPath.startsWith("jar:")) {
                jarPath = jarPath.substring("jar".length() + 1);
            }
            if (jarPath.startsWith("file")) {
                try {
                    jarPath = Utils.urlToFile(new URL(jarPath)).getPath().replace('\\', '/');
                }
                catch (Exception e) {
                    jarPath = jarPath.substring("file".length());
                    if (jarPath.startsWith("://")) {
                        jarPath = jarPath.substring("://".length());
                    }
                    if (!StringUtils.startsWith((CharSequence)jarPath, (CharSequence)":")) break block6;
                    jarPath = jarPath.substring(1);
                }
            }
        }
        return Pair.of((Object)jarPath, (Object)resourcePath);
    }

    public static File urlToFile(URL url) {
        try {
            return new File(url.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL='" + String.valueOf(url) + "'", e);
        }
    }

    public static boolean isAncestor(Path path, Path prefix, boolean strict) {
        return Utils.startsWith(path, prefix, strict, IOCase.SYSTEM, true);
    }

    public static boolean startsWith(Path _path, Path _prefix, boolean strict, IOCase ioCase, boolean checkImmediateParent) {
        char next1;
        String path = _path.normalize().toAbsolutePath().toString();
        String prefix = _prefix.normalize().toAbsolutePath().toString();
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            return pathLength == 0;
        }
        if (prefixLength > pathLength) {
            return false;
        }
        if (!path.regionMatches(!ioCase.isCaseSensitive(), 0, prefix, 0, prefixLength)) {
            return false;
        }
        if (pathLength == prefixLength) {
            return !strict;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == File.separatorChar) {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        if ((next1 = path.charAt(slashOrSeparatorIdx)) == '/' || next1 == File.separatorChar) {
            if (!checkImmediateParent) {
                return true;
            }
            if (slashOrSeparatorIdx == pathLength - 1) {
                return true;
            }
            int idxNext = path.indexOf(next1, slashOrSeparatorIdx + 1);
            idxNext = idxNext == -1 ? path.indexOf(next1 == '/' ? 92 : 47, slashOrSeparatorIdx + 1) : idxNext;
            return idxNext == -1;
        }
        return false;
    }

    public static void extractResource(String resource, Path to) {
        try (InputStream is = Utils.class.getResourceAsStream(resource);){
            Path parent = to.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (OutputStream fos = Files.newOutputStream(to, new OpenOption[0]);){
                IOUtils.copy((InputStream)is, (OutputStream)fos);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to extract resource '" + resource + "' to file '" + String.valueOf(to) + "'.", e);
        }
    }

    public static <R, C, V> V computeIfAbsent(Table<R, C, V> table, R r, C c, Supplier<V> vFunc) {
        Object val = table.get(r, c);
        if (val == null) {
            val = vFunc.get();
            table.put(r, c, val);
        }
        return (V)val;
    }

    public static <T extends AccessibleObject> T makeAccessible(T thing) {
        thing.setAccessible(true);
        return thing;
    }

    public static <T> T getField(Field field, Object instance) {
        return (T)SneakyUtils.sneaky(() -> Utils.makeAccessible(field).get(instance));
    }
}

