/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.util.tree;

import com.google.common.collect.Streams;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.covers1624.wt.util.tree.ClassTree;
import net.covers1624.wt.util.tree.TreeFieldNode;
import net.covers1624.wt.util.tree.TreeMethodNode;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class TreeClassNode
implements Serializable {
    @Nullable
    private final transient ClassTree tree;
    public boolean loaded;
    public int access;
    public String name;
    public String signature;
    public TreeClassNode superClass;
    public Map<String, TreeClassNode> interfaces = new LinkedHashMap<String, TreeClassNode>();
    public TreeClassNode outerClass;
    public TreeMethodNode outerMethod;
    public Map<String, TreeClassNode> innerClasses = new LinkedHashMap<String, TreeClassNode>();
    public Map<String, TreeFieldNode> fields = new LinkedHashMap<String, TreeFieldNode>();
    public Map<String, TreeMethodNode> methods = new LinkedHashMap<String, TreeMethodNode>();

    private TreeClassNode() {
        this(null);
    }

    public TreeClassNode(ClassTree tree) {
        this.tree = tree;
    }

    public void copyFrom(TreeClassNode other) {
        this.loaded = other.loaded;
        this.access = other.access;
        this.name = other.name;
        this.signature = other.signature;
        this.superClass = this.tree.getClassNode(other.superClass.name);
        this.interfaces.clear();
        other.interfaces.forEach((name, node) -> this.interfaces.put((String)name, this.tree.getClassNode(node.name)));
        this.innerClasses.clear();
        other.innerClasses.forEach((name, node) -> this.innerClasses.put((String)name, this.tree.getClassNode(node.name)));
        this.fields.clear();
        other.fields.forEach((name, node) -> this.fields.put((String)name, this.tree.getClassNode(node.owner.name).getField((String)name)));
        this.fields.clear();
        other.fields.forEach((name, node) -> {
            TreeFieldNode newNode = this.tree.getClassNode(node.owner.name).getField(node.name);
            newNode.copyFrom((TreeFieldNode)node);
            this.fields.put((String)name, newNode);
        });
        this.methods.clear();
        other.methods.forEach((name, node) -> {
            TreeMethodNode newNode = this.tree.getClassNode(node.owner.name).getMethod(node.name, node.desc);
            newNode.copyFrom((TreeMethodNode)node);
            this.methods.put((String)name, newNode);
        });
    }

    public Stream<TreeClassNode> getHierarchy() {
        if (!this.loaded) {
            return Stream.empty();
        }
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), Streams.concat((Stream[])new Stream[]{Stream.of(this.superClass), this.interfaces.values().stream()}).flatMap(TreeClassNode::getHierarchy)}).distinct();
    }

    public TreeClassNode getInterface(String name) {
        return this.interfaces.computeIfAbsent(name, this.tree::getClassNode);
    }

    public TreeClassNode getInnerClass(String name) {
        return this.innerClasses.computeIfAbsent(name, this.tree::getClassNode);
    }

    public TreeFieldNode getField(String name) {
        return this.fields.computeIfAbsent(name, this.tree::createFieldNode);
    }

    public TreeMethodNode getMethod(String name, String desc) {
        return this.methods.computeIfAbsent(name + desc, e -> this.tree.createMethodNode(name, desc));
    }

    public ClassVisitor visitClass() {
        return new Visitor();
    }

    private class Visitor
    extends ClassVisitor {
        public Visitor() {
            super(458752);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            TreeClassNode.this.loaded = true;
            TreeClassNode.this.access = access;
            TreeClassNode.this.name = name;
            TreeClassNode.this.signature = signature;
            TreeClassNode.this.superClass = TreeClassNode.this.tree.getClassNode(superName);
            TreeClassNode.this.interfaces.clear();
            Arrays.stream(interfaces).map(TreeClassNode.this.tree::getClassNode).forEach(e -> TreeClassNode.this.interfaces.put(e.name, (TreeClassNode)e));
        }

        public void visitOuterClass(String owner, String name, String descriptor) {
            TreeClassNode.this.outerClass = TreeClassNode.this.tree.getClassNode(owner);
            if (name != null && descriptor != null) {
                TreeClassNode.this.outerMethod = TreeClassNode.this.outerClass.getMethod(name, descriptor);
            }
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            return TreeClassNode.this.getField(name).visitField(TreeClassNode.this, access, name, descriptor, signature);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return TreeClassNode.this.getMethod(name, descriptor).visitMethod(TreeClassNode.this, access, name, descriptor, signature, exceptions);
        }
    }
}

