/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.util.tree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.covers1624.wt.util.tree.ClassTree;
import net.covers1624.wt.util.tree.TreeClassNode;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class TreeMethodNode
implements Serializable {
    @Nullable
    private final transient ClassTree tree;
    public boolean loaded;
    public TreeClassNode owner;
    public int access;
    public String name;
    public Parameter returnType = null;
    public Parameter[] parameters = new Parameter[0];
    public String desc;
    public String signature;
    public List<TreeClassNode> exceptions = new ArrayList<TreeClassNode>();

    private TreeMethodNode() {
        this(null);
    }

    public TreeMethodNode(ClassTree tree) {
        this.tree = tree;
    }

    public void copyFrom(TreeMethodNode other) {
        this.loaded = other.loaded;
        this.owner = this.tree.getClassNode(other.owner.name);
        this.access = other.access;
        this.name = other.name;
        this.desc = other.desc;
        this.signature = other.signature;
        this.exceptions.clear();
        other.exceptions.stream().map(e -> e.name).map(this.tree::getClassNode).forEach(this.exceptions::add);
        this.returnType = new Parameter().copyFrom(this.tree, other.returnType);
        this.parameters = new Parameter[other.parameters.length];
        for (int i = 0; i < other.parameters.length; ++i) {
            this.parameters[i] = new Parameter().copyFrom(this.tree, other.parameters[i]);
        }
    }

    public MethodVisitor visitMethod(TreeClassNode owner, int access, String name, String desc, String signature, String[] exceptions) {
        this.owner = owner;
        this.loaded = true;
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.exceptions.clear();
        if (exceptions != null) {
            Arrays.stream(exceptions).map(this.tree::getClassNode).forEach(this.exceptions::add);
        }
        Type descType = Type.getMethodType((String)desc);
        this.returnType = this.createParameter(-1, descType.getReturnType());
        Type[] params = descType.getArgumentTypes();
        this.parameters = new Parameter[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.parameters[i] = this.createParameter(i, params[i]);
        }
        return new Visitor((access & 8) != 0);
    }

    private Parameter createParameter(int idx, Type type) {
        boolean isPrimitive = this.isPrimitive(type);
        TreeClassNode treeType = isPrimitive ? null : this.tree.getClassNode(type.getInternalName());
        return new Parameter(idx, "", treeType, isPrimitive, type);
    }

    private boolean isPrimitive(Type type) {
        return type.getSort() == 9 ? this.isPrimitive(type.getElementType()) : 0 <= type.getSort() && type.getSort() <= 8;
    }

    public static class Parameter
    implements Externalizable {
        public int idx;
        public String name;
        public TreeClassNode type;
        public boolean primitive;
        public Type desc;
        public String signature;

        public Parameter() {
        }

        public Parameter(int idx, String name, TreeClassNode type, boolean primitive, Type desc) {
            this.idx = idx;
            this.name = name;
            this.type = type;
            this.primitive = primitive;
            this.desc = desc;
            if (idx != -1 && StringUtils.isEmpty((String)name)) {
                this.name = "p" + idx;
            }
        }

        public Parameter copyFrom(ClassTree tree, Parameter other) {
            this.idx = other.idx;
            this.name = other.name;
            if (other.type != null) {
                this.type = tree.getClassNode(other.type.name);
            }
            this.primitive = other.primitive;
            this.desc = other.desc;
            this.signature = other.signature;
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.idx);
            out.writeObject(this.name);
            out.writeBoolean(this.primitive);
            out.writeObject(this.desc.getDescriptor());
            out.writeObject(this.signature);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.idx = in.readInt();
            this.name = (String)in.readObject();
            this.primitive = in.readBoolean();
            this.desc = Type.getType((String)((String)in.readObject()));
            this.signature = (String)in.readObject();
        }
    }

    private class Visitor
    extends MethodVisitor {
        private final boolean isStatic;
        private final List<ParameterHolder> parameters;

        public Visitor(boolean isStatic) {
            super(458752);
            this.parameters = new ArrayList<ParameterHolder>();
            this.isStatic = isStatic;
        }

        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            this.parameters.add(new ParameterHolder(index, name, signature));
        }

        public void visitEnd() {
            for (int i = 0; i < this.parameters.size(); ++i) {
                int index;
                int n = index = this.isStatic ? i : i - 1;
                if (0 > index || TreeMethodNode.this.parameters.length <= index) continue;
                Parameter parameter = TreeMethodNode.this.parameters[index];
                ParameterHolder holder = this.parameters.get(i);
                parameter.name = holder.name;
                parameter.signature = holder.signature;
            }
        }

        private class ParameterHolder {
            public final int idx;
            public final String name;
            public final String signature;

            private ParameterHolder(int idx, String name, String signature) {
                this.idx = idx;
                this.name = name;
                this.signature = signature;
            }
        }
    }
}

