/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.forge.gradle;

import groovy.lang.MetaProperty;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.quack.util.SneakyUtils;
import net.covers1624.wt.api.event.VersionedClass;
import net.covers1624.wt.api.gradle.data.ConfigurationData;
import net.covers1624.wt.api.gradle.data.PluginData;
import net.covers1624.wt.api.gradle.data.ProjectData;
import net.covers1624.wt.forge.gradle.FGVersion;
import net.covers1624.wt.forge.gradle.data.FG2Data;
import net.covers1624.wt.forge.gradle.data.FG2McpMappingData;
import net.covers1624.wt.forge.gradle.data.FG3Data;
import net.covers1624.wt.forge.gradle.data.FG3McpMappingData;
import net.covers1624.wt.forge.gradle.data.FGPluginData;
import net.covers1624.wt.gradle.builder.ExtraDataBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VersionedClass(value=5)
public class FGDataBuilder
implements ExtraDataBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FGDataBuilder.class);
    private static final String FG2_USER_PLUGIN = "net.minecraftforge.gradle.forge";
    private static final String FG2_USER_PLUGIN_CLASS = "net.minecraftforge.gradle.user.patcherUser.forge.ForgePlugin";
    private static final String FG2_PATCHER_PLUGIN = "net.minecraftforge.gradle.patcher";
    private static final String FG2_PATCHER_PLUGIN_Class = "net.minecraftforge.gradle.patcher.PatcherPlugin";
    private static final String FG3_USER_PLUGIN = "net.minecraftforge.gradle";
    private static final String FG3_USER_PLUGIN_CLASS = "net.minecraftforge.gradle";
    private static final String FG3_PATCHER_PLUGIN = "net.minecraftforge.gradle.patcher";
    private static final String FG3_PATCHER_PLUGIN_Class = "net.minecraftforge.gradle.patcher.PatcherPlugin";

    /*
     * Enabled aggressive block sorting
     */
    public void preBuild(Project project, PluginData pluginData) throws Exception {
        FGPluginData fgPluginData = new FGPluginData();
        fgPluginData.version = FGVersion.UNKNOWN;
        String fg2VString = FGDataBuilder.tryGetFG2Version(project);
        if (fg2VString != null) {
            fgPluginData.versionString = fg2VString;
            if (fg2VString.startsWith("2.2")) {
                fgPluginData.version = FGVersion.FG22;
            } else {
                if (!fg2VString.startsWith("2.3")) {
                    LOGGER.error("Failed to parse FG2 Version: {}", (Object)fg2VString);
                    throw new RuntimeException("Failed to parse FG2Version.");
                }
                fgPluginData.version = FGVersion.FG23;
            }
        } else {
            String version;
            Configuration classpath = (Configuration)project.getBuildscript().getConfigurations().findByName("classpath");
            if (!classpath.isCanBeResolved()) {
                throw new RuntimeException("Unable to resolve classpath configuration.");
            }
            Set artifacts = classpath.getResolvedConfiguration().getResolvedArtifacts();
            Optional<ResolvedArtifact> fgArtifact = artifacts.parallelStream().map(e -> Pair.of((Object)e, (Object)e.getModuleVersion().getId())).filter(e -> ((ModuleVersionIdentifier)e.getRight()).getGroup().equals("net.minecraftforge.gradle") || ((ModuleVersionIdentifier)e.getRight()).getGroup().equals("net.neoforged")).filter(e -> ((ModuleVersionIdentifier)e.getRight()).getName().equals("ForgeGradle") || ((ModuleVersionIdentifier)e.getRight()).getName().equals("NeoGradle")).map(Pair::getLeft).findFirst();
            if (!fgArtifact.isPresent()) {
                LOGGER.error("Unable to find ForgeGradle artifact in buildscript classpath configuration.");
                LOGGER.debug("Found artifacts: '{}'", (Object)artifacts.parallelStream().map(ResolvedArtifact::getModuleVersion).map(ResolvedModuleVersion::getId).map(Object::toString).collect(Collectors.joining(", ")));
                return;
            }
            ModuleVersionIdentifier ident = fgArtifact.get().getModuleVersion().getId();
            fgPluginData.versionString = version = ident.getVersion();
            fgPluginData.isNeoForgeGradle = ident.getGroup().equals("net.neoforged");
            if (version.startsWith("[")) {
                version = version.substring(1);
            }
            if (version.startsWith("2.2")) {
                fgPluginData.version = FGVersion.FG22;
            } else if (version.startsWith("2.3")) {
                fgPluginData.version = FGVersion.FG23;
            } else if (version.startsWith("3.0")) {
                fgPluginData.version = FGVersion.FG30;
            } else if (version.startsWith("4.0")) {
                fgPluginData.version = FGVersion.FG40;
            } else if (version.startsWith("4.1")) {
                fgPluginData.version = FGVersion.FG41;
            } else if (version.startsWith("5.0")) {
                fgPluginData.version = FGVersion.FG50;
            } else if (version.startsWith("5.1")) {
                fgPluginData.version = FGVersion.FG51;
            } else if (version.startsWith("6.0")) {
                fgPluginData.version = FGVersion.FG60;
            } else if (version.startsWith("6.1")) {
                fgPluginData.version = FGVersion.FG61;
            } else {
                LOGGER.error("Unknown FG version: '{}', From: '{}' in project {}({})", new Object[]{version, ident, project.getPath(), project.getDisplayName()});
            }
        }
        if (fgPluginData.version == FGVersion.UNKNOWN) {
            LOGGER.warn("Failed to find ForgeGradle in project {}({}). :(", (Object)project.getPath(), (Object)project.getDisplayName());
            return;
        }
        String variant = fgPluginData.isNeoForgeGradle ? "NeoGradle" : "ForgeGradle";
        LOGGER.info("Found {}! Version: {} in project {}({})", new Object[]{variant, fgPluginData.version, project.getPath(), project.getDisplayName()});
        pluginData.extraData.put(FGPluginData.class, fgPluginData);
        if (!fgPluginData.version.isFG2()) {
            return;
        }
        if (!pluginData.pluginIds.contains("net.minecraftforge.gradle.patcher")) {
            return;
        }
        if (project.getConfigurations().findByName("testCompile") == null) {
            return;
        }
        Task genGradleProjects = (Task)project.getTasks().findByName("genGradleProjects");
        if (genGradleProjects != null) {
            Field field = genGradleProjects.getClass().getSuperclass().getDeclaredField("dependencies");
            field.setAccessible(true);
            List dependencies = (List)field.get(genGradleProjects);
            dependencies.forEach(dep -> {
                if (dep.startsWith("testCompile")) {
                    String trimmed = dep.replace("testCompile", "").replace("'", "").trim();
                    project.getDependencies().add("testCompile", (Object)trimmed);
                }
            });
        }
    }

    public void build(Project project, ProjectData projectData, ProjectData rootData) throws Exception {
        PluginData pluginData = projectData.pluginData;
        FGPluginData fgPluginData = (FGPluginData)rootData.pluginData.getData(FGPluginData.class);
        if (fgPluginData == null) {
            LOGGER.info("Null plugin data.");
            return;
        }
        FGVersion version = fgPluginData.version;
        if (version.isFG2()) {
            FG2.build(project, pluginData, projectData);
        } else if (version.isFG3Compatible()) {
            FG3Plus.build(project, pluginData, projectData);
        }
    }

    private static String tryGetFG2Version(Project project) {
        Object baseExtension = project.getExtensions().findByName("minecraft");
        if (baseExtension != null) {
            return (String)FGDataBuilder.tryGetProperty(baseExtension, "forgeGradleVersion");
        }
        return null;
    }

    public static <T> T tryGetProperty(Object object, String name) {
        MetaProperty prop = DefaultGroovyMethods.hasProperty((Object)object, (String)name);
        if (prop == null) {
            return null;
        }
        return (T)SneakyUtils.unsafeCast((Object)prop.getProperty(object));
    }

    private static <T> T getProperty(Object object, String name) {
        T thing = FGDataBuilder.tryGetProperty(object, name);
        if (thing == null) {
            throw new RuntimeException("Property not found: " + name);
        }
        return thing;
    }

    private static <T> List<T> coerceToList(Object o) {
        if (o instanceof List) {
            return (List)SneakyUtils.unsafeCast((Object)o);
        }
        if (o instanceof ConfigurableFileCollection) {
            return (List)SneakyUtils.unsafeCast(new ArrayList(((ConfigurableFileCollection)o).getFiles()));
        }
        throw new IllegalArgumentException("Unable to coerce '" + o.getClass().getName() + "' to a List.");
    }

    private static MavenNotation zipNotationOf(Dependency dep) {
        return new MavenNotation(dep.getGroup(), dep.getName(), dep.getVersion(), null, "zip");
    }

    public static class FG3Plus {
        public static void build(Project project, PluginData pluginData, ProjectData projectData) {
            Object extension;
            FG3Data data = new FG3Data();
            projectData.extraData.put(FG3Data.class, data);
            Object mcExt = project.getExtensions().findByName("minecraft");
            Object patcherExt = project.getExtensions().findByName("patcher");
            Object object = extension = mcExt != null ? mcExt : patcherExt;
            if (extension != null) {
                data.accessTransformers = FGDataBuilder.coerceToList(FGDataBuilder.tryGetProperty(extension, "accessTransformers"));
                data.sideAnnotationStrippers = FGDataBuilder.coerceToList(FGDataBuilder.tryGetProperty(extension, "sideAnnotationStrippers"));
            }
            Optional<ConfigurationData.MavenDependency> mappings = projectData.configurations.values().stream().flatMap(e -> e.dependencies.stream()).filter(e -> e instanceof ConfigurationData.MavenDependency).map(e -> (ConfigurationData.MavenDependency)e).filter(e -> e.mavenNotation.group.equals("net.minecraft") && (e.mavenNotation.module.startsWith("mappings_") || e.mavenNotation.module.startsWith("official_"))).findFirst();
            mappings.ifPresent(e -> {
                LOGGER.info("Found MCP mappings.");
                FG3McpMappingData fg3MappingData = new FG3McpMappingData();
                fg3MappingData.mappingsArtifact = e.mavenNotation;
                fg3MappingData.mappingsZip = e.classes;
                projectData.extraData.put(FG3McpMappingData.class, fg3MappingData);
            });
            if (!mappings.isPresent()) {
                LOGGER.warn("MCP Mappings not found in project!");
            }
        }
    }

    public static class FG2 {
        public static void build(Project project, PluginData pluginData, ProjectData projectData) {
            projectData.extraData.put(FG2Data.class, FG2.buildForgeProjectData(project, pluginData));
            projectData.extraData.put(FG2McpMappingData.class, FG2.buildMappingData(project));
        }

        private static FG2Data buildForgeProjectData(Project project, PluginData pluginData) {
            FG2Data data = new FG2Data();
            Object baseExtension = project.getExtensions().getByName("minecraft");
            data.mcpMappings = (String)FGDataBuilder.getProperty(baseExtension, "mappings");
            data.mcVersion = (String)FGDataBuilder.getProperty(baseExtension, "version");
            data.forgeVersion = !pluginData.pluginIds.contains("net.minecraftforge.gradle.patcher") ? (String)FGDataBuilder.getProperty(baseExtension, "forgeVersion") : String.valueOf(project.getVersion());
            for (Jar task : project.getTasks().withType(Jar.class)) {
                Attributes attribs = task.getManifest().getAttributes();
                String cm = (String)attribs.get((Object)"FMLCorePlugin");
                String tweaker = (String)attribs.get((Object)"TweakClass");
                if (cm != null) {
                    data.fmlCoreMods.add(cm);
                }
                if (tweaker == null) continue;
                data.tweakClasses.add(tweaker);
            }
            return data;
        }

        private static FG2McpMappingData buildMappingData(Project project) {
            FG2McpMappingData data = new FG2McpMappingData();
            ConfigurationContainer configurations = project.getConfigurations();
            TaskContainer tasks = project.getTasks();
            Task genSrgs = tasks.getByName("genSrgs");
            Task mergeJars = tasks.getByName("mergeJars");
            if (!genSrgs.getState().getExecuted() || !mergeJars.getState().getExecuted()) {
                throw new RuntimeException("GenSrgs or MergeJars did not run.");
            }
            Configuration configMappings = configurations.getByName("forgeGradleMcpMappings");
            Configuration configMcpData = configurations.getByName("forgeGradleMcpData");
            Dependency mappingsArtifact = (Dependency)ColUtils.headOption((Iterable)configMappings.getDependencies()).orElseThrow(() -> new RuntimeException("Empty."));
            Dependency mcpDataArtifact = (Dependency)ColUtils.headOption((Iterable)configMcpData.getDependencies()).orElseThrow(() -> new RuntimeException("Empty."));
            data.mappingsArtifact = FGDataBuilder.zipNotationOf(mappingsArtifact);
            data.mcpDataArtifact = FGDataBuilder.zipNotationOf(mcpDataArtifact);
            data.mappings = (File)ColUtils.headOption((Iterable)configMappings.getResolvedConfiguration().getFiles()).orElseThrow(() -> new RuntimeException("Empty"));
            data.data = (File)ColUtils.headOption((Iterable)configMcpData.getResolvedConfiguration().getFiles()).orElseThrow(() -> new RuntimeException("Empty"));
            data.mergedJar = (File)FGDataBuilder.getProperty(mergeJars, "outJar");
            data.notchToSrg = ((File)FGDataBuilder.getProperty(genSrgs, "notchToSrg")).getAbsoluteFile();
            data.notchToMcp = ((File)FGDataBuilder.getProperty(genSrgs, "notchToMcp")).getAbsoluteFile();
            data.mcpToNotch = ((File)FGDataBuilder.getProperty(genSrgs, "mcpToNotch")).getAbsoluteFile();
            data.srgToMcp = ((File)FGDataBuilder.getProperty(genSrgs, "srgToMcp")).getAbsoluteFile();
            data.mcpToSrg = ((File)FGDataBuilder.getProperty(genSrgs, "mcpToSrg")).getAbsoluteFile();
            return data;
        }
    }
}

