/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.forge.gradle;

import java.io.Serializable;
import net.covers1624.wt.api.event.VersionedClass;
import org.jetbrains.annotations.Nullable;

@VersionedClass(value=1)
public class FGVersion
implements Serializable {
    public static final FGVersion UNKNOWN = new FGVersion("unknown");
    public static final FGVersion FG22 = new FGVersion("2.2");
    public static final FGVersion FG23 = new FGVersion("2.3");
    public static final FGVersion FG30 = new FGVersion("3.0");
    public static final FGVersion FG40 = new FGVersion("4.0", FG30);
    public static final FGVersion FG41 = new FGVersion("4.1", FG30);
    public static final FGVersion FG50 = new FGVersion("5.0", FG30);
    public static final FGVersion FG51 = new FGVersion("5.1", FG30);
    public static final FGVersion FG60 = new FGVersion("6.0", FG30);
    public static final FGVersion FG61 = new FGVersion("6.1", FG30);
    public final String version;
    @Nullable
    public final FGVersion effectiveVersion;

    public FGVersion(String version) {
        this(version, null);
    }

    public FGVersion(String version, @Nullable FGVersion effectiveVersion) {
        this.version = version;
        this.effectiveVersion = effectiveVersion;
    }

    public boolean isFG2() {
        return this.equals(FG22) || this.equals(FG23);
    }

    public boolean isFG3Compatible() {
        return this.equals(FG30) || this.effectiveVersion.equals(FG30);
    }

    public String toString() {
        return this.version;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof FGVersion)) {
            return false;
        }
        return ((FGVersion)obj).version.equals(this.version);
    }
}

