/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.gradle.databuild;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.wstool.gradle.LookupCache;
import net.covers1624.wstool.gradle.ProjectBuilder;
import net.covers1624.wstool.gradle.api.data.ConfigurationData;
import net.covers1624.wstool.gradle.api.data.ConfigurationList;
import net.covers1624.wstool.gradle.api.data.Data;
import net.covers1624.wstool.gradle.api.data.ProjectData;
import net.covers1624.wstool.gradle.api.data.SourceSetData;
import net.covers1624.wstool.gradle.api.data.SourceSetList;
import net.covers1624.wstool.gradle.databuild.SourceSetDataBuilder;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nullable;

public class ConfigurationDataBuilder
implements ProjectBuilder {
    private Project project;
    private LookupCache lookupCache;
    private ConfigurationList configurationsData;

    @Override
    public void buildProjectData(Project project, ProjectData projectData, LookupCache lookupCache) {
        this.project = project;
        this.lookupCache = lookupCache;
        this.configurationsData = (ConfigurationList)projectData.putData(ConfigurationList.class, (Data)new ConfigurationList());
        SourceSetContainer sourceSetContainer = SourceSetDataBuilder.getSourceSetContainer(project);
        if (sourceSetContainer == null) {
            return;
        }
        SourceSetList sourceSets = (SourceSetList)projectData.getData(SourceSetList.class);
        if (sourceSets == null) {
            throw new RuntimeException("SourceSets not extracted prior to Configurations.");
        }
        ConfigurationContainer configurations = project.getConfigurations();
        ArrayList extraConfigurations = FastStream.of((Iterable)lookupCache.additionalConfigurations.getOrDefault(project, Collections.emptyList())).map(arg_0 -> ((ConfigurationContainer)configurations).findByName(arg_0)).filter(Objects::nonNull).toList();
        HashMap<Configuration, List<Dependency>> toRemove = new HashMap<Configuration, List<Dependency>>();
        sourceSets.asMap().values().forEach(e -> {
            this.extractProjectDependencies(project, toRemove, configurations.getAt(e.compileClasspathConfiguration), this.getOrCreate(e.compileClasspathConfiguration));
            this.extractProjectDependencies(project, toRemove, configurations.getAt(e.runtimeClasspathConfiguration), this.getOrCreate(e.runtimeClasspathConfiguration));
        });
        for (Configuration extra : extraConfigurations) {
            this.extractProjectDependencies(project, toRemove, extra, this.getOrCreate(extra.getName()));
        }
        toRemove.forEach((config, deps) -> deps.forEach(arg_0 -> config.getDependencies().remove(arg_0)));
        sourceSets.asMap().values().forEach(e -> {
            SourceSet ss = (SourceSet)sourceSetContainer.getByName(e.name);
            this.extractDependencies(ss.getCompileClasspath().minus((FileCollection)ss.getOutput()), configurations.getAt(e.compileClasspathConfiguration), this.getOrCreate(e.compileClasspathConfiguration));
            this.extractDependencies(ss.getRuntimeClasspath().minus((FileCollection)ss.getOutput()), configurations.getAt(e.runtimeClasspathConfiguration), this.getOrCreate(e.runtimeClasspathConfiguration));
        });
        for (Configuration extra : extraConfigurations) {
            this.extractDependencies((FileCollection)project.files(new Object[0]), extra, this.getOrCreate(extra.getName()));
        }
    }

    private void extractProjectDependencies(Project project, Map<Configuration, List<Dependency>> toRemove, Configuration configuration, ConfigurationData data) {
        for (Configuration config : configuration.getHierarchy()) {
            if (config.getName().startsWith("neoGradleDependencyReplacement")) continue;
            for (Dependency dependency : config.getDependencies()) {
                ConfigurationData.Dependency dep = this.consumeRawDependency(project, dependency);
                if (dep == null) continue;
                data.dependencies.add(dep);
                toRemove.computeIfAbsent(config, e -> new ArrayList()).add(dependency);
            }
        }
    }

    private void extractDependencies(FileCollection classpath, Configuration configuration, ConfigurationData data) {
        HashSet<SourceSetData> sourceSetDeps = new HashSet<SourceSetData>();
        for (File file : classpath) {
            SourceSetData dep = this.lookupCache.sourceSetOutputs.get(file);
            if (dep == null) continue;
            sourceSetDeps.add(dep);
        }
        for (SourceSetData sourceSetDep : sourceSetDeps) {
            data.dependencies.add(new ConfigurationData.SourceSetDependency(sourceSetDep));
        }
        ResolvedConfiguration resolved = configuration.getResolvedConfiguration();
        data.dependencies.addAll(this.buildMavenDependencies(resolved.getFirstLevelModuleDependencies()));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ConfigurationData.Dependency consumeRawDependency(Project project, Dependency dep) {
        if (dep instanceof ProjectDependency) {
            return this.processProjectDep(project, (ProjectDependency)dep);
        }
        if (dep instanceof FileCollectionDependency) {
            return this.processFileColDep((FileCollectionDependency)dep);
        }
        return null;
    }

    private ConfigurationData.ProjectDependency processProjectDep(Project rootProject, ProjectDependency projectDep) {
        Project project = this.getDependencyProject(rootProject, projectDep);
        ProjectData projectData = Objects.requireNonNull(this.lookupCache.projects.get(project.getPath()), "Project missing from lookup! " + project);
        return new ConfigurationData.ProjectDependency(projectData);
    }

    @Nullable
    private ConfigurationData.Dependency processFileColDep(FileCollectionDependency fileColDep) {
        FileCollection fileCol = fileColDep.getFiles();
        if (fileCol instanceof SourceSetOutput) {
            return this.processSourceSetDep((SourceSetOutput)fileCol);
        }
        Set files = fileCol.getFiles();
        files.removeIf(e -> e.getPath().contains("ng_dummy_ng"));
        if (!files.isEmpty()) {
            return new ConfigurationData.FilesDependency((Iterable)files);
        }
        return null;
    }

    private ConfigurationData.SourceSetDependency processSourceSetDep(SourceSetOutput output) {
        SourceSetData sourceSetData = Objects.requireNonNull(this.lookupCache.sourceSets.get(output), "SourceSetOutput missing from lookup!");
        return new ConfigurationData.SourceSetDependency(sourceSetData);
    }

    private List<ConfigurationData.MavenDependency> buildMavenDependencies(Iterable<ResolvedDependency> dependencies) {
        DependencyHandler depHandler = this.project.getDependencies();
        LinkedList<ConfigurationData.MavenDependency> builtDeps = new LinkedList<ConfigurationData.MavenDependency>();
        for (ResolvedDependency dep : dependencies) {
            ConfigurationData.MavenDependency primaryDep;
            ArrayList<ConfigurationData.MavenDependency> nestedDeps = new ArrayList<ConfigurationData.MavenDependency>();
            for (ResolvedArtifact artifact : dep.getModuleArtifacts()) {
                MavenNotation notation = new MavenNotation(dep.getModuleGroup(), dep.getModuleName(), dep.getModuleVersion(), artifact != null ? artifact.getClassifier() : null, artifact != null ? (artifact.getExtension() != null ? artifact.getExtension() : "jar") : "jar");
                ConfigurationData.MavenDependency dependency = new ConfigurationData.MavenDependency(notation);
                if (artifact != null) {
                    dependency.files.put("classes", artifact.getFile());
                    ArtifactResolutionResult result = depHandler.createArtifactResolutionQuery().forComponents(new ComponentIdentifier[]{artifact.getId().getComponentIdentifier()}).withArtifacts(JvmLibrary.class, new Class[]{SourcesArtifact.class, JavadocArtifact.class}).execute();
                    Set results = result.getResolvedComponents();
                    if (!results.isEmpty()) {
                        ComponentArtifactsResult r = (ComponentArtifactsResult)ColUtils.only((Iterable)results);
                        File sources = ConfigurationDataBuilder.getArtifactFile(r, SourcesArtifact.class);
                        File javadoc = ConfigurationDataBuilder.getArtifactFile(r, JavadocArtifact.class);
                        if (sources != null) {
                            dependency.files.put("sources", sources);
                        }
                        if (javadoc != null) {
                            dependency.files.put("javadoc", javadoc);
                        }
                    }
                }
                nestedDeps.add(dependency);
            }
            if (nestedDeps.size() == 1) {
                primaryDep = (ConfigurationData.MavenDependency)nestedDeps.get(0);
            } else {
                primaryDep = new ConfigurationData.MavenDependency(new MavenNotation(dep.getModuleGroup(), dep.getModuleName(), dep.getModuleVersion(), null, "pom"));
                primaryDep.children.addAll(nestedDeps);
            }
            primaryDep.children.addAll(this.buildMavenDependencies(dep.getChildren()));
            builtDeps.add(primaryDep);
        }
        return builtDeps;
    }

    @Nullable
    private static File getArtifactFile(ComponentArtifactsResult ar, Class<? extends Artifact> type) {
        Set sa = ar.getArtifacts(type);
        if (sa.isEmpty()) {
            return null;
        }
        ArtifactResult a = (ArtifactResult)ColUtils.only((Iterable)sa);
        if (!(a instanceof ResolvedArtifactResult)) {
            return null;
        }
        return ((ResolvedArtifactResult)a).getFile();
    }

    private ConfigurationData getOrCreate(String name) {
        return (ConfigurationData)this.configurationsData.computeIfAbsent(name, ConfigurationData::new);
    }

    private Project getDependencyProject(Project rootProject, ProjectDependency dep) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.11")) >= 0) {
            return rootProject.project(dep.getPath());
        }
        return (Project)InvokerHelper.getProperty((Object)dep, (String)"dependencyProject");
    }
}

