/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.gradle.databuild;

import net.covers1624.wstool.gradle.LookupCache;
import net.covers1624.wstool.gradle.ProjectBuilder;
import net.covers1624.wstool.gradle.api.data.Data;
import net.covers1624.wstool.gradle.api.data.JavaToolchainData;
import net.covers1624.wstool.gradle.api.data.ProjectData;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nullable;

public class ProjectToolchainDataBuilder
implements ProjectBuilder {
    @Override
    public void buildProjectData(Project project, ProjectData projectData, LookupCache lookupCache) {
        JavaToolchainData data = null;
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.7")) >= 0) {
            data = ProjectToolchainDataBuilder.extractViaPluginToolchainSpec(project);
        }
        if (data != null) {
            projectData.putData(JavaToolchainData.class, (Data)data);
        }
    }

    @Nullable
    private static JavaToolchainData extractViaPluginToolchainSpec(Project project) {
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        if (java == null) {
            return null;
        }
        JavaToolchainSpec toolchainSpec = java.getToolchain();
        if (!toolchainSpec.getLanguageVersion().isPresent()) {
            return null;
        }
        return new JavaToolchainData(((JavaLanguageVersion)toolchainSpec.getLanguageVersion().get()).asInt());
    }
}

