/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.gradle;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.wstool.gradle.LookupCache;
import net.covers1624.wstool.gradle.PluginBuilder;
import net.covers1624.wstool.gradle.ProjectBuilder;
import net.covers1624.wstool.gradle.ProjectTransformer;
import net.covers1624.wstool.gradle.api.ModelProperties;
import net.covers1624.wstool.gradle.api.WorkspaceToolModel;
import net.covers1624.wstool.gradle.api.data.Data;
import net.covers1624.wstool.gradle.api.data.PluginData;
import net.covers1624.wstool.gradle.api.data.ProjectData;
import net.covers1624.wstool.gradle.api.data.SubProjectList;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.jetbrains.annotations.Nullable;

public class WorkspaceToolModelBuilder
implements ParameterizedToolingModelBuilder<ModelProperties> {
    public Object buildAll(String modelName, ModelProperties properties, Project project) {
        try {
            ClassLoader cl = WorkspaceToolModelBuilder.class.getClassLoader();
            ArrayList pluginBuilders = FastStream.of(ServiceLoader.load(PluginBuilder.class, cl)).toList();
            ArrayList projectBuilders = FastStream.of(ServiceLoader.load(ProjectBuilder.class, cl)).toList();
            ArrayList projectTransformers = FastStream.of(ServiceLoader.load(ProjectTransformer.class, cl)).toList();
            LookupCache lookupCache = new LookupCache();
            ProjectData projectData = WorkspaceToolModelBuilder.buildProjectTree(project, null, pluginBuilders, lookupCache);
            for (ProjectTransformer transformer : projectTransformers) {
                lookupCache.projects.forEach((proj, data) -> transformer.transformProject(project.findProject(proj), (ProjectData)data));
            }
            for (ProjectBuilder builder : projectBuilders) {
                lookupCache.projects.forEach((proj, data) -> builder.buildProjectData(project.findProject(proj), (ProjectData)data, lookupCache));
            }
            try (ObjectOutputStream os = new ObjectOutputStream(Files.newOutputStream(IOUtils.makeParents((Path)properties.getOutputFile().toPath()), new OpenOption[0]));){
                os.writeObject(projectData);
            }
        }
        catch (Throwable ex) {
            project.getLogger().error("Fatal error building model.");
            project.getLogger().error("If this is a Java 8 Gradle instance, this may crash WorkspaceTool with a serialization error.");
            project.getLogger().error("", ex);
            throw new RuntimeException("Fatal exception building model.", ex);
        }
        return new WorkspaceToolModel.Dummy();
    }

    public Class<ModelProperties> getParameterType() {
        return ModelProperties.class;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(WorkspaceToolModel.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        throw new UnsupportedOperationException();
    }

    private static ProjectData buildProjectTree(Project project, @Nullable ProjectData parent, List<PluginBuilder> pluginBuilders, LookupCache lookupCache) {
        ProjectData projectData = new ProjectData(project.getName(), project.getProjectDir(), parent, String.valueOf(project.getVersion()), String.valueOf(project.getGroup()), String.valueOf(project.findProperty("archivesBaseName")));
        projectData.putData(PluginData.class, (Data)WorkspaceToolModelBuilder.buildPlugins(project, pluginBuilders, lookupCache));
        if (lookupCache.projects.containsKey(project.getPath())) {
            throw new IllegalStateException("Already visited project: " + project);
        }
        lookupCache.projects.put(project.getPath(), projectData);
        SubProjectList subProjectData = new SubProjectList();
        for (Project subProj : project.getSubprojects()) {
            subProjectData.put(subProj.getName(), (Data)WorkspaceToolModelBuilder.buildProjectTree(subProj, projectData, pluginBuilders, lookupCache));
        }
        projectData.putData(SubProjectList.class, (Data)subProjectData);
        return projectData;
    }

    private static PluginData buildPlugins(Project project, List<PluginBuilder> dataBuilders, LookupCache lookupCache) {
        PluginContainer plugins = project.getPlugins();
        Map<String, String> pluginMap = WorkspaceToolModelBuilder.getPluginMap(plugins);
        PluginData data = new PluginData();
        FastStream.of((Iterable)plugins).map(Object::getClass).map(Class::getName).forEach(cName -> data.plugins.put(pluginMap.getOrDefault(cName, (String)cName), cName));
        List additional = lookupCache.additionalConfigurations.computeIfAbsent(project, e -> new ArrayList());
        for (PluginBuilder builder : dataBuilders) {
            builder.buildPluginData(project, data, additional);
        }
        return data;
    }

    private static Map<String, String> getPluginMap(PluginContainer plugins) {
        HashMap<String, String> classToName = new HashMap<String, String>();
        HashSet<String> parsed = new HashSet<String>();
        for (Plugin plugin : plugins) {
            try {
                block29: for (URL url : ColUtils.iterable(plugin.getClass().getClassLoader().getResources("META-INF/gradle-plugins"))) {
                    Path resourcePath;
                    FileSystem fs;
                    String f = url.getFile();
                    if (!parsed.add(f)) continue;
                    switch (url.getProtocol()) {
                        case "jar": {
                            int sep = f.indexOf("!/");
                            fs = IOUtils.getJarFileSystem((URI)URI.create(f.substring(0, sep)), (boolean)false);
                            resourcePath = fs.getPath(f.substring(sep + 1), new String[0]);
                            break;
                        }
                        case "file": {
                            fs = null;
                            resourcePath = Paths.get(f, new String[0]);
                            break;
                        }
                        default: {
                            continue block29;
                        }
                    }
                    if (Files.notExists(resourcePath, new LinkOption[0])) continue;
                    try (Stream<Path> s = Files.walk(resourcePath, new FileVisitOption[0]);){
                        for (Path path : s::iterator) {
                            if (!Files.isRegularFile(path, new LinkOption[0]) || !path.getFileName().toString().endsWith(".properties")) continue;
                            String pName = path.getFileName().toString().replace(".properties", "");
                            InputStream is = Files.newInputStream(path, new OpenOption[0]);
                            Throwable throwable = null;
                            try {
                                Properties properties = new Properties();
                                properties.load(is);
                                String cName = properties.getProperty("implementation-class");
                                if (classToName.containsKey(cName)) continue;
                                classToName.put(cName, pName);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (is == null) continue;
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                is.close();
                            }
                        }
                    }
                    if (fs == null) continue;
                    fs.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to read plugin metadata.", ex);
            }
        }
        return classToName;
    }
}

