/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.gradle.databuild;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import net.covers1624.wstool.gradle.LookupCache;
import net.covers1624.wstool.gradle.ProjectBuilder;
import net.covers1624.wstool.gradle.api.data.Data;
import net.covers1624.wstool.gradle.api.data.ProjectData;
import net.covers1624.wstool.gradle.api.data.SourceSetData;
import net.covers1624.wstool.gradle.api.data.SourceSetList;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtensionsSchema;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nullable;

public class SourceSetDataBuilder
implements ProjectBuilder {
    @Override
    public void buildProjectData(Project project, ProjectData projectData, LookupCache lookupCache) {
        SourceSetList sourceSetData = new SourceSetList();
        projectData.putData(SourceSetList.class, (Data)sourceSetData);
        SourceSetContainer sourceSets = SourceSetDataBuilder.getSourceSetContainer(project);
        if (sourceSets == null) {
            return;
        }
        for (SourceSet sourceSet : sourceSets) {
            SourceSetData data = new SourceSetData(sourceSet.getName(), sourceSet.getCompileClasspathConfigurationName(), sourceSet.getRuntimeClasspathConfigurationName());
            data.sourceMap.put("resources", SourceSetDataBuilder.getFiles(sourceSet.getResources()));
            data.sourceMap.put("java", SourceSetDataBuilder.getFiles(sourceSet.getJava()));
            SourceSetDataBuilder.addSourcesFromExtension(sourceSet, data);
            SourceSetDataBuilder.addSourcesFromConvention(sourceSet, data);
            sourceSetData.put(sourceSet.getName(), (Data)data);
            SourceSetOutput output = sourceSet.getOutput();
            SourceSetData existingLookup = lookupCache.sourceSets.get(output);
            if (existingLookup != null) {
                throw new IllegalStateException("SourceSetOutput is already in lookup cache! Existing name: " + existingLookup.name + ", New Name: " + data.name);
            }
            lookupCache.sourceSets.put(output, data);
            for (File dir : output.getFiles()) {
                lookupCache.sourceSetOutputs.put(dir, data);
            }
        }
    }

    private static void addSourcesFromExtension(SourceSet sourceSet, SourceSetData data) {
        if (sourceSet instanceof ExtensionAware) {
            SourceSet extensionAware = sourceSet;
            ExtensionContainer extensions = extensionAware.getExtensions();
            for (ExtensionsSchema.ExtensionSchema schema : extensions.getExtensionsSchema()) {
                String name = schema.getName();
                Object extension = extensions.findByName(name);
                if (data.sourceMap.containsKey(name) || !(extension instanceof SourceDirectorySet)) continue;
                data.sourceMap.put(name, SourceSetDataBuilder.getFiles((SourceDirectorySet)extension));
            }
        }
    }

    private static void addSourcesFromConvention(SourceSet sourceSet, SourceSetData data) {
        try {
            Object convention = InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
            if (convention == null) {
                return;
            }
            Map plugins = (Map)SneakyUtils.unsafeCast((Object)InvokerHelper.getProperty((Object)convention, (String)"plugins"));
            Object scalaSS = plugins.get("scala");
            if (scalaSS != null && !data.sourceMap.containsKey("scala")) {
                data.sourceMap.put("scala", SourceSetDataBuilder.getFiles((SourceDirectorySet)SneakyUtils.unsafeCast((Object)InvokerHelper.getProperty(scalaSS, (String)"scala"))));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static List<File> getFiles(SourceDirectorySet set) {
        return FastStream.of((Iterable)set.getSrcDirs()).map(File::getAbsoluteFile).toList();
    }

    @Nullable
    public static SourceSetContainer getSourceSetContainer(Project project) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.1")) >= 0) {
            return SourceSetDataBuilder.getSourceSetContainerExtension(project);
        }
        return SourceSetDataBuilder.getSourceSetContainerConvention(project);
    }

    @Nullable
    private static SourceSetContainer getSourceSetContainerExtension(Project project) {
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        return java != null ? java.getSourceSets() : null;
    }

    @Nullable
    private static SourceSetContainer getSourceSetContainerConvention(Project project) {
        try {
            Object convention = InvokerHelper.getProperty((Object)project, (String)"convention");
            Method findPlugin = convention.getClass().getMethod("findPlugin", Class.class);
            Object javaConvention = findPlugin.invoke(convention, Class.forName("org.gradle.api.plugins.JavaPluginConvention"));
            return (SourceSetContainer)InvokerHelper.getProperty((Object)javaConvention, (String)"sourceSets");
        }
        catch (Throwable e) {
            return null;
        }
    }
}

