/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.gradle.builder;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.wt.gradle.builder.ConfigurationVisitor;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.jetbrains.annotations.Nullable;

public class ConfigurationWalker {
    private static final Set<String> HACKY_CONFIGURATION_EXCLUDE = new HashSet<String>(Arrays.asList("modDevBundle", "modDevConfig", "modDevApiElements", "modDevRuntimeElements", "modDevModulePath", "modDevTestFixtures"));
    private final Project project;
    private final DependencyHandler dependencyHandler;

    public ConfigurationWalker(Project project) {
        this.project = project;
        this.dependencyHandler = project.getDependencies();
    }

    public void walkTree(Configuration config, ConfigurationVisitor visitor, ResolveOptions ... options) {
        this.walkTree(Collections.singleton(config), visitor, options);
    }

    public void walkTree(Iterable<Configuration> configs, ConfigurationVisitor visitor, ResolveOptions ... options) {
        HashSet<String> seen = new HashSet<String>();
        LinkedList queue = new LinkedList();
        configs.forEach(queue::push);
        LinkedList<Configuration> toWalk = new LinkedList<Configuration>();
        while (!queue.isEmpty()) {
            Configuration config = (Configuration)queue.pop();
            if (!seen.add(config.getName())) continue;
            queue.addAll(config.getExtendsFrom());
            toWalk.add(config);
        }
        this.walk(toWalk, visitor, options);
    }

    public void walk(Iterable<Configuration> configs, ConfigurationVisitor visitor, ResolveOptions ... options) {
        HashSet optSet = new HashSet();
        Collections.addAll(optSet, options);
        List extraArtifacts = optSet.stream().map(e -> e.artifact).filter(Objects::nonNull).collect(Collectors.toList());
        for (Configuration config : configs) {
            if (HACKY_CONFIGURATION_EXCLUDE.contains(config.getName()) || config.getName().startsWith("neoForgeInstallerToolnet_neoforged")) continue;
            visitor.visitStart(config);
            if (config.isCanBeResolved() || optSet.contains((Object)ResolveOptions.FORCE)) {
                Object dependency2;
                if (!(config = config.copy()).isCanBeResolved()) {
                    config.setCanBeResolved(true);
                    config.setCanBeConsumed(true);
                }
                if (!this.project.getRootProject().getName().equals("NeoForge")) {
                    config.getDependencies().removeIf(e -> {
                        if (e instanceof ModuleDependency) {
                            ModuleDependency dep = (ModuleDependency)e;
                            return "net.neoforged".equals(dep.getGroup()) && "neoforge".equals(dep.getName());
                        }
                        return false;
                    });
                }
                HashMap<ComponentArtifactIdentifier, ResolvedArtifactResult> resolvedArtifacts = new HashMap<ComponentArtifactIdentifier, ResolvedArtifactResult>();
                HashMap resolvedAuxiliary = new HashMap();
                for (Object dependency2 : config.getAllDependencies()) {
                    if (dependency2 instanceof FileCollectionDependency) {
                        FileCollectionDependency dep = (FileCollectionDependency)dependency2;
                        if (dep.getFiles() instanceof SourceSetOutput) {
                            visitor.visitSourceSetDependency((SourceSetOutput)dep.getFiles());
                            continue;
                        }
                        this.project.getLogger().warn("Unknown file collection dependency type: {}", (Object)dependency2.getClass().getName());
                        continue;
                    }
                    if (dependency2 instanceof ProjectDependency) {
                        visitor.visitProjectDependency(((ProjectDependency)dependency2).getDependencyProject());
                        continue;
                    }
                    if (dependency2 instanceof ModuleDependency) continue;
                    this.project.getLogger().warn("Unknown dependency type: {}", (Object)dependency2.getClass().getName());
                }
                boolean lenient = optSet.contains((Object)ResolveOptions.LENIENT);
                dependency2 = config.getIncoming().artifactView(e -> e.setLenient(lenient)).getArtifacts().iterator();
                while (dependency2.hasNext()) {
                    ResolvedArtifactResult artifact = (ResolvedArtifactResult)dependency2.next();
                    resolvedArtifacts.put(artifact.getId(), artifact);
                }
                List components = resolvedArtifacts.keySet().stream().filter(e -> e.getComponentIdentifier() instanceof ModuleComponentIdentifier).map(e -> (ModuleComponentIdentifier)e.getComponentIdentifier()).collect(Collectors.toList());
                if (!extraArtifacts.isEmpty()) {
                    ArtifactResolutionResult result = this.dependencyHandler.createArtifactResolutionQuery().forComponents(components).withArtifacts(JvmLibrary.class, extraArtifacts).execute();
                    for (ComponentArtifactsResult ar : result.getResolvedComponents()) {
                        for (Class type : extraArtifacts) {
                            for (ArtifactResult artifact : ar.getArtifacts(type)) {
                                if (!(artifact instanceof ResolvedArtifactResult)) continue;
                                resolvedAuxiliary.computeIfAbsent(ar.getId(), e -> new HashMap()).computeIfAbsent(type, e -> new HashSet()).add((ResolvedArtifactResult)artifact);
                            }
                        }
                    }
                }
                for (Map.Entry entry : resolvedArtifacts.entrySet()) {
                    ResolvedArtifactResult value = (ResolvedArtifactResult)entry.getValue();
                    ComponentIdentifier componentIdentifier = value.getId().getComponentIdentifier();
                    if (!(componentIdentifier instanceof ModuleComponentIdentifier)) continue;
                    ModuleComponentIdentifier moduleIdentifier = (ModuleComponentIdentifier)componentIdentifier;
                    Set sourceArtifacts = resolvedAuxiliary.getOrDefault(componentIdentifier, Collections.emptyMap()).getOrDefault(SourcesArtifact.class, Collections.emptySet());
                    Set javadocArtifacts = resolvedAuxiliary.getOrDefault(componentIdentifier, Collections.emptyMap()).getOrDefault(JavadocArtifact.class, Collections.emptySet());
                    MavenNotation notation = MavenNotation.parse((String)moduleIdentifier.toString());
                    if (value.getId() instanceof DefaultModuleComponentArtifactIdentifier) {
                        DefaultModuleComponentArtifactIdentifier id = (DefaultModuleComponentArtifactIdentifier)value.getId();
                        IvyArtifactName ivyName = id.getName();
                        notation = notation.withClassifier(ivyName.getClassifier());
                        notation = notation.withExtension(ConfigurationWalker.isEmpty(ivyName.getExtension()) ? "jar" : ivyName.getExtension());
                    }
                    File classes = value.getFile().getAbsoluteFile();
                    File sources = ColUtils.headOption(sourceArtifacts).map(e -> e.getFile().getAbsoluteFile()).orElse(null);
                    File javadoc = ColUtils.headOption(javadocArtifacts).map(e -> e.getFile().getAbsoluteFile()).orElse(null);
                    visitor.visitModuleDependency(notation, classes, sources, javadoc);
                }
            }
            visitor.visitEnd();
        }
    }

    private static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static enum ResolveOptions {
        FORCE,
        LENIENT,
        SOURCES(SourcesArtifact.class),
        JAVADOC(JavadocArtifact.class);

        @Nullable
        public final Class<? extends Artifact> artifact;

        private ResolveOptions() {
            this(null);
        }

        private ResolveOptions(Class<? extends Artifact> artifact) {
            this.artifact = artifact;
        }
    }
}

