/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.gradle.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.util.SneakyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.gradle.api.Plugin;
import org.gradle.api.plugins.PluginContainer;
import org.jetbrains.annotations.Nullable;

public class PluginResolver {
    public static Map<String, String> extractPlugins(PluginContainer container) {
        HashMap<String, String> classToName = new HashMap<String, String>();
        for (Plugin plugin : container) {
            try {
                Class<?> pluginClass = plugin.getClass();
                Enumeration<URL> urls = pluginClass.getClassLoader().getResources("META-INF/gradle-plugins/");
                for (URL url : ColUtils.iterable(urls)) {
                    Path folder;
                    FileSystem fs;
                    if (url.getProtocol().equals("jar")) {
                        String root = PluginResolver.extractRoot(url, "/META-INF/gradle-plugins/");
                        fs = IOUtils.getJarFileSystem((Path)Paths.get(root, new String[0]), (boolean)true);
                        folder = fs.getPath("/META-INF/gradle-plugins/", new String[0]);
                    } else {
                        if (!url.getProtocol().equals("file")) continue;
                        fs = IOUtils.protectClose((FileSystem)FileSystems.getDefault());
                        folder = fs.getPath(url.getFile(), new String[0]);
                    }
                    Files.walk(folder, new FileVisitOption[0]).forEach(SneakyUtils.sneak(p -> {
                        if (Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".properties")) {
                            String pluginName = p.getFileName().toString().replace(".properties", "");
                            try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                                Properties properties = new Properties();
                                properties.load(is);
                                String clsName = properties.getProperty("implementation-class");
                                if (!classToName.containsKey(clsName)) {
                                    classToName.put(clsName, StringUtils.removeStart((String)pluginName, (String)"org.gradle."));
                                }
                            }
                        }
                    }));
                    fs.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return classToName;
    }

    @Nullable
    public static String extractRoot(URL resourceURL, String resourcePath) {
        if (!StringUtils.startsWith((CharSequence)resourcePath, (CharSequence)"/") && !StringUtils.startsWith((CharSequence)resourcePath, (CharSequence)"\\")) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = PluginResolver.urlToFile(resourceURL).getPath();
            String testPath = path.replace('\\', '/');
            if (StringUtils.endsWithIgnoreCase((CharSequence)testPath, (CharSequence)(testResourcePath = resourcePath.replace('\\', '/')))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = PluginResolver.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.getLeft() != null) {
                resultPath = ((String)paths.getLeft()).replace("\\", "/");
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            return null;
        }
        return StringUtils.removeEnd(resultPath, (String)"/");
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block6: {
            int pivot = url.indexOf("!/");
            if (pivot < 0) {
                return null;
            }
            resourcePath = url.substring(pivot + 2);
            jarPath = url.substring(0, pivot);
            if (jarPath.startsWith("jar:")) {
                jarPath = jarPath.substring("jar".length() + 1);
            }
            if (jarPath.startsWith("file")) {
                try {
                    jarPath = PluginResolver.urlToFile(new URL(jarPath)).getPath().replace('\\', '/');
                }
                catch (Exception e) {
                    jarPath = jarPath.substring("file".length());
                    if (jarPath.startsWith("://")) {
                        jarPath = jarPath.substring("://".length());
                    }
                    if (!StringUtils.startsWith((CharSequence)jarPath, (CharSequence)":")) break block6;
                    jarPath = jarPath.substring(1);
                }
            }
        }
        return Pair.of((Object)jarPath, (Object)resourcePath);
    }

    public static File urlToFile(URL url) {
        try {
            return new File(url.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL='" + url + "'", e);
        }
    }
}

