/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.gradle;

import com.google.common.base.Suppliers;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.gson.JsonUtils;
import net.covers1624.quack.io.ConsumingOutputStream;
import net.covers1624.quack.util.HashUtils;
import net.covers1624.wstool.api.Environment;
import net.covers1624.wstool.api.HashContainer;
import net.covers1624.wstool.api.JdkProvider;
import net.covers1624.wstool.gradle.api.WorkspaceToolModelAction;
import net.covers1624.wstool.gradle.api.data.ProjectData;
import net.covers1624.wstool.gradle.api.data.SubProjectList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Task;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nullable;

public class GradleModelExtractor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String GRADLE_PLUGIN_CLASS = "net.covers1624.wstool.gradle.WorkspaceToolGradlePlugin";
    private static final Pattern WRAPPER_URL_REGEX = Pattern.compile("gradle-(.*)(?>-bin|-all).zip$");
    private static final GradleVersion MIN_GRADLE_VERSION = GradleVersion.version((String)"4.10.3");
    private static final GradleVersion MIN_GRADLE_USE_J16 = GradleVersion.version((String)"7.0");
    private static final GradleVersion MIN_GRADLE_USE_J17 = GradleVersion.version((String)"7.3");
    private final Supplier<List<Path>> gradleClassPath = Suppliers.memoize(this::buildClassPath);
    private final Supplier<String> gradleClassPathHash = Suppliers.memoize(this::hashGradleClassPath);
    private final Supplier<Path> initScriptPath = Suppliers.memoize(this::buildInitScript);
    private final Environment env;
    private final JdkProvider jdkProvider;
    private final List<String> hashableFiles = new ArrayList<String>(List.of("buildSrc/build.gradle", "buildSrc/settings.gradle", "build.gradle", "settings.gradle", "gradle.properties", "build.properties", "gradle/wrapper/gradle-wrapper.properties"));
    private static final Gson GSON = new Gson();
    private static final Type LIST_STRING = new TypeToken<List<String>>(){}.getType();

    public GradleModelExtractor(Environment env, JdkProvider jdkProvider, List<String> hashableFiles) {
        this.env = env;
        this.jdkProvider = jdkProvider;
        this.hashableFiles.addAll(hashableFiles);
    }

    public ProjectData extractProjectData(Path project, Set<String> extraTasks) {
        return this.extractProjectData(project, GradleModelExtractor.computeProjectGradleVersion(project), extraTasks);
    }

    public ProjectData extractProjectData(Path project, GradleVersion gradleVersion, Set<String> extraTasks) {
        Path gradleCacheDir = this.env.projectCache().resolve("gradle");
        Path cacheFile = gradleCacheDir.resolve(this.env.projectRoot().relativize(project).toString().replaceAll("[/\\\\]", "_") + ".dat");
        HashContainer container = new HashContainer(gradleCacheDir, cacheFile.getFileName().toString());
        HashContainer.Entry gradle = container.getEntry("gradle");
        gradle.putString(this.gradleClassPathHash.get());
        HashContainer.Entry outputEntry = container.getEntry("output");
        outputEntry.putFile(cacheFile);
        HashContainer.Entry hashablesCache = this.getGradleFilesCache(container, cacheFile);
        if (Files.notExists(cacheFile, new LinkOption[0]) || gradle.changed() || hashablesCache == null || hashablesCache.changed() || outputEntry.changed()) {
            JavaVersion javaVersion = GradleModelExtractor.getJavaVersionForGradle(gradleVersion);
            Path javaHome = this.jdkProvider.findOrProvisionJdk(javaVersion);
            this.extractProjectData(javaHome, project, cacheFile, gradleVersion, extraTasks);
            gradle.pushChanges();
            Objects.requireNonNull(this.getGradleFilesCache(container, cacheFile)).pushChanges();
            outputEntry.pushChanges();
        }
        return this.parseProjectData(cacheFile);
    }

    @Nullable
    private HashContainer.Entry getGradleFilesCache(HashContainer container, Path oldCache) {
        if (!Files.exists(oldCache, new LinkOption[0])) {
            return null;
        }
        List<Path> projectPaths = this.collectProjectPaths(oldCache);
        if (projectPaths.isEmpty()) {
            return null;
        }
        HashContainer.Entry entry = container.getEntry("hashables");
        FastStream.of(projectPaths).flatMap(e -> FastStream.of(this.hashableFiles).map(e::resolve).filter(x$0 -> Files.exists(x$0, new LinkOption[0]))).forEach(arg_0 -> ((HashContainer.Entry)entry).putFile(arg_0));
        return entry;
    }

    private List<Path> collectProjectPaths(Path cache) {
        try {
            return this.collectProjectPaths(this.parseProjectData(cache));
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to collect project paths.", ex);
            return List.of();
        }
    }

    private List<Path> collectProjectPaths(ProjectData data) {
        return FastStream.concat((Iterable[])new Iterable[]{FastStream.ofNullable((Object)data.projectDir.toPath()), FastStream.ofNullable((Object)((SubProjectList)data.getData(SubProjectList.class))).flatMap(e -> e.asMap().values()).flatMap(this::collectProjectPaths)}).toList();
    }

    private ProjectData parseProjectData(Path cache) {
        ProjectData projectData;
        ObjectInputStream in = new ObjectInputStream(Files.newInputStream(cache, new OpenOption[0]));
        try {
            projectData = (ProjectData)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new RuntimeException("Failed to read project data.", ex);
            }
        }
        in.close();
        return projectData;
    }

    private void extractProjectData(Path javaHome, Path projectDir, Path cacheFile, GradleVersion gradleVersion, Set<String> extraTasks) {
        GradleConnector connector = GradleConnector.newConnector().useGradleVersion(gradleVersion.getVersion()).forProjectDirectory(projectDir.toFile());
        try (ProjectConnection connection = connector.connect();){
            LOGGER.info("Starting Project data extract for {}", (Object)projectDir);
            LOGGER.info("Extracting available task information..");
            GradleProject project = (GradleProject)((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)connection.model(GradleProject.class).setJavaHome(javaHome.toFile())).setJvmArguments(new String[]{"-Xmx3G"})).setStandardOutput((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).setStandardError((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).get();
            HashSet tasksToExecute = FastStream.of((Iterable)project.getTasks()).map(Task::getName).filter(extraTasks::contains).toSet();
            LOGGER.info("Extracting WorkspaceTool project data..");
            ((BuildActionExecuter)((BuildActionExecuter)((BuildActionExecuter)((BuildActionExecuter)((BuildActionExecuter)((BuildActionExecuter)connection.action((BuildAction)new WorkspaceToolModelAction(cacheFile.toFile())).setJavaHome(javaHome.toFile())).setJvmArguments((Iterable)FastStream.of((Object)"-Xmx3G").concat(this.extraJvmArgs()))).setEnvironmentVariables((Map)ImmutableMap.copyOf(System.getenv()))).setStandardOutput((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).setStandardError((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).withArguments(new String[]{"-si", "-I", this.initScriptPath.get().toAbsolutePath().toString()})).forTasks((Iterable)tasksToExecute).run();
            connector.disconnect();
        }
    }

    protected Iterable<String> extraJvmArgs() {
        return FastStream.empty();
    }

    static GradleVersion computeProjectGradleVersion(Path project) {
        GradleVersion gradleVersion = GradleModelExtractor.getGradleVersionFromWrapper(project);
        if (gradleVersion == null) {
            LOGGER.info("Could not determine Project gradle version. Using {}", (Object)MIN_GRADLE_VERSION);
            return MIN_GRADLE_VERSION;
        }
        if (gradleVersion.compareTo(MIN_GRADLE_VERSION) < 0) {
            LOGGER.info("Forcing project to use Gradle {} instead of {}", (Object)MIN_GRADLE_VERSION, (Object)gradleVersion);
            return MIN_GRADLE_VERSION;
        }
        return gradleVersion;
    }

    @Nullable
    private static GradleVersion getGradleVersionFromWrapper(Path project) {
        Path wrapperProperties = project.resolve("gradle/wrapper/gradle-wrapper.properties");
        if (Files.notExists(wrapperProperties, new LinkOption[0])) {
            LOGGER.warn("Project does not have a gradle-wrapper.properties file.");
            return null;
        }
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(wrapperProperties, new OpenOption[0]);){
            properties.load(is);
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to load gradle-wrapper.properties", (Throwable)ex);
            return null;
        }
        String distributionUrl = properties.getProperty("distributionUrl");
        if (distributionUrl == null) {
            LOGGER.warn("Did not find distributionUrl in gradle-wrapper.properties.");
            return null;
        }
        Matcher matcher = WRAPPER_URL_REGEX.matcher(distributionUrl);
        if (!matcher.find()) {
            LOGGER.warn("Wrapper distributionUrl did not match expected regex pattern.");
            return null;
        }
        return GradleVersion.version((String)matcher.group(1));
    }

    static JavaVersion getJavaVersionForGradle(GradleVersion gradleVersion) {
        if (gradleVersion.compareTo(MIN_GRADLE_USE_J17) >= 0) {
            return JavaVersion.JAVA_17;
        }
        if (gradleVersion.compareTo(MIN_GRADLE_USE_J16) >= 0) {
            return JavaVersion.JAVA_16;
        }
        return JavaVersion.JAVA_1_8;
    }

    private Path buildInitScript() {
        Path temp;
        LOGGER.info("Building init script.");
        LinkedList<Object> lines = new LinkedList<Object>();
        lines.add("initscript {");
        lines.add("  dependencies {");
        for (Path path : this.gradleClassPath.get()) {
            lines.add("    classpath files('" + path.toAbsolutePath().toString().replace("\\", "\\\\") + "')");
        }
        lines.add("  }");
        lines.add("}");
        lines.add("apply plugin: net.covers1624.wstool.gradle.WorkspaceToolGradlePlugin");
        try {
            temp = Files.createTempFile("wt_init", ".gradle", new FileAttribute[0]);
            temp.toFile().deleteOnExit();
            Files.write(temp, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write gradle init script temp file.");
        }
        LOGGER.info("Built init script to: {}", (Object)temp);
        return temp;
    }

    private List<Path> buildClassPath() {
        String classpath = System.getProperty("net.covers1624.wstool.gradle_classpath");
        if (classpath == null) {
            LOGGER.info(" Using dev metadata for gradle plugin dependencies..");
            return GradleModelExtractor.buildClassPathDev();
        }
        return FastStream.of((Object[])classpath.split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).toList();
    }

    private String hashGradleClassPath() {
        Hasher hasher = Hashing.sha256().newHasher();
        try {
            for (Path path : FastStream.of((Iterable)this.gradleClassPath.get()).sorted()) {
                ArrayList sorted;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Stream<Path> files = Files.walk(path, new FileVisitOption[0]);
                    try {
                        sorted = FastStream.of(files).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(e -> e.toString().endsWith(".class")).sorted(Comparator.comparing(e -> path.relativize((Path)e).toString())).toList();
                        for (Path clazzFile : sorted) {
                            HashUtils.addToHasher((Hasher)hasher, (Path)clazzFile);
                        }
                        continue;
                    }
                    finally {
                        if (files != null) {
                            files.close();
                        }
                        continue;
                    }
                }
                if (path.toString().endsWith(".jar")) {
                    ZipFile zip = new ZipFile(path.toFile());
                    try {
                        sorted = FastStream.of(zip.stream()).filter(e -> e.getName().endsWith(".class")).sorted(Comparator.comparing(ZipEntry::getName)).toList();
                        for (ZipEntry entry : sorted) {
                            InputStream is = zip.getInputStream(entry);
                            try {
                                HashUtils.addToHasher((Hasher)hasher, (InputStream)is);
                            }
                            finally {
                                if (is == null) continue;
                                is.close();
                            }
                        }
                        continue;
                    }
                    finally {
                        zip.close();
                        continue;
                    }
                }
                throw new RuntimeException("I don't know how to hash this file. " + String.valueOf(path));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to hash class path.", ex);
        }
        return hasher.hash().toString();
    }

    private static List<Path> buildClassPathDev() {
        List paths;
        boolean isGradleTesting = Boolean.getBoolean("GradleModelExtractor.isGradleTesting");
        try (InputStream is = GradleModelExtractor.class.getResourceAsStream("/gradle_plugin_data.json");){
            if (is == null) {
                throw new IllegalStateException("Missing dev data. Did the genGradlePluginMetaDev gradle task not run on import?");
            }
            paths = (List)JsonUtils.parse((Gson)GSON, (InputStream)is, (Type)LIST_STRING);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load dev data.", ex);
        }
        return FastStream.of((Iterable)paths).map(x$0 -> Path.of(x$0, new String[0])).flatMap(p -> {
            if (!Files.isDirectory(p, new LinkOption[0])) {
                return List.of(p);
            }
            if (isGradleTesting) {
                return List.of(p.resolve("build/classes/java/main"), p.resolve("build/resources/main"));
            }
            return List.of(p.resolve("out/production/classes"), p.resolve("out/production/resources"));
        }).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toImmutableList();
    }
}

