/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.gradle;

import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.quack.io.ConsumingOutputStream;
import net.covers1624.wstool.api.JdkProvider;
import net.covers1624.wstool.gradle.GradleModelExtractor;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleTaskExecutor.class);
    private final JdkProvider jdkProvider;

    public GradleTaskExecutor(JdkProvider jdkProvider) {
        this.jdkProvider = jdkProvider;
    }

    public void runTask(Path projectDir, String task) {
        GradleVersion gradleVersion = GradleModelExtractor.computeProjectGradleVersion(projectDir);
        JavaVersion javaVersion = GradleModelExtractor.getJavaVersionForGradle(gradleVersion);
        Path javaHome = this.jdkProvider.findOrProvisionJdk(javaVersion);
        GradleConnector connector = GradleConnector.newConnector().useGradleVersion(gradleVersion.getVersion()).forProjectDirectory(projectDir.toFile());
        try (ProjectConnection connection = connector.connect();){
            LOGGER.info("Running Gradle task {} on {}", (Object)task, (Object)projectDir);
            ((BuildLauncher)((BuildLauncher)((BuildLauncher)((BuildLauncher)((BuildLauncher)connection.newBuild().forTasks(new String[]{task}).setJavaHome(javaHome.toFile())).setJvmArguments(new String[]{"-Xmx3G"})).setEnvironmentVariables((Map)ImmutableMap.copyOf(System.getenv()))).setStandardOutput((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).setStandardError((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).run();
        }
    }
}

