/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.gradle;

import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.io.ConsumingOutputStream;
import net.covers1624.wstool.api.Environment;
import net.covers1624.wstool.api.JdkProvider;
import net.covers1624.wstool.gradle.GradleModelExtractor;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.GradleProject;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleTaskExecutor.class);
    private final JdkProvider jdkProvider;

    public GradleTaskExecutor(Environment env) {
        this.jdkProvider = (JdkProvider)env.getService(JdkProvider.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(Path projectDir, String task) {
        GradleVersion gradleVersion = GradleModelExtractor.computeProjectGradleVersion(projectDir);
        JavaVersion javaVersion = GradleModelExtractor.getJavaVersionForGradle(gradleVersion);
        Path javaHome = this.jdkProvider.findOrProvisionJdk(javaVersion);
        GradleConnector connector = GradleConnector.newConnector().useGradleVersion(gradleVersion.getVersion()).forProjectDirectory(projectDir.toFile());
        try (ProjectConnection connection = connector.connect();){
            LOGGER.info("Running Gradle task {} on {}", (Object)task, (Object)projectDir);
            ((BuildLauncher)((BuildLauncher)((BuildLauncher)((BuildLauncher)((BuildLauncher)connection.newBuild().forTasks(new String[]{task}).setJavaHome(javaHome.toFile())).setJvmArguments(new String[]{"-Xmx3G"})).setEnvironmentVariables((Map)ImmutableMap.copyOf(System.getenv()))).setStandardOutput((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).setStandardError((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).run();
        }
        finally {
            connector.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryRunTasks(Path projectDir, String ... tasks) {
        GradleVersion gradleVersion = GradleModelExtractor.computeProjectGradleVersion(projectDir);
        JavaVersion javaVersion = GradleModelExtractor.getJavaVersionForGradle(gradleVersion);
        Path javaHome = this.jdkProvider.findOrProvisionJdk(javaVersion);
        GradleConnector connector = GradleConnector.newConnector().useGradleVersion(gradleVersion.getVersion()).forProjectDirectory(projectDir.toFile());
        try (ProjectConnection connection = connector.connect();){
            LOGGER.info("Running Gradle tasks {} on {}", (Object)tasks, (Object)projectDir);
            GradleProject project = (GradleProject)((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)connection.model(GradleProject.class).setJavaHome(javaHome.toFile())).setJvmArguments(new String[]{"-Xmx3G"})).setStandardOutput((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).setStandardError((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).get();
            String[] toExec = (String[])FastStream.of((Object[])tasks).filter(e -> this.doesTaskExist(project, (String)e)).toArray(String[]::new);
            ((BuildLauncher)((BuildLauncher)((BuildLauncher)((BuildLauncher)((BuildLauncher)connection.newBuild().forTasks(toExec).setJavaHome(javaHome.toFile())).setJvmArguments(new String[]{"-Xmx3G"})).setEnvironmentVariables((Map)ImmutableMap.copyOf(System.getenv()))).setStandardOutput((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).setStandardError((OutputStream)new ConsumingOutputStream(arg_0 -> ((Logger)LOGGER).info(arg_0)))).run();
        }
        finally {
            connector.disconnect();
        }
    }

    private boolean doesTaskExist(GradleProject project, String taskPath) {
        if (ColUtils.anyMatch((Iterable)project.getTasks(), e -> e.getPath().equals(taskPath))) {
            return true;
        }
        for (GradleProject child : project.getChildren()) {
            if (!this.doesTaskExist(child, taskPath)) continue;
            return true;
        }
        return false;
    }
}

