/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.intellij.workspace;

import java.lang.invoke.StringConcatFactory;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.wstool.api.Environment;
import net.covers1624.wstool.api.workspace.Dependency;
import net.covers1624.wstool.api.workspace.SourceSet;
import net.covers1624.wstool.api.workspace.runs.EvalList;
import net.covers1624.wstool.api.workspace.runs.EvalMap;
import net.covers1624.wstool.api.workspace.runs.RunConfig;
import net.covers1624.wstool.intellij.MavenDependencyCollector;
import net.covers1624.wstool.intellij.workspace.IJSourceSetModule;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jetbrains.annotations.Nullable;

public class IJRunConfig
implements RunConfig {
    private final String name;
    private final Map<String, String> config = new LinkedHashMap<String, String>();
    @Nullable
    private Path runDir;
    @Nullable
    private SourceSet classpath;
    @Nullable
    private String mainClass;
    private final EvalList args = new EvalList();
    private final EvalList vmArgs = new EvalList();
    private final EvalMap sysProps = new EvalMap();
    private final EvalMap envVars = new EvalMap();

    public IJRunConfig(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> config() {
        return this.config;
    }

    @Nullable
    public Path runDir() {
        return this.runDir;
    }

    public void runDir(Path runDir) {
        this.runDir = runDir;
    }

    @Nullable
    public SourceSet classpath() {
        return this.classpath;
    }

    public void classpath(SourceSet classpath) {
        this.classpath = classpath;
    }

    @Nullable
    public String mainClass() {
        return this.mainClass;
    }

    public void mainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public EvalList args() {
        return this.args;
    }

    public EvalList vmArgs() {
        return this.vmArgs;
    }

    public EvalMap sysProps() {
        return this.sysProps;
    }

    public EvalMap envVars() {
        return this.envVars;
    }

    public Document writeDocument(Environment env, MavenDependencyCollector collector) {
        String name;
        Element component = new Element("component").setAttribute("name", "ProjectRunConfigurationManager");
        String group = null;
        int slashIdx = this.name.indexOf(47);
        if (slashIdx != -1) {
            name = this.name.substring(slashIdx + 1);
            group = this.name.substring(0, slashIdx);
        } else {
            name = this.name;
        }
        Element configuration = new Element("configuration").setAttribute("default", "false").setAttribute("name", name).setAttribute("type", "Application").setAttribute("factoryName", "Application");
        if (group != null) {
            configuration.setAttribute("folderName", group);
        }
        configuration.addContent((Content)new Element("option").setAttribute("name", "MAIN_CLASS_NAME").setAttribute("value", Objects.requireNonNull(this.mainClass, "Run config " + name + " must have a main class.")));
        configuration.addContent((Content)new Element("module").setAttribute("name", ((IJSourceSetModule)Objects.requireNonNull(this.classpath, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Run config \u0001 must have a classpath."}, (String)name)))).path.toString()));
        Function<Dependency, @Nullable Path> depFunc = e -> {
            SourceSet sourceSet;
            Path path;
            Dependency dependency = e;
            Objects.requireNonNull(dependency);
            Dependency selector1$temp = dependency;
            int index$2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Dependency.MavenDependency.class, Dependency.SourceSetDependency.class}, (Object)selector1$temp, index$2)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Dependency.MavenDependency mavenDep = (Dependency.MavenDependency)selector1$temp;
                    MavenDependencyCollector.CollectedEntry found = collector.lookup(mavenDep);
                    if (found == null) {
                        throw new RuntimeException("Unable to find dependency " + String.valueOf(mavenDep) + " in the library collector.");
                    }
                    path = found.classes();
                    return path;
                }
                case 1: 
            }
            Dependency.SourceSetDependency $b$0 = (Dependency.SourceSetDependency)selector1$temp;
            try {
                SourceSet patt3$temp;
                sourceSet = patt3$temp = $b$0.sourceSet();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            path = ((IJSourceSetModule)sourceSet).outputDir(env);
            return path;
        };
        configuration.addContent((Content)new Element("option").setAttribute("name", "PROGRAM_PARAMETERS").setAttribute("value", FastStream.of((Iterable)this.args.toList(depFunc)).map(IJRunConfig::escape).join(" ")));
        ArrayList vmArgs = new ArrayList(this.vmArgs.toList(depFunc));
        this.sysProps.toMap(depFunc).forEach((k, v) -> vmArgs.add("-D" + k + "=" + v));
        configuration.addContent((Content)new Element("option").setAttribute("name", "VM_PARAMETERS").setAttribute("value", FastStream.of(vmArgs).map(IJRunConfig::escape).join(" ")));
        configuration.addContent((Content)new Element("option").setAttribute("name", "WORKING_DIRECTORY").setAttribute("value", Objects.requireNonNull(this.runDir, "Run config " + name + " must have a run directory.").toAbsolutePath().normalize().toString()));
        if (!this.envVars.isEmpty()) {
            Element envs = new Element("envs");
            this.envVars.toMap(depFunc).forEach((k, v) -> envs.addContent((Content)new Element("env").setAttribute("name", k).setAttribute("value", v)));
            configuration.addContent((Content)envs);
        }
        Element method = new Element("method").setAttribute("v", "2");
        method.addContent((Content)new Element("option").setAttribute("name", "MakeProject").setAttribute("enabled", "true"));
        configuration.addContent((Content)method);
        component.addContent((Content)configuration);
        return new Document(component);
    }

    private static String escape(String str) {
        if (str.contains(" ")) {
            return "\"" + str + "\"";
        }
        return str;
    }
}

