/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.intellij.workspace;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public record ModulePath(List<String> names) {
    public ModulePath {
        if (names.isEmpty()) {
            throw new RuntimeException("Path can't be empty.");
        }
        names = List.copyOf(names);
    }

    public String name() {
        return this.names.get(this.names.size() - 1);
    }

    public ModulePath with(String name) {
        ArrayList<String> strings = new ArrayList<String>(this.names);
        strings.add(name);
        return new ModulePath(strings);
    }

    public ModulePath with(List<String> names) {
        ArrayList<String> strings = new ArrayList<String>(this.names);
        strings.addAll(names);
        return new ModulePath(strings);
    }

    @Nullable
    public ModulePath parent() {
        if (this.names.size() == 1) {
            return null;
        }
        return new ModulePath(List.copyOf(this.names.subList(0, this.names.size() - 1)));
    }

    @Nullable
    public ModulePath tail() {
        if (this.names.size() == 1) {
            return null;
        }
        return new ModulePath(List.copyOf(this.names.subList(1, this.names.size())));
    }

    public String joinNames(String seperator) {
        return String.join((CharSequence)seperator, this.names);
    }

    @Override
    public String toString() {
        return this.joinNames(".");
    }
}

