/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.intellij.workspace;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.wstool.api.workspace.Module;
import net.covers1624.wstool.api.workspace.SourceSet;
import net.covers1624.wstool.gradle.api.data.ProjectData;
import net.covers1624.wstool.intellij.workspace.IJModuleWithPath;
import net.covers1624.wstool.intellij.workspace.IJSourceSetModule;
import net.covers1624.wstool.intellij.workspace.IJWorkspace;
import net.covers1624.wstool.intellij.workspace.ModulePath;
import org.jetbrains.annotations.Nullable;

public final class IJProjectModule
extends IJModuleWithPath
implements Module {
    private final IJWorkspace workspace;
    private final Map<ModulePath, IJProjectModule> subModules = new LinkedHashMap<ModulePath, IJProjectModule>();
    private final Map<ModulePath, IJSourceSetModule> sourceSets = new LinkedHashMap<ModulePath, IJSourceSetModule>();
    @Nullable
    private ProjectData gradleData;

    public IJProjectModule(IJWorkspace workspace, Path rootDir, ModulePath path) {
        super(rootDir, path);
        this.workspace = workspace;
    }

    public Map<String, ? extends IJProjectModule> subModules() {
        return FastStream.of(this.subModules.entrySet()).toMap(e -> ((ModulePath)e.getKey()).name(), Map.Entry::getValue);
    }

    public Map<String, ? extends IJSourceSetModule> sourceSets() {
        return FastStream.of(this.sourceSets.entrySet()).toMap(e -> ((ModulePath)e.getKey()).name(), Map.Entry::getValue);
    }

    public Module newSubModule(Path rootDir, String name) {
        ModulePath path = this.path.with(name);
        IJProjectModule module = new IJProjectModule(this.workspace, rootDir, path);
        this.workspace.addModule(module);
        this.subModules.put(path, module);
        return module;
    }

    public SourceSet newSourceSet(String name) {
        ModulePath path = this.path.with(name);
        IJSourceSetModule module = new IJSourceSetModule(path, this);
        this.workspace.addModule(module);
        this.sourceSets.put(path, module);
        return module;
    }

    @Nullable
    public ProjectData projectData() {
        return this.gradleData;
    }

    public void setProjectData(ProjectData data) {
        this.gradleData = data;
    }
}

