/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.intellij.workspace;

import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.covers1624.wstool.api.workspace.Dependency;
import net.covers1624.wstool.api.workspace.Module;
import net.covers1624.wstool.api.workspace.SourceSet;
import net.covers1624.wstool.intellij.workspace.ContentPath;
import net.covers1624.wstool.intellij.workspace.IJModule;
import net.covers1624.wstool.intellij.workspace.ModulePath;

public final class IJSourceSetModule
extends IJModule
implements SourceSet {
    private final Module module;
    private final Map<String, List<Path>> sourcePaths = new LinkedHashMap<String, List<Path>>();
    private final List<Dependency> compileDependencies = new ArrayList<Dependency>();
    private final List<Dependency> runtimeDependencies = new ArrayList<Dependency>();

    public IJSourceSetModule(ModulePath path, Module module) {
        super(path);
        this.module = module;
    }

    public Module module() {
        return this.module;
    }

    public Map<String, List<Path>> sourcePaths() {
        return this.sourcePaths;
    }

    public List<Dependency> compileDependencies() {
        return this.compileDependencies;
    }

    public List<Dependency> runtimeDependencies() {
        return this.runtimeDependencies;
    }

    @Override
    public boolean isForTests() {
        return this.path.name().equals("test");
    }

    @Override
    public List<ContentPath> getContentPaths() {
        boolean forTests = this.isForTests();
        ArrayList<ContentPath> paths = new ArrayList<ContentPath>(super.getContentPaths());
        this.sourcePaths.forEach((type, p) -> p.forEach(path -> {
            if (type.equals("resources")) {
                paths.add(ContentPath.resources(path, forTests));
            } else {
                paths.add(ContentPath.code(path, forTests));
            }
        }));
        return paths;
    }

    @Override
    public List<IJModule.DependencyEntry> getDependencyEntries() {
        ArrayList<IJModule.DependencyEntry> entries = new ArrayList<IJModule.DependencyEntry>();
        this.compileDependencies.forEach(dep -> entries.add(this.collectDependency((Dependency)dep, IJModule.DependencyScope.COMPILE)));
        this.runtimeDependencies.forEach(dep -> entries.add(this.collectDependency((Dependency)dep, IJModule.DependencyScope.RUNTIME)));
        return entries;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IJModule.DependencyEntry collectDependency(Dependency dep, IJModule.DependencyScope scope) {
        Record record;
        Dependency dependency = dep;
        Objects.requireNonNull(dependency);
        Dependency dependency2 = dependency;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Dependency.MavenDependency.class, Dependency.SourceSetDependency.class, Dependency.FileDependency.class}, (Object)dependency2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Dependency.MavenDependency mavenDep = (Dependency.MavenDependency)dependency2;
                record = new IJModule.MavenDependencyEntry(mavenDep, scope, true);
                return record;
            }
            case 1: {
                Dependency.SourceSetDependency sourceSetDependency = (Dependency.SourceSetDependency)dependency2;
                try {
                    SourceSet sourceSet;
                    SourceSet sourceSet2 = sourceSet = sourceSetDependency.sourceSet();
                    record = new IJModule.ProjectDependencyEntry((IJModule)sourceSet2, scope, true);
                    return record;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 2: 
        }
        Dependency.FileDependency fileDependency = (Dependency.FileDependency)dependency2;
        {
            Path path;
            Path file = path = fileDependency.file();
            record = new IJModule.FileDependencyEntry(file, scope, true);
        }
        return record;
    }
}

