/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.intellij.workspace;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.wstool.api.Environment;
import net.covers1624.wstool.api.workspace.Module;
import net.covers1624.wstool.api.workspace.Workspace;
import net.covers1624.wstool.api.workspace.runs.RunConfig;
import net.covers1624.wstool.intellij.IJUtils;
import net.covers1624.wstool.intellij.MavenDependencyCollector;
import net.covers1624.wstool.intellij.workspace.ContentRootCollector;
import net.covers1624.wstool.intellij.workspace.IJModule;
import net.covers1624.wstool.intellij.workspace.IJModuleWithPath;
import net.covers1624.wstool.intellij.workspace.IJProjectModule;
import net.covers1624.wstool.intellij.workspace.IJRunConfig;
import net.covers1624.wstool.intellij.workspace.ModulePath;
import net.covers1624.wstool.util.DeletingFileVisitor;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class IJWorkspace
implements Workspace {
    private final Environment env;
    private final ModulePath rootPath;
    private final Map<ModulePath, IJModule> modules = new LinkedHashMap<ModulePath, IJModule>();
    private final Map<String, IJProjectModule> projectModules = new LinkedHashMap<String, IJProjectModule>();
    private final Map<String, IJRunConfig> runConfigs = new LinkedHashMap<String, IJRunConfig>();
    private int javaVersion = 8;

    public IJWorkspace(Environment env) {
        this.env = env;
        this.rootPath = new ModulePath(List.of(env.projectRoot().getFileName().toString()));
        RootModule rootModule = new RootModule(env.projectRoot(), this.rootPath);
        rootModule.excludes().add(env.projectRoot().resolve(".idea"));
        rootModule.excludes().add(env.projectRoot().resolve(".wstool"));
        rootModule.excludes().add(env.projectRoot().resolve("out"));
        this.modules.put(this.rootPath, rootModule);
    }

    public Map<String, ? extends Module> modules() {
        return this.projectModules;
    }

    public Module newModule(Path rootDir, String name) {
        ArrayList relPathSegments = FastStream.of((Iterable)this.env.projectRoot().relativize(rootDir.getParent())).map(e -> e.getFileName().toString()).toList();
        ModulePath path = this.rootPath;
        if (!relPathSegments.equals(List.of(""))) {
            path = path.with(relPathSegments);
        }
        path = path.with(name);
        this.ensureParentGroupsExist(path);
        IJProjectModule projectModule = new IJProjectModule(this, rootDir, path);
        this.modules.put(path, projectModule);
        this.projectModules.put(name, projectModule);
        return projectModule;
    }

    public Map<String, ? extends RunConfig> runConfigs() {
        return this.runConfigs;
    }

    public RunConfig newRunConfig(String name) {
        if (this.runConfigs.containsKey(name)) {
            throw new RuntimeException("A run config with the name " + name + " already exists.");
        }
        IJRunConfig runConfig = new IJRunConfig(name);
        this.runConfigs.put(name, runConfig);
        return runConfig;
    }

    public void setJavaVersion(int version) {
        this.javaVersion = version;
    }

    public void writeWorkspace() {
        Path ideaDir = this.env.projectRoot().resolve(".idea");
        Path modulesDir = ideaDir.resolve("modules");
        try {
            Files.createDirectories(modulesDir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create directories.", ex);
        }
        MavenDependencyCollector depCollector = new MavenDependencyCollector();
        this.modules().values().forEach(depCollector::collectFrom);
        this.runConfigs().values().forEach(depCollector::collectFrom);
        depCollector.hardlinkToCacheDir(this.env.projectCache());
        Path librariesDir = ideaDir.resolve("libraries");
        try {
            if (Files.exists(librariesDir, new LinkOption[0])) {
                Files.walkFileTree(librariesDir, (FileVisitor<? super Path>)new DeletingFileVisitor(librariesDir));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to clean libraries dir.", ex);
        }
        for (MavenDependencyCollector.CollectedEntry collectedEntry : depCollector.collectedEntries()) {
            Path path = librariesDir.resolve(collectedEntry.name().replace(':', '.') + ".xml");
            IJWorkspace.writeDocument(collectedEntry.buildDocument(), path);
        }
        ContentRootCollector crCollector = new ContentRootCollector();
        for (IJModule iJModule : this.modules.values()) {
            crCollector.processModule(iJModule);
        }
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (IJModule module : this.modules.values()) {
            String name = module.path.joinNames(".");
            Path moduleFile = modulesDir.resolve(name + ".iml");
            IJWorkspace.writeDocument(module.buildDocument(this.env, depCollector, crCollector), moduleFile);
            arrayList.add(moduleFile);
        }
        IJWorkspace.writeDocument(this.buildModulesXml(arrayList), ideaDir.resolve("modules.xml"));
        this.emitJavaVersionIntoMisc(ideaDir.resolve("misc.xml"));
        Path path = ideaDir.resolve("runConfigurations");
        for (IJRunConfig runConfig : this.runConfigs.values()) {
            Path dest = path.resolve(runConfig.name().replace("/", "_") + ".xml");
            IJWorkspace.writeDocument(runConfig.writeDocument(this.env, depCollector), dest);
        }
    }

    private Document buildModulesXml(List<Path> moduleFiles) {
        Element project = new Element("project").setAttribute("version", "4");
        Element component = new Element("component").setAttribute("name", "ProjectModuleManager");
        Element modules = new Element("modules");
        for (Path file : moduleFiles) {
            modules.addContent((Content)new Element("module").setAttribute("fileurl", IJUtils.fileUrl(file)).setAttribute("filepath", file.toString()));
        }
        component.addContent((Content)modules);
        project.addContent((Content)component);
        return new Document(project);
    }

    private void emitJavaVersionIntoMisc(Path miscFile) {
        Element project;
        Element projectRootManager;
        Document document;
        block10: {
            if (Files.exists(miscFile, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(miscFile, new OpenOption[0]);){
                    document = new SAXBuilder().build(is);
                    break block10;
                }
                catch (IOException | JDOMException ex) {
                    throw new RuntimeException("Failed to parse existing misc.xml file.", ex);
                }
            }
            document = new Document(new Element("project").setAttribute("version", "4"));
        }
        if ((projectRootManager = (Element)FastStream.of((Iterable)(project = document.getRootElement()).getChildren("component")).filter(e -> e.getAttributeValue("name", "").equals("ProjectRootManager")).onlyOrDefault()) == null) {
            projectRootManager = new Element("component").setAttribute("name", "ProjectRootManager").setAttribute("version", "2").setAttribute("project-jdk-type", "JavaSDK");
            project.addContent((Content)projectRootManager);
        }
        Object langVersion = "JDK_";
        langVersion = this.javaVersion <= 8 ? (String)langVersion + "1_" + this.javaVersion : (String)langVersion + String.valueOf(this.javaVersion);
        projectRootManager.setAttribute("languageLevel", (String)langVersion);
        IJWorkspace.writeDocument(document, miscFile);
    }

    private static void writeDocument(Document doc, Path file) {
        XMLOutputter output = new XMLOutputter(Format.getPrettyFormat());
        try (OutputStream os = Files.newOutputStream(IOUtils.makeParents((Path)file), new OpenOption[0]);){
            output.output(doc, os);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write xml file to " + String.valueOf(file), ex);
        }
    }

    void addModule(IJModule module) {
        if (this.modules.containsKey(module.path)) {
            throw new RuntimeException("Module with name " + String.valueOf(module.path) + " already exists.");
        }
        this.modules.put(module.path, module);
    }

    private void ensureParentGroupsExist(ModulePath path) {
        for (path = path.parent(); path != null; path = path.parent()) {
            IJModule module = this.modules.get(path);
            if (module == null) {
                this.modules.put(path, new GroupModule(this.env.projectRoot().resolve(path.tail().joinNames("/")), path));
                continue;
            }
            if (module instanceof RootModule) continue;
            throw new RuntimeException("Somehow tried to make a group through a project? Sub-Projects should be made directly from their parent?");
        }
    }

    public static sealed class RootModule
    extends IJModuleWithPath
    permits GroupModule {
        public RootModule(Path rootDir, ModulePath path) {
            super(rootDir, path);
        }
    }

    public static final class GroupModule
    extends RootModule {
        public GroupModule(Path rootDir, ModulePath path) {
            super(rootDir, path);
        }
    }
}

