/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.intellij.workspace;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.wstool.intellij.workspace.ContentPath;
import net.covers1624.wstool.intellij.workspace.ContentRoot;
import net.covers1624.wstool.intellij.workspace.IJModule;
import net.covers1624.wstool.intellij.workspace.IJModuleWithPath;

public class ContentRootCollector {
    private final Map<Path, Integer> weightMap = new HashMap<Path, Integer>();

    private Path findRoot(Path path) {
        while (this.weightMap.containsKey(path.getParent()) && this.weightMap.get(path.getParent()) <= 1) {
            path = path.getParent();
        }
        return path;
    }

    private void addWeights(Iterable<Path> itr) {
        itr.forEach(s -> this.weightMap.compute((Path)s, (e, w) -> w != null ? w + 1 : 1));
    }

    public void processModule(IJModule module) {
        if (module instanceof IJModuleWithPath) {
            IJModuleWithPath pathModule = (IJModuleWithPath)module;
            this.addWeights(this.getPaths(pathModule.rootDir()));
        }
        this.addWeights((Iterable<Path>)FastStream.of(module.getContentPaths()).flatMap(e -> this.getPaths(e.path())));
    }

    public List<ContentRoot> buildRoots(IJModule module) {
        LinkedHashMap<Path, List> roots = new LinkedHashMap<Path, List>();
        for (ContentPath contentPath : module.getContentPaths()) {
            Path rootPath = this.findRoot(contentPath.path().getParent());
            MutableRoot found = null;
            for (Path path : (Path[])roots.keySet().toArray(Path[]::new)) {
                if (!rootPath.equals(path) && rootPath.startsWith(path)) {
                    paths = (List)roots.remove(path);
                    if (paths != null) {
                        roots.computeIfAbsent(rootPath, e -> new ArrayList()).addAll(paths);
                    }
                } else if (path.startsWith(rootPath)) {
                    paths = (List)roots.get(path);
                    found = (MutableRoot)FastStream.of((Iterable)paths).filter(e -> e.root.equals(path)).firstOrDefault((Object)((MutableRoot)paths.getFirst()));
                    break;
                }
                if (roots.size() == 1) break;
            }
            if (found == null) {
                found = new MutableRoot(rootPath, new ArrayList<ContentPath>());
                roots.computeIfAbsent(rootPath, e -> new ArrayList()).add(found);
            }
            found.paths.add(contentPath);
        }
        if (roots.isEmpty()) {
            if (!(module instanceof IJModuleWithPath)) {
                return List.of();
            }
            IJModuleWithPath moduleWithPath = (IJModuleWithPath)module;
            return List.of(new ContentRoot(moduleWithPath.rootDir(), List.of()));
        }
        return FastStream.of(roots.entrySet()).map(e -> new ContentRoot((Path)e.getKey(), FastStream.of((Iterable)((Iterable)e.getValue())).flatMap(e2 -> e2.paths).toList())).toList();
    }

    private Set<Path> getPaths(Path path) {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        while (path != null) {
            paths.add(path);
            path = path.getParent();
        }
        return paths;
    }

    private record MutableRoot(Path root, List<ContentPath> paths) {
    }
}

