/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.intellij;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.wstool.api.workspace.Dependency;
import net.covers1624.wstool.api.workspace.Module;
import net.covers1624.wstool.api.workspace.SourceSet;
import net.covers1624.wstool.api.workspace.runs.EvalValue;
import net.covers1624.wstool.api.workspace.runs.RunConfig;
import net.covers1624.wstool.intellij.IJUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDependencyCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenDependencyCollector.class);
    private final Map<MavenNotation, CollectedEntry> collectedDependencies = new HashMap<MavenNotation, CollectedEntry>();
    private final Map<Dependency.MavenDependency, CollectedEntry> depToEntry = new HashMap<Dependency.MavenDependency, CollectedEntry>();
    private boolean hardlinkFailed = false;

    public void collectFrom(Module module) {
        for (SourceSet ss : module.sourceSets().values()) {
            this.collectDeps(ss.runtimeDependencies());
            this.collectDeps(ss.compileDependencies());
        }
        for (Module subModule : module.subModules().values()) {
            this.collectFrom(subModule);
        }
    }

    public void collectFrom(RunConfig runConfig) {
        runConfig.vmArgs().toList().forEach(this::collectFrom);
        runConfig.args().toList().forEach(this::collectFrom);
        runConfig.sysProps().toMap().values().forEach(this::collectFrom);
        runConfig.envVars().toMap().values().forEach(this::collectFrom);
    }

    private void collectFrom(EvalValue evalValue) {
        this.collectDeps(evalValue.collectDependencies());
    }

    private void collectDeps(Iterable<Dependency> deps) {
        for (Dependency dep : deps) {
            if (!(dep instanceof Dependency.MavenDependency)) continue;
            Dependency.MavenDependency mavenDep = (Dependency.MavenDependency)dep;
            this.collectDep(mavenDep);
        }
    }

    private void collectDep(Dependency.MavenDependency dep) {
        CollectedEntry ent = this.collectedDependencies.computeIfAbsent(MavenDependencyCollector.getWithoutVersion(dep.notation()), CollectedEntry::new);
        ent.consume(dep);
        this.depToEntry.put(dep, ent);
    }

    @Nullable
    public CollectedEntry lookup(Dependency.MavenDependency dep) {
        return this.depToEntry.get(dep);
    }

    private static MavenNotation getWithoutVersion(MavenNotation notation) {
        return notation.withVersion(null);
    }

    public void hardlinkToCacheDir(Path path) {
        Path librariesDir = path.resolve("libraries");
        try {
            for (CollectedEntry dep : this.collectedDependencies.values()) {
                Path cacheLibDir = librariesDir.resolve(dep.notation.toModulePath()).resolve(Objects.requireNonNull(dep.currentVersion));
                dep.classes = this.linkIntoDir(cacheLibDir, dep.classes);
                dep.javadoc = this.linkIntoDir(cacheLibDir, dep.javadoc);
                dep.sources = this.linkIntoDir(cacheLibDir, dep.sources);
            }
        }
        catch (IOException ex) {
            LOGGER.error("Error whilst linking files.", (Throwable)ex);
        }
    }

    public Iterable<CollectedEntry> collectedEntries() {
        return Collections.unmodifiableCollection(this.collectedDependencies.values());
    }

    @Nullable
    private Path linkIntoDir(Path dir, @Nullable Path originalFile) throws IOException {
        if (originalFile == null) {
            return null;
        }
        Path linkedFile = dir.resolve(originalFile.getFileName());
        if (Files.exists(linkedFile, new LinkOption[0]) && Files.notExists(originalFile, new LinkOption[0])) {
            return linkedFile;
        }
        Files.deleteIfExists(linkedFile);
        if (!this.hardlinkFailed) {
            try {
                Files.createLink(IOUtils.makeParents((Path)linkedFile), originalFile);
                return linkedFile;
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to hardlink dependencies into the workspace. You will be vulnerable to Gradle cache expiring in-use dependencies.", (Throwable)ex);
                this.hardlinkFailed = true;
            }
        }
        Files.createSymbolicLink(IOUtils.makeParents((Path)linkedFile), originalFile, new FileAttribute[0]);
        return linkedFile;
    }

    public static class CollectedEntry {
        private final MavenNotation notation;
        @Nullable
        private String currentVersion;
        @Nullable
        private Path classes;
        @Nullable
        private Path javadoc;
        @Nullable
        private Path sources;

        public CollectedEntry(MavenNotation notation) {
            this.notation = notation;
        }

        public void consume(Dependency.MavenDependency dependency) {
            String newVersion = Objects.requireNonNull(dependency.notation().version);
            if (!CollectedEntry.isUpgrade(this.currentVersion, newVersion)) {
                return;
            }
            if (!newVersion.equals(this.currentVersion)) {
                this.currentVersion = newVersion;
                this.classes = null;
                this.javadoc = null;
                this.sources = null;
            }
            this.classes = (Path)dependency.files().get("classes");
            this.javadoc = (Path)dependency.files().get("javadoc");
            this.sources = (Path)dependency.files().get("sources");
        }

        private static boolean isUpgrade(@Nullable String a, @Nullable String b) {
            if (a == null && b != null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return new DefaultArtifactVersion(a).compareTo((ArtifactVersion)new DefaultArtifactVersion(b)) <= 0;
        }

        public String name() {
            return this.notation.withVersion(this.currentVersion).toString();
        }

        @Nullable
        public Path classes() {
            return this.classes;
        }

        public Document buildDocument() {
            Element component = new Element("component").setAttribute("name", "libraryTable");
            Element library = new Element("library").setAttribute("name", this.name());
            library.addContent((Content)CollectedEntry.emitElementForJar("CLASSES", this.classes));
            library.addContent((Content)CollectedEntry.emitElementForJar("JAVADOC", this.javadoc));
            library.addContent((Content)CollectedEntry.emitElementForJar("SOURCES", this.sources));
            component.addContent((Content)library);
            return new Document(component);
        }

        private static Element emitElementForJar(String name, @Nullable Path jar) {
            Element element = new Element(name);
            if (jar != null) {
                element.addContent((Content)new Element("root").setAttribute("url", IJUtils.fileUrl(jar)));
            }
            return element;
        }
    }
}

