/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.intellij.workspace;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.wstool.api.Environment;
import net.covers1624.wstool.api.workspace.Dependency;
import net.covers1624.wstool.intellij.IJUtils;
import net.covers1624.wstool.intellij.MavenDependencyCollector;
import net.covers1624.wstool.intellij.workspace.ContentPath;
import net.covers1624.wstool.intellij.workspace.ContentRoot;
import net.covers1624.wstool.intellij.workspace.ContentRootCollector;
import net.covers1624.wstool.intellij.workspace.IJModuleWithPath;
import net.covers1624.wstool.intellij.workspace.IJSourceSetModule;
import net.covers1624.wstool.intellij.workspace.ModulePath;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract sealed class IJModule
permits IJSourceSetModule, IJModuleWithPath {
    protected final ModulePath path;
    private final List<Path> excludes = new ArrayList<Path>();

    public IJModule(ModulePath path) {
        this.path = path;
    }

    public String name() {
        return this.path.name();
    }

    public Path outputDir(Environment env) {
        return env.projectRoot().resolve("out").resolve(this.path.joinNames("_"));
    }

    public List<Path> excludes() {
        return this.excludes;
    }

    public boolean isForTests() {
        return false;
    }

    public List<ContentPath> getContentPaths() {
        return FastStream.of(this.excludes).map(ContentPath::exclude).toList();
    }

    public List<DependencyEntry> getDependencyEntries() {
        return List.of();
    }

    public final Document buildDocument(Environment env, MavenDependencyCollector collector, ContentRootCollector crCollector) {
        Element module = new Element("module").setAttribute("type", "JAVA_MODULE").setAttribute("version", "4");
        Element moduleRootManager = new Element("component").setAttribute("name", "NewModuleRootManager").setAttribute("inherit-compiler-output", "false");
        moduleRootManager.addContent((Content)new Element("exclude-output"));
        moduleRootManager.addContent((Content)new Element(this.isForTests() ? "output-test" : "output").setAttribute("url", IJUtils.fileUrl(this.outputDir(env))));
        List<ContentRoot> roots = crCollector.buildRoots(this);
        for (ContentRoot root : roots) {
            moduleRootManager.addContent((Content)IJModule.buildContentRootElement(root));
        }
        moduleRootManager.addContent((Content)new Element("orderEntry").setAttribute("type", "inheritedJdk"));
        moduleRootManager.addContent((Content)new Element("orderEntry").setAttribute("type", "sourceFolder").setAttribute("forTests", "false"));
        for (DependencyEntry depEntry : this.getDependencyEntries()) {
            Element orderEntry = new Element("orderEntry");
            orderEntry.setAttribute("scope", depEntry.scope().name());
            if (depEntry.exported()) {
                orderEntry.setAttribute("exported", "");
            }
            if (depEntry instanceof MavenDependencyEntry) {
                MavenDependencyEntry ent = (MavenDependencyEntry)depEntry;
                orderEntry.setAttribute("type", "library");
                orderEntry.setAttribute("level", "project");
                MavenDependencyCollector.CollectedEntry library = collector.lookup(ent.dep);
                if (library == null) {
                    throw new RuntimeException("Unable to find dependency " + String.valueOf(ent.dep) + " in the library collector.");
                }
                orderEntry.setAttribute("name", library.name());
            } else if (depEntry instanceof ProjectDependencyEntry) {
                ProjectDependencyEntry ent = (ProjectDependencyEntry)depEntry;
                orderEntry.setAttribute("type", "module");
                orderEntry.setAttribute("module-name", ent.module.path.toString());
            } else {
                throw new RuntimeException("Unhandled type " + String.valueOf(depEntry.getClass()));
            }
            moduleRootManager.addContent((Content)orderEntry);
        }
        module.addContent((Content)moduleRootManager);
        return new Document(module);
    }

    private static Element buildContentRootElement(ContentRoot root) {
        Element content = new Element("content");
        content.setAttribute("url", IJUtils.fileUrl(root.root()));
        for (ContentPath path : root.contentRootPaths()) {
            Element element = new Element(path.type() == ContentPath.PathType.EXCLUDE ? "excludeFolder" : "sourceFolder");
            element.setAttribute("url", IJUtils.fileUrl(path.path()));
            switch (path.type()) {
                case CODE: {
                    element.setAttribute("isTestSource", "false");
                    break;
                }
                case TEST_CODE: {
                    element.setAttribute("isTestSource", "true");
                    break;
                }
                case RESOURCES: {
                    element.setAttribute("type", "java-resource");
                    break;
                }
                case TEST_RESOURCES: {
                    element.setAttribute("type", "java-test-resource");
                }
            }
            content.addContent((Content)element);
        }
        return content;
    }

    public static sealed interface DependencyEntry
    permits MavenDependencyEntry, ProjectDependencyEntry {
        public DependencyScope scope();

        public boolean exported();
    }

    public static enum DependencyScope {
        PROVIDED,
        COMPILE,
        RUNTIME,
        TEST;

    }

    public record MavenDependencyEntry(Dependency.MavenDependency dep, DependencyScope scope, boolean exported) implements DependencyEntry
    {
    }

    public record ProjectDependencyEntry(IJModule module, DependencyScope scope, boolean exported) implements DependencyEntry
    {
    }
}

