/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.mc.data;

import com.google.common.hash.HashCode;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.covers1624.quack.maven.MavenNotation;
import org.apache.commons.lang3.StringUtils;

public class VersionInfoJson {
    public List<Library> libraries = new ArrayList<Library>();
    public Map<String, Download> downloads;
    public AssetIndex assetIndex;

    public static enum OS {
        LINUX("linux", "bsd", "unix"),
        WINDOWS("windows", "win"),
        OSX("osx", "mac"),
        UNKNOWN("unknown", new String[0]);

        public static final String VERSION;
        public static final String ARCH;
        private static OS currentOS;
        private final String name;
        private final String[] aliases;

        private OS(String name, String ... aliases) {
            this.name = name;
            this.aliases = aliases;
        }

        public static OS currentOS() {
            if (currentOS == null) {
                String osName = System.getProperty("os.name");
                for (OS os : OS.values()) {
                    if (StringUtils.containsIgnoreCase((CharSequence)osName, (CharSequence)os.name)) {
                        currentOS = os;
                        return currentOS;
                    }
                    for (String alias : os.aliases) {
                        if (!StringUtils.containsIgnoreCase((CharSequence)alias, (CharSequence)os.name)) continue;
                        currentOS = os;
                        return currentOS;
                    }
                }
                currentOS = UNKNOWN;
            }
            return currentOS;
        }

        public String toString() {
            return this.name;
        }

        static {
            VERSION = System.getProperty("os.version");
            ARCH = System.getProperty("os.arch");
        }
    }

    public static class Library {
        public MavenNotation name;
        public Extract extract;
        public List<Rule> rules = new ArrayList<Rule>();
        public Map<OS, String> natives = new HashMap<OS, String>();

        public boolean allowed() {
            if (this.rules == null || this.rules.isEmpty()) {
                return true;
            }
            boolean last = false;
            for (Rule rule : this.rules) {
                if (rule.os == null || rule.os.isCurrent()) continue;
                last = rule.action.equals("allow");
            }
            return last;
        }

        public MavenNotation getArtifact(boolean skipNatives) {
            if (this.natives == null || skipNatives) {
                return this.name;
            }
            String classifier = this.natives.get((Object)OS.currentOS());
            if (classifier == null) {
                return this.name;
            }
            return this.name.withClassifier(classifier);
        }

        public static class Rule {
            public String action;
            public OSRestriction os;

            public static class OSRestriction {
                public OS os;
                public String version;
                public String arch;

                public boolean isCurrent() {
                    Pattern pattern2;
                    OS current = OS.currentOS();
                    if (this.os != null && this.os != current) {
                        return false;
                    }
                    if (this.version != null) {
                        try {
                            pattern2 = Pattern.compile(this.version);
                            if (!pattern2.matcher(OS.VERSION).matches()) {
                                return false;
                            }
                        }
                        catch (Throwable pattern2) {
                            // empty catch block
                        }
                    }
                    if (this.arch != null) {
                        try {
                            pattern2 = Pattern.compile(this.arch);
                            if (!pattern2.matcher(OS.ARCH).matches()) {
                                return false;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return true;
                }
            }
        }

        public static class Extract {
            public List<String> exclude = new ArrayList<String>();
        }
    }

    public static class Download {
        public URL url;
        public HashCode sha1;
    }

    public static class AssetIndex {
        public String id;
        public HashCode sha1;
        public URL url;

        public String getId(String version) {
            if (!version.equals(this.id)) {
                return version + "-" + this.id;
            }
            return this.id;
        }
    }
}

