/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.minecraft;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.quack.net.HttpEngineDownloadAction;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.net.httpapi.java11.Java11HttpEngine;
import net.covers1624.wstool.api.Environment;
import net.covers1624.wstool.api.JdkProvider;
import net.covers1624.wstool.api.workspace.Dependency;
import net.covers1624.wstool.api.workspace.SourceSet;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSTExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSTExecutor.class);
    private static final MavenNotation JST_NOTATION = MavenNotation.parse((String)"net.neoforged.jst:jst-cli-bundle:2.0.3");
    private final Environment env;
    private final JdkProvider provider;
    @Nullable
    private Path jstBundlePath;

    public JSTExecutor(Environment env) {
        this.env = env;
        this.provider = (JdkProvider)env.getService(JdkProvider.class);
    }

    public void applyJST(SourceSet classpath, Path mcSources, List<Path> ifaceInjections, List<Path> accessTransformers) {
        if (ifaceInjections.isEmpty() && accessTransformers.isEmpty()) {
            return;
        }
        Path jst = this.getJstBundle();
        Path javaHome = this.provider.findOrProvisionJdk(JavaVersion.JAVA_21);
        Path librariesList = JSTExecutor.createLibrariesList(classpath, mcSources);
        ArrayList<String> args = new ArrayList<String>();
        args.add(JavaInstall.getJavaExecutable((Path)javaHome, (boolean)true).toAbsolutePath().toString());
        args.add("-jar");
        args.add(jst.toAbsolutePath().toString());
        args.add("--libraries-list");
        args.add(librariesList.toAbsolutePath().toString());
        if (!ifaceInjections.isEmpty()) {
            args.add("--enable-interface-injection");
            for (Path file : ifaceInjections) {
                args.add("--interface-injection-data");
                args.add(file.toAbsolutePath().toString());
            }
        }
        if (!accessTransformers.isEmpty()) {
            args.add("--enable-accesstransformers");
            for (Path file : accessTransformers) {
                args.add("--access-transformer");
                args.add(file.toAbsolutePath().toString());
            }
        }
        args.add(mcSources.toAbsolutePath().toString());
        args.add(mcSources.toAbsolutePath().toString());
        LOGGER.info("Running JST for {} iface injections and {} at's.", (Object)ifaceInjections.size(), (Object)accessTransformers.size());
        try {
            Process proc = new ProcessBuilder(args).redirectErrorStream(true).start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));){
                reader.lines().forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
            }
            proc.waitFor();
            if (proc.exitValue() != 0) {
                throw new RuntimeException("Failed to run JST. Exit code: " + proc.exitValue());
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException("Failed to run JST.", ex);
        }
        finally {
            try {
                Files.deleteIfExists(librariesList);
            }
            catch (IOException iOException) {}
        }
    }

    private static Path createLibrariesList(SourceSet sourceSet, Path mcSources) {
        Set<Path> classpath = JSTExecutor.collectClasspath(sourceSet);
        classpath.remove(mcSources);
        try {
            Path file = Files.createTempFile("jst-libs", "txt", new FileAttribute[0]);
            file.toFile().deleteOnExit();
            try (PrintWriter pw = new PrintWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));){
                for (Path path : classpath) {
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    pw.println(path.toAbsolutePath());
                }
            }
            return file;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write libraries list.", ex);
        }
    }

    private static Set<Path> collectClasspath(SourceSet ss) {
        LinkedHashSet<Path> classpath = new LinkedHashSet<Path>();
        ss.sourcePaths().forEach((n, v) -> classpath.addAll((Collection<Path>)v));
        block4: for (Dependency mainDep : ss.compileDependencies()) {
            Dependency dependency;
            Objects.requireNonNull(mainDep);
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Dependency.MavenDependency.class, Dependency.SourceSetDependency.class}, (Object)dependency, n2)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Dependency.MavenDependency mDep = (Dependency.MavenDependency)dependency;
                    Path classes = (Path)mDep.files().get("classes");
                    if (classes == null) continue block4;
                    classpath.add(classes);
                    break;
                }
                case 1: {
                    Dependency.SourceSetDependency sDep = (Dependency.SourceSetDependency)dependency;
                    classpath.addAll(JSTExecutor.collectClasspath(sDep.sourceSet()));
                }
            }
        }
        return classpath;
    }

    private Path getJstBundle() {
        if (this.jstBundlePath == null) {
            this.jstBundlePath = this.downloadJst();
        }
        return this.jstBundlePath;
    }

    private Path downloadJst() {
        Path dest = JST_NOTATION.toPath(this.env.systemFolder().resolve("libraries"));
        try {
            new HttpEngineDownloadAction().setUrl(JST_NOTATION.toURL("https://proxy-maven.covers1624.net").toString()).setDest(dest).setUseETag(true).setQuiet(false).setEngine((HttpEngine)Java11HttpEngine.create()).execute();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to download JavaSourceTransformer.", ex);
        }
        return dest;
    }
}

