/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.minecraft;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.net.HttpEngineDownloadAction;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.util.HashUtils;
import net.covers1624.wstool.api.Environment;
import net.covers1624.wstool.minecraft.AssetIndexManifest;
import net.covers1624.wstool.minecraft.VersionListManifest;
import net.covers1624.wstool.minecraft.VersionManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssetDownloader.class);
    private final HttpEngine http;
    public final Path assetsDir;
    public final Path versionsDir;
    private static final Optional<Path> APPDATA = Optional.ofNullable(System.getenv("APPDATA")).map(x$0 -> Path.of(x$0, new String[0]));
    private static final Optional<Path> LOCALAPPDATA = Optional.ofNullable(System.getenv("LOCALAPPDATA")).map(x$0 -> Path.of(x$0, new String[0]));
    private static final Optional<Path> USER_HOME = Optional.ofNullable(System.getProperty("user.home")).map(x$0 -> Path.of(x$0, new String[0]));
    private static final Optional<Path> GRADLE_HOME = Optional.ofNullable(System.getProperty("user.home")).map(x$0 -> Path.of(x$0, new String[0])).map(e -> e.resolve(".gradle"));

    public AssetDownloader(Environment env) {
        this.http = (HttpEngine)env.getService(HttpEngine.class);
        this.versionsDir = env.systemFolder().resolve("versions");
        this.assetsDir = env.systemFolder().resolve("assets");
    }

    public VersionManifest.AssetIndex downloadAssets(String mcVersion) {
        LOGGER.info("Updating assets for Minecraft {}", (Object)mcVersion);
        try {
            VersionListManifest versionList = VersionListManifest.update(this.http, this.versionsDir);
            VersionListManifest.Version versionInList = versionList.versionsMap().get(mcVersion);
            if (versionInList == null) {
                throw new RuntimeException("Version doesn't exist? " + mcVersion);
            }
            VersionManifest versionManifest = VersionManifest.update(this.http, this.versionsDir, versionInList);
            AssetIndexManifest assetIndex = AssetIndexManifest.update(this.http, this.assetsDir, versionManifest);
            try (ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() - 1);){
                CompletableFuture[] futures = (CompletableFuture[])FastStream.of(assetIndex.objects().values()).distinct().map(e -> AssetDownloader.updateAsset(executor, this.http, this.assetsDir, e)).toList().toArray(CompletableFuture[]::new);
                CompletableFuture.allOf(futures).join();
            }
            return versionManifest.assetIndex();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to update assets.", ex);
        }
    }

    private static CompletableFuture<Void> updateAsset(ExecutorService executor, HttpEngine http, Path assetsDir, AssetIndexManifest.Asset asset) {
        return CompletableFuture.runAsync(() -> {
            Path dest = assetsDir.resolve("objects").resolve(asset.path());
            try {
                if (AssetDownloader.validate(dest, asset)) {
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (AssetDownloader.copyFromExisting(dest, asset)) {
                return;
            }
            AssetDownloader.downloadAsset(http, dest, asset);
        }, executor);
    }

    private static boolean copyFromExisting(Path dest, AssetIndexManifest.Asset asset) {
        for (Launcher launcher : Launcher.LAUNCHERS) {
            for (Path dir : launcher.paths) {
                try {
                    Path launcherFile = dir.resolve("objects").resolve(asset.path());
                    if (!AssetDownloader.validate(launcherFile, asset)) continue;
                    LOGGER.info("Copying asset from {} asset cache {}", (Object)launcher.name, (Object)asset.hash());
                    Files.deleteIfExists(dest);
                    Files.copy(launcherFile, IOUtils.makeParents((Path)dest), new CopyOption[0]);
                    return true;
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to check/use asset {} from {}", new Object[]{asset.path(), launcher.name, ex});
                }
            }
        }
        return false;
    }

    private static void downloadAsset(HttpEngine http, Path dest, AssetIndexManifest.Asset asset) {
        for (int i = 0; i < 3; ++i) {
            try {
                if (!AssetDownloader.validate(dest, asset)) {
                    Files.deleteIfExists(dest);
                }
                LOGGER.info("Downloading asset {}", (Object)asset.hash());
                new HttpEngineDownloadAction(http).setUrl("https://resources.download.minecraft.net/" + asset.path()).setDest(dest).setQuiet(false).execute();
                if (!AssetDownloader.validate(dest, asset)) continue;
                return;
            }
            catch (IOException ex) {
                LOGGER.error("Error downloading asset. Try {}/{}", new Object[]{i + 1, 3, ex});
            }
        }
    }

    private static boolean validate(Path file, AssetIndexManifest.Asset asset) throws IOException {
        if (Files.notExists(file, new LinkOption[0])) {
            return false;
        }
        if (Files.size(file) != asset.size()) {
            return false;
        }
        return AssetDownloader.sha1File(file).equals(asset.hash());
    }

    private static String sha1File(Path file) throws IOException {
        return HashUtils.hash((HashFunction)Hashing.sha1(), (Path)file).toString();
    }

    private static enum Launcher {
        VANILLA("Vanilla Launcher", APPDATA.map(e -> e.resolve(".minecraft")), USER_HOME.map(e -> e.resolve(".minecraft")), USER_HOME.map(e -> e.resolve("Library/Application Support/minecraft"))),
        CURSE_FORGE("CurseForge Launcher", USER_HOME.map(e -> e.resolve("curseforge/minecraft/Install"))),
        MODRINTH("Modrinth Launcher", APPDATA.map(e -> e.resolve("com.modrinth.theseus/meta/"))),
        FTB_APP("FTBApp", LOCALAPPDATA.map(e -> e.resolve(".ftba/bin")), USER_HOME.map(e -> e.resolve(".ftba/bin")), USER_HOME.map(e -> e.resolve("Library/Application Support/.ftba/bin"))),
        MULTI_MC("MultiMC", USER_HOME.map(e -> e.resolve("scoop/persist/multimc")), USER_HOME.map(e -> e.resolve(".local/share/multimc"))),
        PRISM("Prism Launcher", APPDATA.map(e -> e.resolve("PrismLauncher")), USER_HOME.map(e -> e.resolve(".local/share/PrismLauncher")), USER_HOME.map(e -> e.resolve("Library/Application Support/PrismLauncher"))),
        NFRT("NeoFormRuntime/MDG", GRADLE_HOME.map(e -> e.resolve("caches/neoformruntime"))),
        FABRIC_LOOM("Fabric Loom", GRADLE_HOME.map(e -> e.resolve("caches/fabric-loom"))),
        FORGE_GRADLE("Forge Gradle", GRADLE_HOME.map(e -> e.resolve("caches/forge_gradle")), GRADLE_HOME.map(e -> e.resolve("caches/minecraft")));

        public final String name;
        public final List<Path> paths;
        public static final List<Launcher> LAUNCHERS;

        @SafeVarargs
        private Launcher(String name, Optional<Path> ... paths) {
            this.name = name;
            this.paths = FastStream.of((Object[])paths).filter(Optional::isPresent).map(Optional::get).map(e -> e.resolve("assets")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toImmutableList();
        }

        static {
            LAUNCHERS = List.of(Launcher.values());
        }
    }
}

