/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.minecraft;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.quack.net.HttpEngineDownloadAction;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.wstool.api.Environment;
import net.covers1624.wstool.api.workspace.Dependency;
import net.covers1624.wstool.api.workspace.SourceSet;
import net.covers1624.wstool.api.workspace.Workspace;
import net.covers1624.wstool.api.workspace.runs.RunConfig;
import org.jetbrains.annotations.Nullable;

public class DevLoginProcessor {
    private static final MavenNotation DEVLOGIN_NOTATION = MavenNotation.parse((String)"net.covers1624:DevLogin:0.1.0.5");
    private final HttpEngine http;
    private final Path librariesDir;
    @Nullable
    private Path devLoginJar;

    public DevLoginProcessor(Environment env) {
        this.http = (HttpEngine)env.getService(HttpEngine.class);
        this.librariesDir = env.systemFolder().resolve("libraries");
    }

    public void processWorkspace(Workspace workspace) {
        for (RunConfig config : workspace.runConfigs().values()) {
            this.attachDevLogin(config);
        }
    }

    private void attachDevLogin(RunConfig runConfig) {
        String devLoginProfile = (String)runConfig.config().get("dev_login");
        String mainClass = runConfig.mainClass();
        if (devLoginProfile == null || mainClass == null) {
            return;
        }
        this.addDependency(runConfig);
        runConfig.sysProps().putFirst("devlogin.launch_profile", devLoginProfile);
        runConfig.sysProps().putFirst("devlogin.launch_target", mainClass);
        runConfig.mainClass("net.covers1624.devlogin.DevLogin");
    }

    private void addDependency(RunConfig config) {
        Path devLoginJar = this.getDevLoginJar();
        SourceSet classpath = config.classpath();
        if (classpath == null) {
            return;
        }
        for (Dependency runtimeDependency : classpath.runtimeDependencies()) {
            Dependency.MavenDependency mavenDep;
            if (!(runtimeDependency instanceof Dependency.MavenDependency) || !devLoginJar.equals((mavenDep = (Dependency.MavenDependency)runtimeDependency).files().get("classes"))) continue;
            return;
        }
        classpath.runtimeDependencies().add(new Dependency.MavenDependency(DEVLOGIN_NOTATION, Map.of("classes", devLoginJar)));
    }

    private Path getDevLoginJar() {
        if (this.devLoginJar == null) {
            this.devLoginJar = DEVLOGIN_NOTATION.toPath(this.librariesDir);
            try {
                new HttpEngineDownloadAction().setUrl(DEVLOGIN_NOTATION.toURL("https://proxy-maven.covers1624.net/").toString()).setDest(this.devLoginJar).setUseETag(true).setEngine(this.http).execute();
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to download DevLogin.", ex);
            }
        }
        return this.devLoginJar;
    }
}

