/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.minecraft;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.wstool.api.extension.FrameworkType;
import net.covers1624.wstool.api.workspace.SourceSet;
import net.covers1624.wstool.api.workspace.Workspace;
import org.tomlj.Toml;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

public interface ForgeLikeFramework
extends FrameworkType {
    default public List<Path> collectAccessTransformers(Workspace workspace) {
        return workspace.allProjectModules().flatMap(e -> e.sourceSets().values()).flatMap(e -> (Iterable)e.sourcePaths().get("resources")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(e -> {
            ArrayList arrayList;
            block8: {
                Stream<Path> files = Files.walk(e, new FileVisitOption[0]);
                try {
                    arrayList = FastStream.of(files).filter(f -> f.getFileName().toString().equals("accesstransformer.cfg")).toList();
                    if (files == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Failed to walk files.", ex);
                    }
                }
                files.close();
            }
            return arrayList;
        }).sorted().toList();
    }

    default public List<Path> collectInterfaceInjections(Workspace workspace) {
        return workspace.allProjectModules().flatMap(e -> e.sourceSets().values()).flatMap(e -> (Iterable)e.sourcePaths().get("resources")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(e -> {
            ArrayList arrayList;
            block8: {
                Stream<Path> files = Files.walk(e, new FileVisitOption[0]);
                try {
                    arrayList = FastStream.of(files).filter(f -> {
                        String fName = f.getFileName().toString();
                        return fName.equals("interfaces.json") || fName.equals("interface-injections.json");
                    }).toList();
                    if (files == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Failed to walk files.", ex);
                    }
                }
                files.close();
            }
            return arrayList;
        }).sorted().toList();
    }

    default public List<ModSourceSet> findPossibleMods(Workspace workspace) {
        return workspace.allProjectModules().flatMap(e -> e.sourceSets().values()).flatMap(e -> FastStream.of((Iterable)e.sourcePaths().getOrDefault("resources", List.of())).flatMap(f -> ForgeLikeFramework.parseMods(e, f))).toList(FastStream.infer());
    }

    private static List<ModSourceSet> parseMods(SourceSet sourceSet, Path folder) {
        Path modsToml = folder.resolve("META-INF/mods.toml");
        if (Files.notExists(modsToml, new LinkOption[0])) {
            modsToml = folder.resolve("META-INF/neoforge.mods.toml");
        }
        if (Files.notExists(modsToml, new LinkOption[0])) {
            return List.of();
        }
        try {
            TomlParseResult toml = Toml.parse((Path)modsToml);
            return FastStream.of((Iterable)toml.getArray("mods").toList()).map(e -> (TomlTable)e).map(e -> e.getString("modId")).map(e -> new ModSourceSet((String)e, sourceSet)).toList();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read mods.toml file.");
        }
    }

    public record ModSourceSet(String modId, SourceSet ss) {
    }
}

