/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.minecraft;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.quack.net.HttpEngineDownloadAction;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.wstool.api.Environment;
import net.covers1624.wstool.api.JdkProvider;
import net.covers1624.wstool.api.workspace.Dependency;
import net.covers1624.wstool.api.workspace.SourceSet;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSTExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSTExecutor.class);
    private static final MavenNotation JST_NOTATION = MavenNotation.parse((String)"net.neoforged.jst:jst-cli-bundle:2.0.3");
    private final HttpEngine http;
    private final JdkProvider provider;
    private final Path librariesDir;
    @Nullable
    private Path jstBundlePath;

    public JSTExecutor(Environment env) {
        this.http = (HttpEngine)env.getService(HttpEngine.class);
        this.provider = (JdkProvider)env.getService(JdkProvider.class);
        this.librariesDir = env.systemFolder().resolve("libraries");
    }

    public void applyJST(SourceSet classpath, List<Path> mcSources, List<Path> ifaceInjections, List<Path> accessTransformers, @Nullable String parchmentVersion) {
        if (ifaceInjections.isEmpty() && accessTransformers.isEmpty() && parchmentVersion == null) {
            return;
        }
        Path jst = this.getJstBundle();
        Path javaHome = this.provider.findOrProvisionJdk(JavaVersion.JAVA_21);
        Path librariesList = JSTExecutor.createLibrariesList(classpath, mcSources);
        ArrayList<String> args = new ArrayList<String>();
        args.add(JavaInstall.getJavaExecutable((Path)javaHome, (boolean)true).toAbsolutePath().toString());
        args.add("-jar");
        args.add(jst.toAbsolutePath().toString());
        args.add("--libraries-list");
        args.add(librariesList.toAbsolutePath().toString());
        if (!ifaceInjections.isEmpty()) {
            args.add("--enable-interface-injection");
            for (Path file : ifaceInjections) {
                args.add("--interface-injection-data");
                args.add(file.toAbsolutePath().toString());
            }
        }
        if (!accessTransformers.isEmpty()) {
            args.add("--enable-accesstransformers");
            for (Path file : accessTransformers) {
                args.add("--access-transformer");
                args.add(file.toAbsolutePath().toString());
            }
        }
        if (parchmentVersion != null) {
            args.add("--enable-parchment");
            args.add("--parchment-conflict-prefix");
            args.add("p_");
            args.add("--parchment-mappings");
            args.add(this.downloadParchment(parchmentVersion).toAbsolutePath().toString());
        }
        Path inputZip = null;
        Path outputZip = null;
        if (mcSources.size() == 1) {
            args.add(mcSources.getFirst().toAbsolutePath().toString());
            args.add(mcSources.getFirst().toAbsolutePath().toString());
        } else {
            try {
                inputZip = JSTExecutor.makeSourceZip(mcSources);
                outputZip = Files.createTempFile("jst-output", "zip", new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to create jst input/output zips.", ex);
            }
            args.add("--in-format");
            args.add("ARCHIVE");
            args.add("--out-format");
            args.add("ARCHIVE");
            args.add(inputZip.toAbsolutePath().toString());
            args.add(outputZip.toAbsolutePath().toString());
        }
        LOGGER.info("Running JST for {} iface injections and {} at's.", (Object)ifaceInjections.size(), (Object)accessTransformers.size());
        try {
            Process proc = new ProcessBuilder(args).redirectErrorStream(true).start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));){
                reader.lines().forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
            }
            proc.waitFor();
            if (proc.exitValue() != 0) {
                throw new RuntimeException("Failed to run JST. Exit code: " + proc.exitValue());
            }
            if (outputZip != null) {
                JSTExecutor.extractSourceZip(outputZip, mcSources);
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException("Failed to run JST.", ex);
        }
        finally {
            try {
                Files.deleteIfExists(librariesList);
            }
            catch (IOException iOException) {}
            try {
                if (inputZip != null) {
                    Files.deleteIfExists(inputZip);
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputZip != null) {
                    Files.deleteIfExists(outputZip);
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static Path createLibrariesList(SourceSet sourceSet, List<Path> mcSources) {
        Set<Path> classpath = JSTExecutor.collectClasspath(sourceSet);
        mcSources.forEach(classpath::remove);
        try {
            Path file = Files.createTempFile("jst-libs", "txt", new FileAttribute[0]);
            file.toFile().deleteOnExit();
            try (PrintWriter pw = new PrintWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));){
                for (Path path : classpath) {
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    pw.println(path.toAbsolutePath());
                }
            }
            return file;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write libraries list.", ex);
        }
    }

    private static Set<Path> collectClasspath(SourceSet ss) {
        LinkedHashSet<Path> classpath = new LinkedHashSet<Path>();
        ss.sourcePaths().forEach((n, v) -> classpath.addAll((Collection<Path>)v));
        block5: for (Dependency mainDep : ss.compileDependencies()) {
            Dependency dependency;
            Objects.requireNonNull(mainDep);
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Dependency.MavenDependency.class, Dependency.SourceSetDependency.class, Dependency.FileDependency.class}, (Object)dependency, n2)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Dependency.MavenDependency mDep = (Dependency.MavenDependency)dependency;
                    Path classes = (Path)mDep.files().get("classes");
                    if (classes == null) continue block5;
                    classpath.add(classes);
                    break;
                }
                case 1: {
                    Dependency.SourceSetDependency sDep = (Dependency.SourceSetDependency)dependency;
                    classpath.addAll(JSTExecutor.collectClasspath(sDep.sourceSet()));
                    break;
                }
                case 2: {
                    Dependency.FileDependency fDep = (Dependency.FileDependency)dependency;
                    classpath.add(fDep.file());
                }
            }
        }
        return classpath;
    }

    private static Path makeSourceZip(List<Path> inputs) throws IOException {
        Path zip = Files.createTempFile("jst-input", "zip", new FileAttribute[0]);
        zip.toFile().deleteOnExit();
        try (final ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zip, new OpenOption[0]));){
            for (final Path input : inputs) {
                if (Files.notExists(input, new LinkOption[0])) continue;
                Files.walkFileTree(input, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        zos.putNextEntry(new ZipEntry(input.relativize(file).toString()));
                        Files.copy(file, zos);
                        zos.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        return zip;
    }

    private static void extractSourceZip(Path jstOutputZip, List<Path> inputs) throws IOException {
        try (final ZipFile zipFile = new ZipFile(jstOutputZip.toFile());){
            for (final Path input : inputs) {
                if (Files.notExists(input, new LinkOption[0])) continue;
                Files.walkFileTree(input, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String rel = input.relativize(file).toString();
                        ZipEntry entry = zipFile.getEntry(rel);
                        if (entry == null) {
                            LOGGER.error("JST deleted input file {}", (Object)rel);
                            return FileVisitResult.CONTINUE;
                        }
                        try (InputStream is = zipFile.getInputStream(entry);){
                            Files.copy(is, file, StandardCopyOption.REPLACE_EXISTING);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    private Path getJstBundle() {
        if (this.jstBundlePath == null) {
            this.jstBundlePath = this.downloadMaven(JST_NOTATION);
        }
        return this.jstBundlePath;
    }

    private Path downloadParchment(String versionStr) {
        String[] split = versionStr.split("-");
        if (split.length != 2) {
            throw new RuntimeException("Expected parchment version to be <mc>-<parchment> got: " + versionStr);
        }
        return this.downloadMaven(new MavenNotation("org.parchmentmc.data", "parchment-" + split[0], split[1], null, "zip"));
    }

    private Path downloadMaven(MavenNotation notation) {
        Path dest = notation.toPath(this.librariesDir);
        try {
            new HttpEngineDownloadAction().setUrl(notation.toURL("https://proxy-maven.covers1624.net").toString()).setDest(dest).setUseETag(true).setQuiet(false).setEngine(this.http).execute();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to download JavaSourceTransformer.", ex);
        }
        return dest;
    }
}

