/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.minecraft;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.gson.JsonUtils;
import net.covers1624.quack.net.HttpEngineDownloadAction;
import net.covers1624.quack.net.httpapi.HttpEngine;
import org.jetbrains.annotations.Nullable;

public record VersionListManifest(@Nullable Latest latest, @Nullable List<Version> versions) {
    @Nullable
    private final Latest latest;
    @Nullable
    private final List<Version> versions;
    private static final Gson GSON = new Gson();
    private static final String URL = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";

    public static VersionListManifest update(HttpEngine http, Path versionsDir) throws IOException {
        Path file = versionsDir.resolve("version_manifest_v2.json");
        HttpEngineDownloadAction action = new HttpEngineDownloadAction(http).setUrl(URL).setDest(file).setQuiet(false).setUseETag(true).setOnlyIfModified(true);
        action.execute();
        return (VersionListManifest)JsonUtils.parse((Gson)GSON, (Path)file, VersionListManifest.class);
    }

    public Latest latest() {
        return Objects.requireNonNull(this.latest);
    }

    public List<Version> versions() {
        return this.versions != null ? this.versions : List.of();
    }

    public Map<String, Version> versionsMap() {
        return FastStream.of(this.versions()).toMap(Version::id, Function.identity());
    }

    public record Latest(@Nullable String release, @Nullable String snapshot) {
        @Nullable
        private final String release;
        @Nullable
        private final String snapshot;

        public String release() {
            return Objects.requireNonNull(this.release);
        }

        public String snapshot() {
            return Objects.requireNonNull(this.snapshot);
        }
    }

    public record Version(@Nullable String id, @Nullable String type, @Nullable String url, @Nullable Date time, @Nullable Date releaseTime, @Nullable String sha1, int complianceLevel) {
        @Nullable
        private final String id;
        @Nullable
        private final String type;
        @Nullable
        private final String url;
        @Nullable
        private final Date time;
        @Nullable
        private final Date releaseTime;
        @Nullable
        private final String sha1;

        public String id() {
            return Objects.requireNonNull(this.id);
        }

        public String type() {
            return Objects.requireNonNull(this.type);
        }

        public String url() {
            return Objects.requireNonNull(this.url);
        }

        public Date time() {
            return Objects.requireNonNull(this.time);
        }

        public Date releaseTime() {
            return Objects.requireNonNull(this.releaseTime);
        }

        public String sha1() {
            return Objects.requireNonNull(this.sha1);
        }
    }
}

