/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.minecraft;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import net.covers1624.quack.gson.JsonUtils;
import net.covers1624.quack.net.HttpEngineDownloadAction;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.wstool.minecraft.VersionManifest;
import org.jetbrains.annotations.Nullable;

public record AssetIndexManifest(@Nullable Map<String, Asset> objects, boolean virtual) {
    @Nullable
    private final Map<String, Asset> objects;
    private static final Gson GSON = new Gson();

    public static AssetIndexManifest update(HttpEngine http, Path assetsDir, VersionManifest version) throws IOException {
        VersionManifest.AssetIndex index = version.assetIndex();
        Path file = assetsDir.resolve("indexes/" + index.id() + ".json");
        HttpEngineDownloadAction action = new HttpEngineDownloadAction(http).setUrl(index.url()).setDest(file).setQuiet(false).setUseETag(true).setOnlyIfModified(true);
        action.execute();
        return (AssetIndexManifest)JsonUtils.parse((Gson)GSON, (Path)file, AssetIndexManifest.class);
    }

    public Map<String, Asset> objects() {
        return this.objects != null ? this.objects : Map.of();
    }

    public record Asset(@Nullable String hash, @Nullable Long size) {
        @Nullable
        private final String hash;
        @Nullable
        private final Long size;

        public String hash() {
            return Objects.requireNonNull(this.hash);
        }

        public String path() {
            return this.hash().substring(0, 2) + "/" + this.hash();
        }

        public Long size() {
            return Objects.requireNonNull(this.size);
        }
    }
}

