/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.neoforge.gradle;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.wstool.gradle.ProjectTransformer;
import net.covers1624.wstool.gradle.api.data.PluginData;
import net.covers1624.wstool.gradle.api.data.ProjectData;
import net.covers1624.wstool.gradle.databuild.SourceSetDataBuilder;
import net.covers1624.wstool.neoforge.gradle.api.NeoForgeGradleVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class NeoForgeProjectTransformer
implements ProjectTransformer {
    public void transformProject(Project project, ProjectData projectData) {
        PluginData pluginData = projectData.pluginData();
        NeoForgeGradleVersion version = (NeoForgeGradleVersion)pluginData.getData(NeoForgeGradleVersion.class);
        if (version == null) {
            return;
        }
        if (version.variant == NeoForgeGradleVersion.Variant.NEO_GRADLE) {
            NeoForgeProjectTransformer.filterExtendsFrom(project, e -> e.equals("minecraft"));
            NeoForgeProjectTransformer.filterExtendsFrom(project, e -> e.startsWith("ng_dummy_ng_"));
            NeoForgeProjectTransformer.filterClasspaths(project, e -> "net.neoforged".equals(e.getGroup()) && "neoforge".equals(e.getName()));
        } else if (version.variant == NeoForgeGradleVersion.Variant.MOD_DEV_GRADLE) {
            NeoForgeProjectTransformer.filterExtendsFrom(project, e -> e.startsWith("modDev"));
        }
    }

    private static void filterExtendsFrom(Project project, Predicate<String> toRemove) {
        for (Configuration configuration : project.getConfigurations()) {
            if (!ColUtils.anyMatch((Iterable)configuration.getExtendsFrom(), e -> toRemove.test(e.getName()))) continue;
            ArrayList newExtendsFrom = FastStream.of((Iterable)configuration.getExtendsFrom()).filterNot(e -> toRemove.test(e.getName())).toList();
            configuration.setExtendsFrom((Iterable)newExtendsFrom);
        }
    }

    private static void filterClasspaths(Project project, Predicate<Dependency> predicate) {
        ConfigurationContainer configurations = project.getConfigurations();
        SourceSetContainer sourceSets = SourceSetDataBuilder.getSourceSetContainer((Project)project);
        if (sourceSets == null) {
            return;
        }
        for (SourceSet sourceSet : sourceSets) {
            NeoForgeProjectTransformer.filterClasspath(configurations.getByName(sourceSet.getCompileClasspathConfigurationName()), predicate);
            NeoForgeProjectTransformer.filterClasspath(configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()), predicate);
        }
    }

    private static void filterClasspath(Configuration configuration, Predicate<Dependency> predicate) {
        for (Configuration config : configuration.getHierarchy()) {
            config.getDependencies().removeIf(predicate);
        }
    }
}

