/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.neoforge.gradle;

import java.util.List;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.wstool.gradle.PluginBuilder;
import net.covers1624.wstool.gradle.api.data.Data;
import net.covers1624.wstool.gradle.api.data.PluginData;
import net.covers1624.wstool.neoforge.gradle.api.NeoForgeGradleVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.jetbrains.annotations.Nullable;

public class NeoForgePluginBuilder
implements PluginBuilder {
    public void buildPluginData(Project project, PluginData pluginData, List<String> additionalConfigurations) {
        String ngVersion = NeoForgePluginBuilder.findViaClasspath(project, "net.neoforged", "NeoGradle");
        if (ngVersion == null) {
            ngVersion = NeoForgePluginBuilder.findViaClasspath(project, "net.neoforged.gradle", "userdev");
        }
        if (ngVersion != null) {
            pluginData.putData(NeoForgeGradleVersion.class, (Data)new NeoForgeGradleVersion(NeoForgeGradleVersion.Variant.NEO_GRADLE, ngVersion));
            return;
        }
        String mdgVersion = NeoForgePluginBuilder.findViaClasspath(project, "net.neoforged", "moddev-gradle");
        if (mdgVersion != null) {
            pluginData.putData(NeoForgeGradleVersion.class, (Data)new NeoForgeGradleVersion(NeoForgeGradleVersion.Variant.MOD_DEV_GRADLE, mdgVersion));
        }
    }

    @Nullable
    private static String findViaClasspath(Project project, String group, String name) {
        ConfigurationContainer configurations = project.getBuildscript().getConfigurations();
        Configuration configuration = (Configuration)configurations.findByName("classpath");
        if (configuration == null || !configuration.isCanBeResolved()) {
            project.getLogger().error("Unable to probe 'classpath' configuration for buildscript of project: {}", (Object)project.getDisplayName());
            return null;
        }
        ResolvedArtifact artifact = (ResolvedArtifact)FastStream.of((Iterable)configuration.getResolvedConfiguration().getResolvedArtifacts()).filter(e -> e.getModuleVersion().getId().getGroup().equals(group)).filter(e -> e.getModuleVersion().getId().getName().equals(name)).firstOrDefault();
        if (artifact == null) {
            return null;
        }
        return artifact.getModuleVersion().getId().getVersion();
    }
}

