/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.neoforge;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.net.httpapi.java11.Java11HttpEngine;
import net.covers1624.wstool.api.Environment;
import net.covers1624.wstool.api.GitRepoManager;
import net.covers1624.wstool.api.HashContainer;
import net.covers1624.wstool.api.ModuleProcessor;
import net.covers1624.wstool.api.workspace.Dependency;
import net.covers1624.wstool.api.workspace.Module;
import net.covers1624.wstool.api.workspace.SourceSet;
import net.covers1624.wstool.api.workspace.Workspace;
import net.covers1624.wstool.api.workspace.runs.EvalValue;
import net.covers1624.wstool.api.workspace.runs.RunConfig;
import net.covers1624.wstool.gradle.GradleTaskExecutor;
import net.covers1624.wstool.gradle.api.data.ConfigurationData;
import net.covers1624.wstool.gradle.api.data.ConfigurationList;
import net.covers1624.wstool.gradle.api.data.JavaToolchainData;
import net.covers1624.wstool.gradle.api.data.PluginData;
import net.covers1624.wstool.gradle.api.data.ProjectData;
import net.covers1624.wstool.gradle.api.data.ProjectExtData;
import net.covers1624.wstool.gradle.api.data.SubProjectList;
import net.covers1624.wstool.minecraft.AssetDownloader;
import net.covers1624.wstool.minecraft.ForgeLikeFramework;
import net.covers1624.wstool.minecraft.JSTExecutor;
import net.covers1624.wstool.neoforge.ModClassesEvalValue;
import net.covers1624.wstool.neoforge.gradle.api.NeoDevData;

public interface NeoForgeFrameworkType
extends ForgeLikeFramework {
    public String path();

    public String url();

    public String branch();

    public String commit();

    default public void buildFrameworks(Environment env, Workspace workspace) {
        ModuleProcessor moduleProcessor = (ModuleProcessor)env.getService(ModuleProcessor.class);
        GradleTaskExecutor taskExecutor = (GradleTaskExecutor)env.getService(GradleTaskExecutor.class);
        JSTExecutor jstExecutor = (JSTExecutor)env.getService(JSTExecutor.class);
        Path rootDir = env.projectRoot().resolve(this.path());
        HashContainer hashContainer = new HashContainer(env.projectCache(), "neoforge");
        GitRepoManager gitManager = new GitRepoManager(rootDir);
        gitManager.setConfig(this.url(), this.branch(), this.commit());
        HashContainer.PropertyEntry requiresSetupProp = hashContainer.getProperty("requires_setup").withDefault(true);
        try {
            if (gitManager.checkout()) {
                requiresSetupProp.setValue(true);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to update NeoForge clone.", ex);
        }
        HashContainer.Entry ifaceCache = hashContainer.getEntry("iface_injections");
        List ifaceInjections = this.collectInterfaceInjections(workspace);
        ifaceInjections.forEach(arg_0 -> ((HashContainer.Entry)ifaceCache).putFile(arg_0));
        HashContainer.Entry atCache = hashContainer.getEntry("access_transformers");
        List accessTransformers = this.collectAccessTransformers(workspace);
        accessTransformers.forEach(arg_0 -> ((HashContainer.Entry)atCache).putFile(arg_0));
        Module nfModule = moduleProcessor.buildModule(workspace, rootDir, Set.of());
        Module nfSubModule = (Module)nfModule.subModules().get("neoforge");
        SourceSet nfMain = (SourceSet)nfSubModule.sourceSets().get("main");
        Module nfCoreMods = (Module)nfModule.subModules().get("neoforge-coremods");
        SourceSet nfCoreModsMain = (SourceSet)nfCoreMods.sourceSets().get("main");
        if (requiresSetupProp.getBoolean() || ifaceCache.changed() || atCache.changed()) {
            taskExecutor.runTask(rootDir, "clean");
            taskExecutor.runTask(rootDir, "setup");
            jstExecutor.applyJST(nfMain, nfSubModule.rootDir().resolve("src/main/java"), ifaceInjections, accessTransformers);
            requiresSetupProp.setValue(false);
            ifaceCache.pushChanges();
            atCache.pushChanges();
        }
        this.applyNeoForgeToolchain(Objects.requireNonNull(nfModule.projectData()), workspace);
        LinkedHashSet legacyClasspath = new LinkedHashSet(nfMain.runtimeDependencies());
        for (Module module : workspace.allProjectModules()) {
            if (module == nfModule || nfModule.subModules().containsValue(module)) continue;
            for (SourceSet ss : module.sourceSets().values()) {
                if (!NeoForgeFrameworkType.isNeoForgeModPresent(ss)) continue;
                nfMain.compileDependencies().add(new Dependency.SourceSetDependency(ss));
                ss.compileDependencies().add(new Dependency.SourceSetDependency(nfMain));
            }
        }
        Set<Dependency> moduleClasspath = NeoForgeFrameworkType.buildModuleClasspath(nfModule, nfSubModule, moduleProcessor);
        legacyClasspath.removeAll(moduleClasspath);
        Java11HttpEngine http = Java11HttpEngine.create();
        AssetDownloader.AssetDownloadResult downloadResult = AssetDownloader.downloadAssets((Environment)env, (HttpEngine)http, (String)NeoForgeFrameworkType.getMcVersion(nfSubModule));
        List<String> cliProperties = NeoForgeFrameworkType.buildCliProperties(nfSubModule);
        for (RunConfig run : workspace.runConfigs().values()) {
            String launchTarget;
            run.classpath(nfMain);
            if (run.mainClass() == null) {
                run.mainClass("cpw.mods.bootstraplauncher.BootstrapLauncher");
            }
            run.envVars().putEval("MOD_CLASSES", (EvalValue)new ModClassesEvalValue(List.of(new ModClassesEvalValue.ModClass("minecraft", (Dependency)new Dependency.SourceSetDependency(nfMain)), new ModClassesEvalValue.ModClass("neoforge-coremods", (Dependency)new Dependency.SourceSetDependency(nfCoreModsMain)))));
            run.vmArgs().addFirst(List.of("--add-modules", "ALL-MODULE-PATH", "--add-opens", "java.base/java.util.jar=cpw.mods.securejarhandler", "--add-opens", "java.base/java.lang.invoke=cpw.mods.securejarhandler", "--add-exports", "java.base/sun.security.util=cpw.mods.securejarhandler", "--add-exports", "jdk.naming.dns/com.sun.jndi.dns=java.naming"));
            run.vmArgs().addFirstEval((EvalValue)new EvalValue.ClasspathValue(moduleClasspath));
            run.vmArgs().addFirst("-p");
            run.sysProps().put("java.net.preferIPv6Addresses", "system");
            run.sysProps().put("ignoreList", "mixinextras-neoforge-,client-extra,neoforge-");
            run.sysProps().putEval("legacyClassPath", (EvalValue)new EvalValue.ClasspathValue(legacyClasspath));
            run.args().addAll(List.of("--gameDir", ".", "--assetsDir", downloadResult.assetsDir().toAbsolutePath().toString(), "--assetIndex", downloadResult.assetIndex().id()));
            String string = (String)run.config().get("type");
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"client", "data", "server"}, (Object)string, n)) {
                case 0: {
                    String string2 = "forgeclientdev";
                    break;
                }
                case 1: {
                    String string2 = "forgedatadev";
                    break;
                }
                case 2: {
                    String string2 = "forgeserverdev";
                    break;
                }
                default: {
                    String string2 = launchTarget = null;
                }
            }
            if (launchTarget != null) {
                run.args().addAll(List.of("--launchTarget", launchTarget));
            }
            run.args().addAll(cliProperties);
        }
    }

    private void applyNeoForgeToolchain(ProjectData projectData, Workspace workspace) {
        SubProjectList subProjectData = (SubProjectList)projectData.getData(SubProjectList.class);
        if (subProjectData == null) {
            return;
        }
        ProjectData nfSubProject = (ProjectData)subProjectData.get("neoforge");
        if (nfSubProject == null) {
            return;
        }
        JavaToolchainData toolchainData = (JavaToolchainData)nfSubProject.getData(JavaToolchainData.class);
        if (toolchainData == null) {
            return;
        }
        workspace.setJavaVersion(toolchainData.langVersion);
    }

    private static Set<Dependency> buildModuleClasspath(Module rootModule, Module module, ModuleProcessor processor) {
        ProjectData projectData = Objects.requireNonNull(module.projectData());
        PluginData pluginData = (PluginData)projectData.getData(PluginData.class);
        if (pluginData == null) {
            throw new RuntimeException("Expected PluginData to exist. Unable to setup NeoDev workspace.");
        }
        NeoDevData neoDevData = (NeoDevData)pluginData.getData(NeoDevData.class);
        if (neoDevData == null) {
            throw new RuntimeException("Expected NeoDevData to be extracted. Unable to setup NeoDev workspace.");
        }
        ConfigurationList configurations = Objects.requireNonNull((ConfigurationList)projectData.getData(ConfigurationList.class));
        ConfigurationData moduleClasspathConfiguration = (ConfigurationData)configurations.get(neoDevData.moduleClasspathConfiguration);
        if (moduleClasspathConfiguration == null) {
            throw new RuntimeException("Expected configuration " + neoDevData.moduleClasspathConfiguration + " to be extracted. Unable to setup NeoDev workspace.");
        }
        return processor.processConfiguration(rootModule, moduleClasspathConfiguration);
    }

    private static String getMcVersion(Module module) {
        ProjectData gradleData = Objects.requireNonNull(module.projectData());
        Map properties = Objects.requireNonNull((ProjectExtData)gradleData.getData(ProjectExtData.class)).properties;
        return (String)properties.get("minecraft_version");
    }

    private static List<String> buildCliProperties(Module module) {
        ProjectData gradleData = Objects.requireNonNull(module.projectData());
        Map properties = Objects.requireNonNull((ProjectExtData)gradleData.getData(ProjectExtData.class)).properties;
        String version = gradleData.version;
        return List.of("--version", version, "--fml.neoForgeVersion", version, "--fml.fmlVersion", (String)properties.get("fancy_mod_loader_version"), "--fml.mcVersion", (String)properties.get("minecraft_version"), "--fml.neoFormVersion", (String)properties.get("neoform_version"));
    }

    private static boolean isNeoForgeModPresent(SourceSet sourceSet) {
        for (Path resourcesDir : sourceSet.sourcePaths().getOrDefault("resources", List.of())) {
            if (!Files.exists(resourcesDir.resolve("META-INF/mods.toml"), new LinkOption[0]) && !Files.exists(resourcesDir.resolve("META-INF/neoforge.mods.toml"), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }
}

