/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils;

import a.c.b;
import a.c.c;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.covers1624.a.f.a;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.JavaLocator$Builder;
import net.covers1624.jdkutils.JavaLocator$LocatorProps;
import net.covers1624.jdkutils.JavaPropExtractGenerator;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class JavaLocator {
    private static final b LOGGER = c.a(JavaLocator.class);
    private static final boolean DEBUG = Boolean.getBoolean("net.covers1624.jdkutils.JavaLocator.debug");
    protected final JavaLocator$LocatorProps props;

    protected JavaLocator(JavaLocator$LocatorProps javaLocator$LocatorProps) {
        this.props = javaLocator$LocatorProps;
    }

    public static JavaLocator$Builder a() {
        net.covers1624.a.f.b b2 = net.covers1624.a.f.b.current();
        if (!(b2.isWindows() || b2.isMacos() || b2.isLinux())) {
            throw new UnsupportedOperationException("Unsupported Operating System. " + (Object)((Object)b2));
        }
        return new JavaLocator$Builder(b2, 0);
    }

    public abstract List<JavaInstall> a();

    protected final void a(Map<String, JavaInstall> map, Path object) {
        if (Files.notExists((Path)((Object)object), new LinkOption[0])) {
            return;
        }
        for (Path path : net.covers1624.a.a.b.a(Files.list((Path)((Object)object)))) {
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            Path path2 = this.a(JavaInstall.a(path));
            JavaInstall javaInstall = JavaLocator.a(path2);
            this.a(map, javaInstall);
        }
    }

    protected final void a(Map<String, JavaInstall> map, JavaInstall javaInstall) {
        if (javaInstall == null) {
            return;
        }
        if (this.props.filter != null && this.props.filter != javaInstall.langVersion) {
            return;
        }
        if (this.props.ignoreOpenJ9 && javaInstall.isOpenJ9) {
            return;
        }
        if (this.props.ignoreJres && !javaInstall.hasCompiler) {
            return;
        }
        if (!map.containsKey(javaInstall.javaHome.toString())) {
            map.put(javaInstall.javaHome.toString(), javaInstall);
        }
    }

    protected final Path a(Path path) {
        return JavaInstall.a(path, this.props.useJavaw);
    }

    public static JavaInstall a(Path path) {
        if (DEBUG) {
            LOGGER.a("Attempting to parse install from executable '{}'", path);
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        try {
            Object object = Files.createTempDirectory("java_prop_extract", new FileAttribute[0]);
            JavaPropExtractGenerator.a((Path)object);
            Object object2 = new LinkedList<String>(Arrays.asList(path.normalize().toAbsolutePath().toString(), "-Dfile.encoding=UTF8", "-cp", ".", "PropExtract"));
            Collections.addAll(object2, JavaPropExtractGenerator.DEFAULTS);
            object = new ProcessBuilder(new String[0]).directory(object.toFile()).command((List<String>)object2);
            object2 = new ByteArrayOutputStream();
            object = ((ProcessBuilder)object).start();
            net.covers1624.a.c.a.a(((Process)object).getInputStream(), (OutputStream)object2);
            try {
                boolean bl = ((Process)object).waitFor(30L, TimeUnit.SECONDS);
                if (!bl) {
                    LOGGER.b("Waited more than 30 seconds for {}. Force closing..", path);
                    ((Process)object).destroyForcibly();
                    return null;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted.", interruptedException);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            object = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
            object = new BufferedReader(new InputStreamReader((InputStream)object, StandardCharsets.UTF_8));
            object2 = null;
            try {
                String[] stringArray;
                while ((stringArray = ((BufferedReader)object).readLine()) != null) {
                    if ((stringArray = stringArray.split("=", 2)).length != 2) continue;
                    hashMap.put(stringArray[0], stringArray[1]);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                object2 = throwable;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((BufferedReader)object).close();
                }
            }
            object = Paths.get((String)Objects.requireNonNull(hashMap.get("java.home"), "Missing 'java.home' property for vm: " + path), new String[0]).toAbsolutePath();
            if (object.getFileName().toString().equals("jre") && Files.exists(object.getParent().resolve("bin"), new LinkOption[0])) {
                object = object.getParent();
            }
            return new JavaInstall((Path)object, (String)Objects.requireNonNull(hashMap.get("java.vendor"), "Missing 'java.vendor' property for vm: " + path), (String)Objects.requireNonNull(hashMap.get("java.vm.name"), "Missing 'java.name' property for vm: " + path), (String)Objects.requireNonNull(hashMap.get("java.version"), "Missing 'java.version' property for vm: " + path), (String)Objects.requireNonNull(hashMap.get("java.runtime.name"), "Missing 'java.runtime.name' property for vm: " + path), (String)Objects.requireNonNull(hashMap.get("java.runtime.version"), "Missing 'java.runtime.version' property for vm: " + path), a.parse((String)Objects.requireNonNull(hashMap.get("os.arch"), "Missing 'os.arch' property for vm: " + path)));
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                LOGGER.b("Failed to parse Java install.", throwable);
            }
            return null;
        }
    }
}

