/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum JavaVersion {
    JAVA_1_1("1.1"),
    JAVA_1_2("1.2"),
    JAVA_1_3("1.3"),
    JAVA_1_4("1.4"),
    JAVA_1_5("1.5"),
    JAVA_1_6("6"),
    JAVA_1_7("7"),
    JAVA_1_8("8"),
    JAVA_9("9"),
    JAVA_10("10"),
    JAVA_11("11"),
    JAVA_12("12"),
    JAVA_13("13"),
    JAVA_14("14"),
    JAVA_15("15"),
    JAVA_16("16"),
    JAVA_17("17"),
    JAVA_18("18"),
    JAVA_19("19"),
    JAVA_20("20"),
    JAVA_21("21"),
    JAVA_22("22"),
    JAVA_23("23"),
    JAVA_24("24"),
    JAVA_25("25"),
    JAVA_26("26"),
    JAVA_27("27"),
    JAVA_28("28"),
    JAVA_29("29"),
    JAVA_30("30"),
    UNKNOWN("Unknown");

    private static final Pattern VERSION_SUBSTRING;
    private static final JavaVersion[] VALUES;
    public final String shortString;

    private JavaVersion(String string2) {
        this.shortString = string2;
    }

    public static JavaVersion parse(String object) {
        if (!((Matcher)(object = VERSION_SUBSTRING.matcher((CharSequence)object))).find()) {
            return null;
        }
        object = ((Matcher)object).group(1);
        int[] nArray = JavaVersion.vSplit((String)object);
        object = nArray;
        if (nArray.length > 1 && object[0] == true) {
            return JavaVersion.parseMajorVersion((int)object[1]);
        }
        return JavaVersion.parseMajorVersion((int)object[0]);
    }

    public static JavaVersion parseFromClass(byte[] byArray) {
        if (byArray.length < 8) {
            throw new IllegalArgumentException("Invalid class file. Must be at least 8 bytes.");
        }
        return JavaVersion.parseMajorVersion((byArray[7] & 0xFF) - 44);
    }

    private static JavaVersion parseMajorVersion(int n2) {
        if (n2 >= VALUES.length) {
            return UNKNOWN;
        }
        return VALUES[n2 - 1];
    }

    private static int[] vSplit(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            try {
                nArray[i2] = Integer.parseInt(string2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Failed to parse version string: " + string, numberFormatException);
            }
        }
        return nArray;
    }

    static {
        VERSION_SUBSTRING = Pattern.compile("^([0-9.]*)");
        VALUES = JavaVersion.values();
    }
}

