/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.JavaLocator;
import net.covers1624.jdkutils.JavaLocator$LocatorProps;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.WindowsRegistry;
import net.rubygrapefruit.platform.WindowsRegistry$Key;

public class WindowsJavaLocator
extends JavaLocator {
    private static final String[] ORACLE = new String[]{"SOFTWARE\\JavaSoft\\Java Development Kit", "SOFTWARE\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\JavaSoft\\JRE", "SOFTWARE\\JavaSoft\\JDK", "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Development Kit", "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\Wow6432Node\\JavaSoft\\JRE", "SOFTWARE\\Wow6432Node\\JavaSoft\\JDK"};
    private static final String[] ADOPT_OPEN_JDK = new String[]{"SOFTWARE\\AdoptOpenJDK\\JDK", "SOFTWARE\\AdoptOpenJDK\\JRE", "SOFTWARE\\Wow6432Node\\AdoptOpenJDK\\JDK", "SOFTWARE\\Wow6432Node\\AdoptOpenJDK\\JRE"};
    private static final String[] ADOPTIUM = new String[]{"SOFTWARE\\Eclipse Foundation\\JDK", "SOFTWARE\\Eclipse Foundation\\JRE", "SOFTWARE\\Wow6432Node\\Eclipse Foundation\\JDK", "SOFTWARE\\Wow6432Node\\Eclipse Foundation\\JRE", "SOFTWARE\\Eclipse Adoptium\\JDK", "SOFTWARE\\Eclipse Adoptium\\JRE", "SOFTWARE\\Wow6432Node\\Eclipse Adoptium\\JDK", "SOFTWARE\\Wow6432Node\\Eclipse Adoptium\\JRE"};
    private static final String[] MICROSOFT = new String[]{"SOFTWARE\\Microsoft\\JDK", "SOFTWARE\\Microsoft\\JRE", "SOFTWARE\\Wow6432Node\\Microsoft\\JDK", "SOFTWARE\\Wow6432Node\\Microsoft\\JRE"};
    private static final String[] PATHS = new String[]{"C:/Program Files/AdoptOpenJDK/", "C:/Program Files/Eclipse Foundation/", "C:/Program Files/Eclipse Adoptium/", "C:/Program Files/Java/", "C:/Program Files/Microsoft/", "C:/Program Files (x86)/AdoptOpenJDK/", "C:/Program Files (x86)/Eclipse Foundation/", "C:/Program Files (x86)/Eclipse Adoptium/", "C:/Program Files (x86)/Java", "C:/Program Files (x86)/Microsoft/"};

    public WindowsJavaLocator(JavaLocator$LocatorProps javaLocator$LocatorProps) {
        super(javaLocator$LocatorProps);
    }

    @Override
    public final List<JavaInstall> a() {
        Native.a(null);
        String[] stringArray = Native.a(WindowsRegistry.class);
        LinkedHashMap<String, JavaInstall> linkedHashMap = new LinkedHashMap<String, JavaInstall>();
        this.a((WindowsRegistry)stringArray, linkedHashMap, ORACLE, "", "JavaHome");
        this.a((WindowsRegistry)stringArray, linkedHashMap, ADOPT_OPEN_JDK, WindowsJavaLocator.a(new String[]{"hotspot", "MSI"}), "Path");
        this.a((WindowsRegistry)stringArray, linkedHashMap, ADOPTIUM, WindowsJavaLocator.a(new String[]{"hotspot", "MSI"}), "Path");
        this.a((WindowsRegistry)stringArray, linkedHashMap, MICROSOFT, WindowsJavaLocator.a(new String[]{"hotspot", "MSI"}), "Path");
        stringArray = PATHS;
        int n2 = PATHS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            this.a(linkedHashMap, Paths.get(string, new String[0]));
        }
        if (this.props.findGradleJdks) {
            this.a(linkedHashMap, Paths.get(System.getProperty("user.home"), ".gradle/jdks"));
        }
        if (this.props.findIntellijJdks) {
            this.a(linkedHashMap, Paths.get(System.getProperty("user.home"), ".jdks"));
        }
        return new ArrayList<JavaInstall>(linkedHashMap.values());
    }

    private void a(WindowsRegistry windowsRegistry, Map<String, JavaInstall> map, String[] stringArray, String string, String string2) {
        for (String string3 : stringArray) {
            for (String string4 : WindowsJavaLocator.a(windowsRegistry, WindowsRegistry$Key.HKEY_LOCAL_MACHINE, string3)) {
                Path path = WindowsJavaLocator.a(windowsRegistry, WindowsRegistry$Key.HKEY_LOCAL_MACHINE, WindowsJavaLocator.a(new String[]{string4, string}), string2);
                if (path == null) continue;
                Path path3 = path.toAbsolutePath();
                path3 = this.a(JavaInstall.a(path3));
                JavaInstall javaInstall = WindowsJavaLocator.a(path3);
                this.a(map, javaInstall);
            }
        }
    }

    private static Path a(WindowsRegistry windowsRegistry, WindowsRegistry$Key windowsRegistry$Key, String string, String string2) {
        try {
            return Paths.get(windowsRegistry.a(windowsRegistry$Key, string, string2), new String[0]);
        }
        catch (MissingRegistryEntryException missingRegistryEntryException) {
            return null;
        }
    }

    private static List<String> a(WindowsRegistry windowsRegistry, WindowsRegistry$Key windowsRegistry$Key, String string) {
        try {
            return windowsRegistry.a(windowsRegistry$Key, string).stream().map(string2 -> WindowsJavaLocator.a(new String[]{string, string2})).collect(Collectors.toList());
        }
        catch (MissingRegistryEntryException missingRegistryEntryException) {
            return Collections.emptyList();
        }
    }

    private static String a(String ... stringArray) {
        return Arrays.stream(stringArray).filter(string -> string != null && !string.isEmpty()).collect(Collectors.joining("\\"));
    }
}

