/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.util.Arrays;
import java.util.List;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.internal.NativeLibraryLoader;
import net.rubygrapefruit.platform.internal.Platform$FreeBSD32Bit;
import net.rubygrapefruit.platform.internal.Platform$FreeBSD64Bit;
import net.rubygrapefruit.platform.internal.Platform$Linux32Bit;
import net.rubygrapefruit.platform.internal.Platform$Linux64Bit;
import net.rubygrapefruit.platform.internal.Platform$LinuxAarch64;
import net.rubygrapefruit.platform.internal.Platform$MacOs32Bit;
import net.rubygrapefruit.platform.internal.Platform$MacOs64Bit;
import net.rubygrapefruit.platform.internal.Platform$Unsupported;
import net.rubygrapefruit.platform.internal.Platform$Window32Bit;
import net.rubygrapefruit.platform.internal.Platform$Window64Bit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class Platform {
    private static Platform a;

    public static Platform a() {
        Class<Platform> clazz = Platform.class;
        synchronized (Platform.class) {
            if (a == null) {
                String string = System.getProperty("os.name").toLowerCase();
                String string2 = System.getProperty("os.arch");
                if (string.contains("windows")) {
                    if (string2.equals("x86")) {
                        a = new Platform$Window32Bit(0);
                    } else if (string2.equals("amd64")) {
                        a = new Platform$Window64Bit(0);
                    }
                } else if (string.contains("linux")) {
                    if (string2.equals("amd64") || string2.equals("x86_64")) {
                        a = new Platform$Linux64Bit(0);
                    } else if (string2.equals("i386") || string2.equals("x86")) {
                        a = new Platform$Linux32Bit(0);
                    } else if (string2.equals("aarch64")) {
                        a = new Platform$LinuxAarch64(0);
                    }
                } else if (string.contains("os x") || string.contains("darwin")) {
                    if (string2.equals("i386")) {
                        a = new Platform$MacOs32Bit(0);
                    } else if (string2.equals("x86_64") || string2.equals("amd64") || string2.equals("universal")) {
                        a = new Platform$MacOs64Bit(0);
                    }
                } else if (string.contains("freebsd")) {
                    if (string2.equals("amd64")) {
                        a = new Platform$FreeBSD64Bit(0);
                    } else if (string2.equals("i386") || string2.equals("x86")) {
                        a = new Platform$FreeBSD32Bit(0);
                    }
                }
                if (a == null) {
                    a = new Platform$Unsupported(0);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    public String toString() {
        return String.format("%s %s", System.getProperty("os.name"), System.getProperty("os.arch"));
    }

    public <T extends NativeIntegration> Class<? extends T> a(Class<T> clazz) {
        return clazz;
    }

    public <T extends NativeIntegration> T a(Class<T> clazz, NativeLibraryLoader nativeLibraryLoader) {
        throw new NativeIntegrationUnavailableException(String.format("Native integration %s is not supported for %s.", clazz.getSimpleName(), this.toString()));
    }

    public String a() {
        throw new NativeIntegrationUnavailableException(String.format("Native integration is not available for %s.", this.toString()));
    }

    public List<String> a() {
        return Arrays.asList(this.b());
    }

    public abstract String b();
}

