/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils.provisioning.adoptium;

import a.d.b;
import a.d.c;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.covers1624.jdkutils.JdkInstallationManager$JdkProvisioner;
import net.covers1624.jdkutils.JdkInstallationManager$ProvisionRequest;
import net.covers1624.jdkutils.JdkInstallationManager$ProvisionResult;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumApiUtils;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumApiUtils$ReleaseResult;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumRelease;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumRelease$Binary;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumRelease$Package;
import net.covers1624.jdkutils.utils.ArchiveUtils;
import net.covers1624.jdkutils.utils.Utils;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.net.httpapi.EngineResponse;
import net.covers1624.quack.net.httpapi.HttpEngine;

public class AdoptiumProvisioner
implements JdkInstallationManager$JdkProvisioner {
    private static final b LOGGER = c.a(AdoptiumProvisioner.class);
    private final HttpEngine http;

    public AdoptiumProvisioner(HttpEngine httpEngine) {
        this.http = httpEngine;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final JdkInstallationManager$ProvisionResult a(Path object, JdkInstallationManager$ProvisionRequest object2) {
        Object object3;
        Path path;
        AdoptiumRelease$Package adoptiumRelease$Package;
        AdoptiumRelease$Binary adoptiumRelease$Binary;
        AdoptiumRelease adoptiumRelease;
        AdoptiumApiUtils$ReleaseResult adoptiumApiUtils$ReleaseResult;
        block31: {
            LOGGER.b("Attempting to provision Adoptium jvm for {}({}).", (Object)((JdkInstallationManager$ProvisionRequest)object2).version, (Object)((JdkInstallationManager$ProvisionRequest)object2).semver);
            adoptiumApiUtils$ReleaseResult = AdoptiumApiUtils.a(this.http, ((JdkInstallationManager$ProvisionRequest)object2).version, ((JdkInstallationManager$ProvisionRequest)object2).semver, ((JdkInstallationManager$ProvisionRequest)object2).jre, ((JdkInstallationManager$ProvisionRequest)object2).forceX64OnMac);
            if (adoptiumApiUtils$ReleaseResult == null) throw new FileNotFoundException("Adoptium can't provide jvm for " + (Object)((Object)((JdkInstallationManager$ProvisionRequest)object2).version) + "(" + ((JdkInstallationManager$ProvisionRequest)object2).semver + ")");
            if (adoptiumApiUtils$ReleaseResult.releases.isEmpty()) {
                throw new FileNotFoundException("Adoptium can't provide jvm for " + (Object)((Object)((JdkInstallationManager$ProvisionRequest)object2).version) + "(" + ((JdkInstallationManager$ProvisionRequest)object2).semver + ")");
            }
            adoptiumRelease = adoptiumApiUtils$ReleaseResult.releases.get(0);
            if (adoptiumRelease.binaries.isEmpty()) {
                throw new FileNotFoundException("Adoptium returned a release, but id did not contain any binaries.. " + (Object)((Object)((JdkInstallationManager$ProvisionRequest)object2).version) + "(" + ((JdkInstallationManager$ProvisionRequest)object2).semver + ")");
            }
            if (adoptiumRelease.binaries.size() != 1) {
                LOGGER.c("Adoptium returned more than one binary? Api change? Using first!");
            }
            adoptiumRelease$Binary = adoptiumRelease.binaries.get(0);
            adoptiumRelease$Package = adoptiumRelease$Binary.pkg;
            LOGGER.b("Release found {}, Download {}", (Object)adoptiumRelease.version_data.openjdk_version, (Object)adoptiumRelease$Package.link);
            path = object.resolve(adoptiumRelease$Package.name);
            LOGGER.a("Downloading archive to {}", (Object)path);
            Object object4 = this.http.newRequest().method("GET", null).url(adoptiumRelease$Package.link);
            if (((JdkInstallationManager$ProvisionRequest)object2).requestListener != null) {
                object4.listener(((JdkInstallationManager$ProvisionRequest)object2).requestListener);
            }
            EngineResponse engineResponse = object4.execute();
            Throwable throwable = null;
            try {
                block30: {
                    int n2 = engineResponse.statusCode();
                    if (n2 < 200) throw new IOException("Failed to download adoptium release. Got non 2XX response " + n2);
                    if (n2 >= 300) {
                        throw new IOException("Failed to download adoptium release. Got non 2XX response " + n2);
                    }
                    object3 = engineResponse.body();
                    if (object3 == null) {
                        throw new IOException("Failed to download adoptium release. Got 2XX response with no body..");
                    }
                    object3 = object3.a();
                    object4 = null;
                    try {
                        block29: {
                            SeekableByteChannel seekableByteChannel = Files.newByteChannel(IOUtils.a(path), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                            Throwable throwable2 = null;
                            try {
                                IOUtils.a((ReadableByteChannel)object3, seekableByteChannel);
                                if (seekableByteChannel == null) break block29;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    object = throwable3;
                                    throwable2 = throwable3;
                                    throw object;
                                }
                                catch (Throwable throwable4) {
                                    if (seekableByteChannel == null) throw throwable4;
                                    if (throwable2 == null) {
                                        seekableByteChannel.close();
                                        throw throwable4;
                                    }
                                    try {
                                        seekableByteChannel.close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                            }
                            seekableByteChannel.close();
                        }
                        if (object3 == null) break block30;
                    }
                    catch (Throwable throwable6) {
                        try {
                            Throwable throwable7 = throwable6;
                            object4 = throwable6;
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            if (object3 == null) throw throwable8;
                            if (object4 == null) {
                                object3.close();
                                throw throwable8;
                            }
                            try {
                                object3.close();
                                throw throwable8;
                            }
                            catch (Throwable throwable9) {
                                ((Throwable)object4).addSuppressed(throwable9);
                                throw throwable8;
                            }
                        }
                    }
                    object3.close();
                }
                if (engineResponse == null) break block31;
            }
            catch (Throwable throwable10) {
                try {
                    object2 = throwable10;
                    throwable = throwable10;
                    throw object2;
                }
                catch (Throwable throwable11) {
                    if (engineResponse == null) throw throwable11;
                    if (throwable == null) {
                        engineResponse.close();
                        throw throwable11;
                    }
                    try {
                        engineResponse.close();
                        throw throwable11;
                    }
                    catch (Throwable throwable12) {
                        throwable.addSuppressed(throwable12);
                        throw throwable11;
                    }
                }
            }
            engineResponse.close();
        }
        LOGGER.a("File downloaded.");
        long l2 = Files.size(path);
        if (l2 != (long)adoptiumRelease$Package.size) {
            throw new IOException("Downloaded archive size incorrect. Expected " + adoptiumRelease$Package.size + ", Got: " + l2);
        }
        object3 = Utils.a("SHA-256", path);
        if (!object3.equals(adoptiumRelease$Package.checksum)) {
            throw new IOException("Downloaded archive hash incorrect. Expected " + adoptiumRelease$Package.checksum + ", Got: " + (String)object3);
        }
        object3 = ArchiveUtils.a((Path)object, path);
        Files.deleteIfExists(path);
        return new JdkInstallationManager$ProvisionResult(adoptiumRelease.version_data.openjdk_version, (Path)object3, "jdk".equals(adoptiumRelease$Binary.image_type), adoptiumApiUtils$ReleaseResult.architecture);
    }
}

