/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.wrapper;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Hashing {
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";

    public static String hashFile(String object, Path path) {
        object = Hashing.digest((String)object);
        Hashing.addFileBytes((MessageDigest)object, path);
        return Hashing.toString((MessageDigest)object);
    }

    public static MessageDigest digest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Digest not found: " + string, noSuchAlgorithmException);
        }
    }

    public static void addUTFBytes(MessageDigest messageDigest, String string) {
        messageDigest.update(string.getBytes(StandardCharsets.UTF_8));
    }

    public static void tryAddFileBytes(MessageDigest messageDigest, Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            Hashing.addFileBytes(messageDigest, path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addFileBytes(MessageDigest object, Path object2) {
        object2 = Files.newInputStream((Path)object2, new OpenOption[0]);
        Throwable throwable = null;
        try {
            Hashing.addStreamBytes((MessageDigest)object, (InputStream)object2);
            if (object2 == null) return;
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (object2 == null) throw throwable3;
                if (throwable != null) {
                    try {
                        ((InputStream)object2).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable3;
                } else {
                    ((InputStream)object2).close();
                }
                throw throwable3;
            }
        }
        ((InputStream)object2).close();
        return;
    }

    public static void addStreamBytes(MessageDigest messageDigest, InputStream inputStream) {
        int n2;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n2);
        }
    }

    public static String toString(MessageDigest object) {
        object = ((MessageDigest)object).digest();
        StringBuilder stringBuilder = new StringBuilder(2 * ((Object)object).length);
        for (Object object2 : object) {
            stringBuilder.append(Character.forDigit(object2 >> 4 & 0xF, 16));
            stringBuilder.append(Character.forDigit(object2 & 0xF, 16));
        }
        return ((Object)stringBuilder).toString();
    }
}

