/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.platform;

import java.util.Locale;

public enum OperatingSystem {
    WINDOWS,
    MACOS,
    LINUX,
    SOLARIS,
    FREEBSD,
    UNKNOWN;

    private static final OperatingSystem CURRENT;

    public static OperatingSystem current() {
        return CURRENT;
    }

    public static OperatingSystem parse(String string) {
        if ((string = string.toLowerCase(Locale.ROOT)).contains("windows")) {
            return WINDOWS;
        }
        if (string.contains("linux")) {
            return LINUX;
        }
        if (string.contains("osx") || string.contains("os x") || string.contains("darwin")) {
            return MACOS;
        }
        if (string.contains("sunos") || string.contains("solaris")) {
            return SOLARIS;
        }
        if (string.contains("freebsd")) {
            return FREEBSD;
        }
        return UNKNOWN;
    }

    public final boolean isWindows() {
        return this == WINDOWS;
    }

    public final boolean isMacos() {
        return this == MACOS;
    }

    public final boolean isLinux() {
        return this == LINUX;
    }

    public final boolean isSolaris() {
        return this == SOLARIS;
    }

    public final boolean isFreebsd() {
        return this == FREEBSD;
    }

    public final boolean isUnixLike() {
        return this == MACOS || this == LINUX || this == SOLARIS || this == FREEBSD;
    }

    public final String exeSuffix(String string) {
        if (this == WINDOWS) {
            return string + ".exe";
        }
        return string;
    }

    static {
        CURRENT = OperatingSystem.parse(System.getProperty("os.name"));
    }
}

