/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.jdkutils.utils.JavaPropExtractGenerator;
import net.covers1624.jdkutils.utils.JavaPropExtractor;
import net.covers1624.quack.platform.Architecture;
import net.covers1624.quack.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JavaInstall {
    public final JavaVersion langVersion;
    public final Path javaHome;
    public final String vendor;
    public final String implName;
    public final String implVersion;
    public final String runtimeName;
    public final String runtimeVersion;
    public final Architecture architecture;
    public final boolean isOpenJ9;
    public final boolean hasCompiler;

    private JavaInstall(Path path, String string, String string2, String string3, String string4, String string5, Architecture architecture) {
        this.langVersion = Objects.requireNonNull(JavaVersion.parse(string3), "Unable to parse java version: " + string3);
        this.javaHome = path;
        this.vendor = string;
        this.implName = string2;
        this.implVersion = string3;
        this.runtimeName = string4;
        this.runtimeVersion = string5;
        this.architecture = architecture;
        this.isOpenJ9 = string2.contains("J9");
        this.hasCompiler = Files.exists(JavaInstall.a(path, "javac"), new LinkOption[0]);
    }

    public static Path a(Path path) {
        if (OperatingSystem.current().isMacos()) {
            return path.resolve("Contents/Home");
        }
        return path;
    }

    public static Path a(Path path, boolean bl2) {
        OperatingSystem operatingSystem = OperatingSystem.current();
        return JavaInstall.a(path, operatingSystem.isWindows() && bl2 ? "javaw" : "java");
    }

    private static Path a(Path path, String string) {
        return path.resolve("bin").resolve(OperatingSystem.current().exeSuffix(string));
    }

    @Nullable
    public static JavaInstall a(Path path) {
        HashMap hashMap = JavaPropExtractor.a((Path)path, Arrays.asList(JavaPropExtractGenerator.DEFAULTS));
        if (hashMap == null) {
            return null;
        }
        Path path2 = Paths.get((String)Objects.requireNonNull(hashMap.get("java.home"), "Missing 'java.home' property for vm: " + path), new String[0]).toAbsolutePath();
        if (path2.getFileName().toString().equals("jre") && Files.exists(path2.getParent().resolve("bin"), new LinkOption[0])) {
            path2 = path2.getParent();
        }
        return new JavaInstall(path2, (String)Objects.requireNonNull(hashMap.get("java.vendor"), "Missing 'java.vendor' property for vm: " + path), (String)Objects.requireNonNull(hashMap.get("java.vm.name"), "Missing 'java.name' property for vm: " + path), (String)Objects.requireNonNull(hashMap.get("java.version"), "Missing 'java.version' property for vm: " + path), (String)Objects.requireNonNull(hashMap.get("java.runtime.name"), "Missing 'java.runtime.name' property for vm: " + path), (String)Objects.requireNonNull(hashMap.get("java.runtime.version"), "Missing 'java.runtime.version' property for vm: " + path), Architecture.parse((String)Objects.requireNonNull(hashMap.get("os.arch"), "Missing 'os.arch' property for vm: " + path)));
    }

    public String toString() {
        return "JavaInstall{langVersion=" + (Object)((Object)this.langVersion) + ", javaHome=" + this.javaHome + ", vendor='" + this.vendor + '\'' + ", implName='" + this.implName + '\'' + ", implVersion='" + this.implVersion + '\'' + ", runtimeName='" + this.runtimeName + '\'' + ", runtimeVersion='" + this.runtimeVersion + '\'' + ", architecture=" + (Object)((Object)this.architecture) + ", isOpenJ9=" + this.isOpenJ9 + ", hasCompiler=" + this.hasCompiler + '}';
    }
}

