/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j;

import java.nio.ByteBuffer;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.core.Memory;
import net.covers1624.curl4j.util.CurlBindable;
import net.covers1624.curl4j.util.CurlHandle;
import org.jetbrains.annotations.VisibleForTesting;

public class ErrorBuffer
implements CurlBindable {
    public static final int CURL_ERROR_SIZE = 256;
    private static int ERROR_BUFFER_SIZE = 256;
    public final int size;
    @VisibleForTesting
    final ByteBuffer buf;
    public final long address;

    public static void setErrorBufferSize(int size) {
        if (size > ERROR_BUFFER_SIZE) {
            ERROR_BUFFER_SIZE = size;
        }
    }

    public ErrorBuffer() {
        this(ERROR_BUFFER_SIZE);
    }

    public ErrorBuffer(int size) {
        this.size = size;
        this.buf = ByteBuffer.allocateDirect(size);
        this.address = Memory.getDirectByteBufferAddress(this.buf);
    }

    public void clear() {
        Memory.putByte(this.address, (byte)0);
    }

    public String toString() {
        int len;
        for (len = 0; len < this.size && Memory.getByte(this.address + (long)len) != 0; ++len) {
        }
        if (len == 0) {
            return "";
        }
        if (len == this.size) {
            return Memory.readUtf8(this.address, this.size);
        }
        return Memory.readUtf8(this.address);
    }

    @Override
    public void apply(CurlHandle handle) {
        this.apply(handle.curl);
    }

    @Override
    public void apply(long curl) {
        CURL.curl_easy_setopt(curl, 10010, this.address);
    }
}

