/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.core;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import net.covers1624.curl4j.core.LibraryLoader;
import net.covers1624.curl4j.core.NativeTypes;
import net.covers1624.curl4j.core.Pointer;
import sun.misc.Unsafe;

public final class Memory {
    private static final Unsafe UNSAFE;
    private static final ThreadLocal<Stack> STACKS;
    public static final long NULL = 0L;

    private Memory() {
    }

    public static Stack getStack() {
        return STACKS.get();
    }

    public static Stack pushStack() {
        return STACKS.get().push();
    }

    public static boolean getBoolean(long ptr) {
        return UNSAFE.getByte(null, ptr) != 0;
    }

    public static byte getByte(long ptr) {
        return UNSAFE.getByte(null, ptr);
    }

    public static short getShort(long ptr) {
        return UNSAFE.getShort(null, ptr);
    }

    public static int getInt(long ptr) {
        return UNSAFE.getInt(null, ptr);
    }

    public static long getLong(long ptr) {
        return UNSAFE.getLong(null, ptr);
    }

    public static float getFloat(long ptr) {
        return UNSAFE.getFloat(null, ptr);
    }

    public static double getDouble(long ptr) {
        return UNSAFE.getDouble(null, ptr);
    }

    public static long getCLong(long ptr) {
        return NativeTypes.CLONG_SIZE == 8 ? Memory.getLong(ptr) : (long)Memory.getInt(ptr);
    }

    public static long getSizeT(long ptr) {
        return NativeTypes.SIZE_T_SIZE == 8 ? Memory.getLong(ptr) : (long)Memory.getInt(ptr);
    }

    public static long getAddress(long ptr) {
        return NativeTypes.IS_64BIT ? Memory.getLong(ptr) : (long)Memory.getInt(ptr);
    }

    public static void putByte(long ptr, byte value) {
        UNSAFE.putByte(null, ptr, value);
    }

    public static void putShort(long ptr, short value) {
        UNSAFE.putShort(null, ptr, value);
    }

    public static void putInt(long ptr, int value) {
        UNSAFE.putInt(null, ptr, value);
    }

    public static void putLong(long ptr, long value) {
        UNSAFE.putLong(null, ptr, value);
    }

    public static void putFloat(long ptr, float value) {
        UNSAFE.putFloat(null, ptr, value);
    }

    public static void putDouble(long ptr, double value) {
        UNSAFE.putDouble(null, ptr, value);
    }

    public static void putCLong(long ptr, long value) {
        if (NativeTypes.CLONG_SIZE == 8) {
            Memory.putLong(ptr, value);
        } else {
            Memory.putInt(ptr, (int)value);
        }
    }

    public static void putSizeT(long ptr, long value) {
        if (NativeTypes.SIZE_T_SIZE == 8) {
            Memory.putLong(ptr, value);
        } else {
            Memory.putInt(ptr, (int)value);
        }
    }

    public static void putAddress(long ptr, long value) {
        if (NativeTypes.IS_64BIT) {
            Memory.putLong(ptr, value);
        } else {
            Memory.putInt(ptr, (int)value);
        }
    }

    public static long malloc(long bytes) {
        return UNSAFE.allocateMemory(bytes);
    }

    public static void free(long address) {
        UNSAFE.freeMemory(address);
    }

    public static long realloc(long address, long bytes) {
        return UNSAFE.reallocateMemory(address, bytes);
    }

    public static void memcpy(long src, long dst, long len) {
        UNSAFE.copyMemory(src, dst, len);
    }

    public static native String readUtf8(long var0);

    public static String readUtf8(long strBuf, int len) {
        try (Stack stack = Memory.pushStack();){
            long buffer = stack.nmalloc(len + 1);
            Memory.memcpy(strBuf, buffer, len);
            Memory.putByte(buffer + (long)len, (byte)0);
            String string = Memory.readUtf8(buffer);
            return string;
        }
    }

    public static native ByteBuffer newDirectByteBuffer(long var0, int var2);

    public static native long getDirectByteBufferAddress(ByteBuffer var0);

    public static native long newGlobalRef(Object var0);

    public static native void deleteGlobalRef(long var0);

    public static native <T> T getGlobalRefValue(long var0);

    private static Unsafe getUnsafe() {
        try {
            int mod = 24;
            for (Field field : Unsafe.class.getDeclaredFields()) {
                if ((field.getModifiers() & mod) != mod || !field.getType().equals(Unsafe.class)) continue;
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
        }
        catch (Throwable ex) {
            throw new UnsupportedOperationException("Failed to get Unsafe instance.", ex);
        }
        throw new UnsupportedOperationException("libcurl4j requires sun.misc.Unsafe.");
    }

    static {
        STACKS = ThreadLocal.withInitial(() -> new Stack(16384));
        LibraryLoader.initialize();
        UNSAFE = Memory.getUnsafe();
    }

    public static class Stack
    implements AutoCloseable {
        private final ByteBuffer data;
        public final long address;
        public final int size;
        private int ptr;
        private int stackIdx;
        private final int[] stack = new int[Integer.getInteger("net.covers1624.libcurl4j.stack_size", 16).intValue()];

        private Stack(int size) {
            this(ByteBuffer.allocateDirect(size));
        }

        private Stack(ByteBuffer data) {
            this.data = data;
            this.address = Memory.getDirectByteBufferAddress(data);
            this.ptr = this.size = data.remaining();
        }

        public Stack push() {
            if (this.stackIdx == this.stack.length) {
                throw new IndexOutOfBoundsException("Stack too deep. Expand with 'net.covers1624.libcurl4j.stack_size' System Property.");
            }
            this.stack[this.stackIdx++] = this.ptr;
            return this;
        }

        public Stack pop() {
            if (this.stackIdx == 0) {
                throw new IndexOutOfBoundsException("Can't pop and unpushed stack. You have misaligned push/pop's");
            }
            this.ptr = this.stack[--this.stackIdx];
            return this;
        }

        @Override
        public void close() {
            this.pop();
        }

        public int remainingBytes() {
            return this.ptr;
        }

        public long getPointerAddress() {
            return this.address + (long)this.ptr;
        }

        public long nmalloc(int size) {
            if (this.ptr - size < 0) {
                throw new OutOfMemoryError("Out of stack space.");
            }
            this.ptr -= size;
            return this.getPointerAddress();
        }

        public ByteBuffer malloc(int size) {
            return Memory.newDirectByteBuffer(this.nmalloc(size), size);
        }

        public Pointer mallocPointer() {
            return new Pointer(this.nmalloc(NativeTypes.POINTER_SIZE));
        }
    }
}

