/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j;

import net.covers1624.curl4j.CURLMsg;
import net.covers1624.curl4j.CurlCallback;
import net.covers1624.curl4j.CurlReadCallback;
import net.covers1624.curl4j.CurlSeekCallback;
import net.covers1624.curl4j.core.Library;
import net.covers1624.curl4j.core.LibraryLoader;
import net.covers1624.curl4j.core.Memory;
import net.covers1624.curl4j.core.NativeType;
import net.covers1624.curl4j.core.Pointer;
import net.covers1624.curl4j.curl_blob;
import net.covers1624.curl4j.curl_slist;
import net.covers1624.curl4j.curl_version_info_data;
import org.jetbrains.annotations.Nullable;

public class CURL {
    @Nullable
    private static String LIB_CURL_OVERRIDE;
    @Nullable
    private static Library CURL;
    public static final long CURL_GLOBAL_SSL = 1L;
    public static final long CURL_GLOBAL_WIN32 = 2L;
    public static final long CURL_GLOBAL_ALL = 3L;
    public static final long CURL_GLOBAL_NOTHING = 0L;
    public static final long CURL_GLOBAL_DEFAULT = 3L;
    public static final long CURL_GLOBAL_ACK_EINTR = 4L;
    private static final int CURLOPTTYPE_LONG = 0;
    private static final int CURLOPTTYPE_OBJECTPOINT = 10000;
    private static final int CURLOPTTYPE_FUNCTIONPOINT = 20000;
    private static final int CURLOPTTYPE_OFF_T = 30000;
    private static final int CURLOPTTYPE_BLOB = 40000;
    private static final int CURLOPTTYPE_STRINGPOINT = 10000;
    private static final int CURLOPTTYPE_SLISTPOINT = 10000;
    private static final int CURLOPTTYPE_CBPOINT = 10000;
    private static final int CURLOPTTYPE_VALUES = 0;
    public static final int CURLOPT_WRITEDATA = 10001;
    public static final int CURLOPT_URL = 10002;
    public static final int CURLOPT_PORT = 3;
    public static final int CURLOPT_PROXY = 10004;
    public static final int CURLOPT_USERPWD = 10005;
    public static final int CURLOPT_PROXYUSERPWD = 10006;
    public static final int CURLOPT_RANGE = 10007;
    public static final int CURLOPT_READDATA = 10009;
    public static final int CURLOPT_ERRORBUFFER = 10010;
    public static final int CURLOPT_WRITEFUNCTION = 20011;
    public static final int CURLOPT_READFUNCTION = 20012;
    public static final int CURLOPT_TIMEOUT = 13;
    public static final int CURLOPT_INFILESIZE = 14;
    public static final int CURLOPT_POSTFIELDS = 10015;
    public static final int CURLOPT_REFERER = 10016;
    public static final int CURLOPT_FTPPORT = 10017;
    public static final int CURLOPT_USERAGENT = 10018;
    public static final int CURLOPT_LOW_SPEED_LIMIT = 19;
    public static final int CURLOPT_LOW_SPEED_TIME = 20;
    public static final int CURLOPT_RESUME_FROM = 21;
    public static final int CURLOPT_COOKIE = 10022;
    public static final int CURLOPT_HTTPHEADER = 10023;
    @Deprecated
    public static final int CURLOPT_HTTPPOST = 10024;
    public static final int CURLOPT_SSLCERT = 10025;
    public static final int CURLOPT_KEYPASSWD = 10026;
    public static final int CURLOPT_CRLF = 27;
    public static final int CURLOPT_QUOTE = 10028;
    public static final int CURLOPT_HEADERDATA = 10029;
    public static final int CURLOPT_COOKIEFILE = 10031;
    public static final int CURLOPT_SSLVERSION = 32;
    public static final int CURLOPT_TIMECONDITION = 33;
    public static final int CURLOPT_TIMEVALUE = 34;
    public static final int CURLOPT_CUSTOMREQUEST = 10036;
    public static final int CURLOPT_POSTQUOTE = 10039;
    public static final int CURLOPT_VERBOSE = 41;
    public static final int CURLOPT_HEADER = 42;
    public static final int CURLOPT_NOPROGRESS = 43;
    public static final int CURLOPT_NOBODY = 44;
    public static final int CURLOPT_FAILONERROR = 45;
    public static final int CURLOPT_UPLOAD = 46;
    public static final int CURLOPT_POST = 47;
    public static final int CURLOPT_DIRLISTONLY = 48;
    public static final int CURLOPT_APPEND = 50;
    public static final int CURLOPT_NETRC = 51;
    public static final int CURLOPT_FOLLOWLOCATION = 52;
    public static final int CURLOPT_TRANSFERTEXT = 53;
    @Deprecated
    public static final int CURLOPT_PUT = 54;
    @Deprecated
    public static final int CURLOPT_PROGRESSFUNCTION = 20056;
    public static final int CURLOPT_XFERINFODATA = 10057;
    public static final int CURLOPT_PROGRESSDATA = 10057;
    public static final int CURLOPT_AUTOREFERER = 58;
    public static final int CURLOPT_PROXYPORT = 59;
    public static final int CURLOPT_POSTFIELDSIZE = 60;
    public static final int CURLOPT_HTTPPROXYTUNNEL = 61;
    public static final int CURLOPT_INTERFACE = 10062;
    public static final int CURLOPT_KRBLEVEL = 10063;
    public static final int CURLOPT_SSL_VERIFYPEER = 64;
    public static final int CURLOPT_CAINFO = 10065;
    public static final int CURLOPT_MAXREDIRS = 68;
    public static final int CURLOPT_FILETIME = 69;
    public static final int CURLOPT_TELNETOPTIONS = 10070;
    public static final int CURLOPT_MAXCONNECTS = 71;
    public static final int CURLOPT_FRESH_CONNECT = 74;
    public static final int CURLOPT_FORBID_REUSE = 75;
    @Deprecated
    public static final int CURLOPT_RANDOM_FILE = 10076;
    @Deprecated
    public static final int CURLOPT_EGDSOCKET = 10077;
    public static final int CURLOPT_CONNECTTIMEOUT = 78;
    public static final int CURLOPT_HEADERFUNCTION = 20079;
    public static final int CURLOPT_HTTPGET = 80;
    public static final int CURLOPT_SSL_VERIFYHOST = 81;
    public static final int CURLOPT_COOKIEJAR = 10082;
    public static final int CURLOPT_SSL_CIPHER_LIST = 10083;
    public static final int CURLOPT_HTTP_VERSION = 84;
    public static final int CURLOPT_FTP_USE_EPSV = 85;
    public static final int CURLOPT_SSLCERTTYPE = 10086;
    public static final int CURLOPT_SSLKEY = 10087;
    public static final int CURLOPT_SSLKEYTYPE = 10088;
    public static final int CURLOPT_SSLENGINE = 10089;
    public static final int CURLOPT_SSLENGINE_DEFAULT = 90;
    @Deprecated
    public static final int CURLOPT_DNS_USE_GLOBAL_CACHE = 91;
    public static final int CURLOPT_DNS_CACHE_TIMEOUT = 92;
    public static final int CURLOPT_PREQUOTE = 10093;
    public static final int CURLOPT_DEBUGFUNCTION = 20094;
    public static final int CURLOPT_DEBUGDATA = 10095;
    public static final int CURLOPT_COOKIESESSION = 96;
    public static final int CURLOPT_CAPATH = 10097;
    public static final int CURLOPT_BUFFERSIZE = 98;
    public static final int CURLOPT_NOSIGNAL = 99;
    public static final int CURLOPT_SHARE = 10100;
    public static final int CURLOPT_PROXYTYPE = 101;
    public static final int CURLOPT_ACCEPT_ENCODING = 10102;
    public static final int CURLOPT_PRIVATE = 10103;
    public static final int CURLOPT_HTTP200ALIASES = 10104;
    public static final int CURLOPT_UNRESTRICTED_AUTH = 105;
    public static final int CURLOPT_FTP_USE_EPRT = 106;
    public static final int CURLOPT_HTTPAUTH = 107;
    public static final int CURLOPT_SSL_CTX_FUNCTION = 20108;
    public static final int CURLOPT_SSL_CTX_DATA = 10109;
    public static final int CURLOPT_FTP_CREATE_MISSING_DIRS = 110;
    public static final int CURLOPT_PROXYAUTH = 111;
    public static final int CURLOPT_SERVER_RESPONSE_TIMEOUT = 112;
    public static final int CURLOPT_IPRESOLVE = 113;
    public static final int CURLOPT_MAXFILESIZE = 114;
    public static final int CURLOPT_INFILESIZE_LARGE = 30115;
    public static final int CURLOPT_RESUME_FROM_LARGE = 30116;
    public static final int CURLOPT_MAXFILESIZE_LARGE = 30117;
    public static final int CURLOPT_NETRC_FILE = 10118;
    public static final int CURLOPT_USE_SSL = 119;
    public static final int CURLOPT_POSTFIELDSIZE_LARGE = 30120;
    public static final int CURLOPT_TCP_NODELAY = 121;
    public static final int CURLOPT_FTPSSLAUTH = 129;
    @Deprecated
    public static final int CURLOPT_IOCTLFUNCTION = 20130;
    @Deprecated
    public static final int CURLOPT_IOCTLDATA = 10131;
    public static final int CURLOPT_FTP_ACCOUNT = 10134;
    public static final int CURLOPT_COOKIELIST = 10135;
    public static final int CURLOPT_IGNORE_CONTENT_LENGTH = 136;
    public static final int CURLOPT_FTP_SKIP_PASV_IP = 137;
    public static final int CURLOPT_FTP_FILEMETHOD = 138;
    public static final int CURLOPT_LOCALPORT = 139;
    public static final int CURLOPT_LOCALPORTRANGE = 140;
    public static final int CURLOPT_CONNECT_ONLY = 141;
    @Deprecated
    public static final int CURLOPT_CONV_FROM_NETWORK_FUNCTION = 20242;
    @Deprecated
    public static final int CURLOPT_CONV_TO_NETWORK_FUNCTION = 20243;
    @Deprecated
    public static final int CURLOPT_CONV_FROM_UTF8_FUNCTION = 20244;
    public static final int CURLOPT_MAX_SEND_SPEED_LARGE = 30145;
    public static final int CURLOPT_MAX_RECV_SPEED_LARGE = 30146;
    public static final int CURLOPT_FTP_ALTERNATIVE_TO_USER = 10147;
    public static final int CURLOPT_SOCKOPTFUNCTION = 20148;
    public static final int CURLOPT_SOCKOPTDATA = 10149;
    public static final int CURLOPT_SSL_SESSIONID_CACHE = 150;
    public static final int CURLOPT_SSH_AUTH_TYPES = 151;
    public static final int CURLOPT_SSH_PUBLIC_KEYFILE = 10152;
    public static final int CURLOPT_SSH_PRIVATE_KEYFILE = 10153;
    public static final int CURLOPT_FTP_SSL_CCC = 154;
    public static final int CURLOPT_TIMEOUT_MS = 155;
    public static final int CURLOPT_CONNECTTIMEOUT_MS = 156;
    public static final int CURLOPT_HTTP_TRANSFER_DECODING = 157;
    public static final int CURLOPT_HTTP_CONTENT_DECODING = 158;
    public static final int CURLOPT_NEW_FILE_PERMS = 159;
    public static final int CURLOPT_NEW_DIRECTORY_PERMS = 160;
    public static final int CURLOPT_POSTREDIR = 161;
    public static final int CURLOPT_SSH_HOST_PUBLIC_KEY_MD5 = 10162;
    public static final int CURLOPT_OPENSOCKETFUNCTION = 20163;
    public static final int CURLOPT_OPENSOCKETDATA = 10164;
    public static final int CURLOPT_COPYPOSTFIELDS = 10165;
    public static final int CURLOPT_PROXY_TRANSFER_MODE = 166;
    public static final int CURLOPT_SEEKFUNCTION = 20167;
    public static final int CURLOPT_SEEKDATA = 10168;
    public static final int CURLOPT_CRLFILE = 10169;
    public static final int CURLOPT_ISSUERCERT = 10170;
    public static final int CURLOPT_ADDRESS_SCOPE = 171;
    public static final int CURLOPT_CERTINFO = 172;
    public static final int CURLOPT_USERNAME = 10173;
    public static final int CURLOPT_PASSWORD = 10174;
    public static final int CURLOPT_PROXYUSERNAME = 10175;
    public static final int CURLOPT_PROXYPASSWORD = 10176;
    public static final int CURLOPT_NOPROXY = 10177;
    public static final int CURLOPT_TFTP_BLKSIZE = 178;
    @Deprecated
    public static final int CURLOPT_SOCKS5_GSSAPI_SERVICE = 179;
    public static final int CURLOPT_SOCKS5_GSSAPI_NEC = 180;
    @Deprecated
    public static final int CURLOPT_PROTOCOLS = 181;
    @Deprecated
    public static final int CURLOPT_REDIR_PROTOCOLS = 182;
    public static final int CURLOPT_SSH_KNOWNHOSTS = 10183;
    public static final int CURLOPT_SSH_KEYFUNCTION = 20184;
    public static final int CURLOPT_SSH_KEYDATA = 10185;
    public static final int CURLOPT_MAIL_FROM = 10186;
    public static final int CURLOPT_MAIL_RCPT = 10187;
    public static final int CURLOPT_FTP_USE_PRET = 188;
    public static final int CURLOPT_RTSP_REQUEST = 189;
    public static final int CURLOPT_RTSP_SESSION_ID = 10190;
    public static final int CURLOPT_RTSP_STREAM_URI = 10191;
    public static final int CURLOPT_RTSP_TRANSPORT = 10192;
    public static final int CURLOPT_RTSP_CLIENT_CSEQ = 193;
    public static final int CURLOPT_RTSP_SERVER_CSEQ = 194;
    public static final int CURLOPT_INTERLEAVEDATA = 10195;
    public static final int CURLOPT_INTERLEAVEFUNCTION = 20196;
    public static final int CURLOPT_WILDCARDMATCH = 197;
    public static final int CURLOPT_CHUNK_BGN_FUNCTION = 20198;
    public static final int CURLOPT_CHUNK_END_FUNCTION = 20199;
    public static final int CURLOPT_FNMATCH_FUNCTION = 20200;
    public static final int CURLOPT_CHUNK_DATA = 10201;
    public static final int CURLOPT_FNMATCH_DATA = 10202;
    public static final int CURLOPT_RESOLVE = 10203;
    public static final int CURLOPT_TLSAUTH_USERNAME = 10204;
    public static final int CURLOPT_TLSAUTH_PASSWORD = 10205;
    public static final int CURLOPT_TLSAUTH_TYPE = 10206;
    public static final int CURLOPT_TRANSFER_ENCODING = 207;
    public static final int CURLOPT_CLOSESOCKETFUNCTION = 20208;
    public static final int CURLOPT_CLOSESOCKETDATA = 10209;
    public static final int CURLOPT_GSSAPI_DELEGATION = 210;
    public static final int CURLOPT_DNS_SERVERS = 10211;
    public static final int CURLOPT_ACCEPTTIMEOUT_MS = 212;
    public static final int CURLOPT_TCP_KEEPALIVE = 213;
    public static final int CURLOPT_TCP_KEEPIDLE = 214;
    public static final int CURLOPT_TCP_KEEPINTVL = 215;
    public static final int CURLOPT_SSL_OPTIONS = 216;
    public static final int CURLOPT_MAIL_AUTH = 10217;
    public static final int CURLOPT_SASL_IR = 218;
    public static final int CURLOPT_XFERINFOFUNCTION = 20219;
    public static final int CURLOPT_XOAUTH2_BEARER = 10220;
    public static final int CURLOPT_DNS_INTERFACE = 10221;
    public static final int CURLOPT_DNS_LOCAL_IP4 = 10222;
    public static final int CURLOPT_DNS_LOCAL_IP6 = 10223;
    public static final int CURLOPT_LOGIN_OPTIONS = 10224;
    public static final int CURLOPT_SSL_ENABLE_NPN = 225;
    public static final int CURLOPT_SSL_ENABLE_ALPN = 226;
    public static final int CURLOPT_EXPECT_100_TIMEOUT_MS = 227;
    public static final int CURLOPT_PROXYHEADER = 10228;
    public static final int CURLOPT_HEADEROPT = 229;
    public static final int CURLOPT_PINNEDPUBLICKEY = 10230;
    public static final int CURLOPT_UNIX_SOCKET_PATH = 10231;
    public static final int CURLOPT_SSL_VERIFYSTATUS = 232;
    public static final int CURLOPT_SSL_FALSESTART = 233;
    public static final int CURLOPT_PATH_AS_IS = 234;
    public static final int CURLOPT_PROXY_SERVICE_NAME = 10235;
    public static final int CURLOPT_SERVICE_NAME = 10236;
    public static final int CURLOPT_PIPEWAIT = 237;
    public static final int CURLOPT_DEFAULT_PROTOCOL = 10238;
    public static final int CURLOPT_STREAM_WEIGHT = 239;
    public static final int CURLOPT_STREAM_DEPENDS = 10240;
    public static final int CURLOPT_STREAM_DEPENDS_E = 10241;
    public static final int CURLOPT_TFTP_NO_OPTIONS = 242;
    public static final int CURLOPT_CONNECT_TO = 10243;
    public static final int CURLOPT_TCP_FASTOPEN = 244;
    public static final int CURLOPT_KEEP_SENDING_ON_ERROR = 245;
    public static final int CURLOPT_PROXY_CAINFO = 10246;
    public static final int CURLOPT_PROXY_CAPATH = 10247;
    public static final int CURLOPT_PROXY_SSL_VERIFYPEER = 248;
    public static final int CURLOPT_PROXY_SSL_VERIFYHOST = 249;
    public static final int CURLOPT_PROXY_SSLVERSION = 250;
    public static final int CURLOPT_PROXY_TLSAUTH_USERNAME = 10251;
    public static final int CURLOPT_PROXY_TLSAUTH_PASSWORD = 10252;
    public static final int CURLOPT_PROXY_TLSAUTH_TYPE = 10253;
    public static final int CURLOPT_PROXY_SSLCERT = 10254;
    public static final int CURLOPT_PROXY_SSLCERTTYPE = 10255;
    public static final int CURLOPT_PROXY_SSLKEY = 10256;
    public static final int CURLOPT_PROXY_SSLKEYTYPE = 10257;
    public static final int CURLOPT_PROXY_KEYPASSWD = 10258;
    public static final int CURLOPT_PROXY_SSL_CIPHER_LIST = 10259;
    public static final int CURLOPT_PROXY_CRLFILE = 10260;
    public static final int CURLOPT_PROXY_SSL_OPTIONS = 261;
    public static final int CURLOPT_PRE_PROXY = 10262;
    public static final int CURLOPT_PROXY_PINNEDPUBLICKEY = 10263;
    public static final int CURLOPT_ABSTRACT_UNIX_SOCKET = 10264;
    public static final int CURLOPT_SUPPRESS_CONNECT_HEADERS = 265;
    public static final int CURLOPT_REQUEST_TARGET = 10266;
    public static final int CURLOPT_SOCKS5_AUTH = 267;
    public static final int CURLOPT_SSH_COMPRESSION = 268;
    public static final int CURLOPT_MIMEPOST = 10269;
    public static final int CURLOPT_TIMEVALUE_LARGE = 30270;
    public static final int CURLOPT_HAPPY_EYEBALLS_TIMEOUT_MS = 271;
    public static final int CURLOPT_RESOLVER_START_FUNCTION = 20272;
    public static final int CURLOPT_RESOLVER_START_DATA = 10273;
    public static final int CURLOPT_HAPROXYPROTOCOL = 274;
    public static final int CURLOPT_DNS_SHUFFLE_ADDRESSES = 275;
    public static final int CURLOPT_TLS13_CIPHERS = 10276;
    public static final int CURLOPT_PROXY_TLS13_CIPHERS = 10277;
    public static final int CURLOPT_DISALLOW_USERNAME_IN_URL = 278;
    public static final int CURLOPT_DOH_URL = 10279;
    public static final int CURLOPT_UPLOAD_BUFFERSIZE = 280;
    public static final int CURLOPT_UPKEEP_INTERVAL_MS = 281;
    public static final int CURLOPT_CURLU = 10282;
    public static final int CURLOPT_TRAILERFUNCTION = 20283;
    public static final int CURLOPT_TRAILERDATA = 10284;
    public static final int CURLOPT_HTTP09_ALLOWED = 285;
    public static final int CURLOPT_ALTSVC_CTRL = 286;
    public static final int CURLOPT_ALTSVC = 10287;
    public static final int CURLOPT_MAXAGE_CONN = 288;
    public static final int CURLOPT_SASL_AUTHZID = 10289;
    public static final int CURLOPT_MAIL_RCPT_ALLOWFAILS = 290;
    public static final int CURLOPT_SSLCERT_BLOB = 40291;
    public static final int CURLOPT_SSLKEY_BLOB = 40292;
    public static final int CURLOPT_PROXY_SSLCERT_BLOB = 40293;
    public static final int CURLOPT_PROXY_SSLKEY_BLOB = 40294;
    public static final int CURLOPT_ISSUERCERT_BLOB = 40295;
    public static final int CURLOPT_PROXY_ISSUERCERT = 10296;
    public static final int CURLOPT_PROXY_ISSUERCERT_BLOB = 40297;
    public static final int CURLOPT_SSL_EC_CURVES = 10298;
    public static final int CURLOPT_HSTS_CTRL = 299;
    public static final int CURLOPT_HSTS = 10300;
    public static final int CURLOPT_HSTSREADFUNCTION = 20301;
    public static final int CURLOPT_HSTSREADDATA = 10302;
    public static final int CURLOPT_HSTSWRITEFUNCTION = 20303;
    public static final int CURLOPT_HSTSWRITEDATA = 10304;
    public static final int CURLOPT_AWS_SIGV4 = 10305;
    public static final int CURLOPT_DOH_SSL_VERIFYPEER = 306;
    public static final int CURLOPT_DOH_SSL_VERIFYHOST = 307;
    public static final int CURLOPT_DOH_SSL_VERIFYSTATUS = 308;
    public static final int CURLOPT_CAINFO_BLOB = 40309;
    public static final int CURLOPT_PROXY_CAINFO_BLOB = 40310;
    public static final int CURLOPT_SSH_HOST_PUBLIC_KEY_SHA256 = 10311;
    public static final int CURLOPT_PREREQFUNCTION = 20312;
    public static final int CURLOPT_PREREQDATA = 10313;
    public static final int CURLOPT_MAXLIFETIME_CONN = 314;
    public static final int CURLOPT_MIME_OPTIONS = 315;
    public static final int CURLOPT_SSH_HOSTKEYFUNCTION = 20316;
    public static final int CURLOPT_SSH_HOSTKEYDATA = 10317;
    public static final int CURLOPT_PROTOCOLS_STR = 10318;
    public static final int CURLOPT_REDIR_PROTOCOLS_STR = 10319;
    public static final int CURLOPT_WS_OPTIONS = 320;
    public static final int CURLOPT_CA_CACHE_TIMEOUT = 321;
    public static final int CURLOPT_QUICK_EXIT = 322;
    public static final int CURLOPT_HAPROXY_CLIENT_IP = 10323;
    public static final int CURLINFO_STRING = 0x100000;
    public static final int CURLINFO_LONG = 0x200000;
    public static final int CURLINFO_DOUBLE = 0x300000;
    public static final int CURLINFO_SLIST = 0x400000;
    public static final int CURLINFO_PTR = 0x400000;
    public static final int CURLINFO_SOCKET = 0x500000;
    public static final int CURLINFO_OFF_T = 0x600000;
    public static final int CURLINFO_MASK = 1048575;
    public static final int CURLINFO_TYPEMASK = 0xF00000;
    public static final int CURLINFO_EFFECTIVE_URL = 0x100001;
    public static final int CURLINFO_RESPONSE_CODE = 0x200002;
    public static final int CURLINFO_TOTAL_TIME = 0x300003;
    public static final int CURLINFO_NAMELOOKUP_TIME = 0x300004;
    public static final int CURLINFO_CONNECT_TIME = 0x300005;
    public static final int CURLINFO_PRETRANSFER_TIME = 0x300006;
    @Deprecated
    public static final int CURLINFO_SIZE_UPLOAD = 0x300007;
    public static final int CURLINFO_SIZE_UPLOAD_T = 0x600007;
    @Deprecated
    public static final int CURLINFO_SIZE_DOWNLOAD = 0x300008;
    public static final int CURLINFO_SIZE_DOWNLOAD_T = 0x600008;
    @Deprecated
    public static final int CURLINFO_SPEED_DOWNLOAD = 0x300009;
    public static final int CURLINFO_SPEED_DOWNLOAD_T = 0x600009;
    @Deprecated
    public static final int CURLINFO_SPEED_UPLOAD = 0x30000A;
    public static final int CURLINFO_SPEED_UPLOAD_T = 0x60000A;
    public static final int CURLINFO_HEADER_SIZE = 0x20000B;
    public static final int CURLINFO_REQUEST_SIZE = 0x20000C;
    public static final int CURLINFO_SSL_VERIFYRESULT = 0x20000D;
    public static final int CURLINFO_FILETIME = 0x20000E;
    public static final int CURLINFO_FILETIME_T = 0x60000E;
    @Deprecated
    public static final int CURLINFO_CONTENT_LENGTH_DOWNLOAD = 0x30000F;
    public static final int CURLINFO_CONTENT_LENGTH_DOWNLOAD_T = 0x60000F;
    @Deprecated
    public static final int CURLINFO_CONTENT_LENGTH_UPLOAD = 0x300010;
    public static final int CURLINFO_CONTENT_LENGTH_UPLOAD_T = 0x600010;
    public static final int CURLINFO_STARTTRANSFER_TIME = 0x300011;
    public static final int CURLINFO_CONTENT_TYPE = 0x100012;
    public static final int CURLINFO_REDIRECT_TIME = 0x300013;
    public static final int CURLINFO_REDIRECT_COUNT = 2097172;
    public static final int CURLINFO_PRIVATE = 0x100015;
    public static final int CURLINFO_HTTP_CONNECTCODE = 2097174;
    public static final int CURLINFO_HTTPAUTH_AVAIL = 2097175;
    public static final int CURLINFO_PROXYAUTH_AVAIL = 2097176;
    public static final int CURLINFO_OS_ERRNO = 2097177;
    public static final int CURLINFO_NUM_CONNECTS = 2097178;
    public static final int CURLINFO_SSL_ENGINES = 4194331;
    public static final int CURLINFO_COOKIELIST = 4194332;
    @Deprecated
    public static final int CURLINFO_LASTSOCKET = 2097181;
    public static final int CURLINFO_FTP_ENTRY_PATH = 0x10001E;
    public static final int CURLINFO_REDIRECT_URL = 0x10001F;
    public static final int CURLINFO_PRIMARY_IP = 0x100020;
    public static final int CURLINFO_APPCONNECT_TIME = 3145761;
    public static final int CURLINFO_CERTINFO = 0x400022;
    public static final int CURLINFO_CONDITION_UNMET = 0x200023;
    public static final int CURLINFO_RTSP_SESSION_ID = 1048612;
    public static final int CURLINFO_RTSP_CLIENT_CSEQ = 0x200025;
    public static final int CURLINFO_RTSP_SERVER_CSEQ = 0x200026;
    public static final int CURLINFO_RTSP_CSEQ_RECV = 0x200027;
    public static final int CURLINFO_PRIMARY_PORT = 0x200028;
    public static final int CURLINFO_LOCAL_IP = 1048617;
    public static final int CURLINFO_LOCAL_PORT = 0x20002A;
    @Deprecated
    public static final int CURLINFO_TLS_SESSION = 4194347;
    public static final int CURLINFO_ACTIVESOCKET = 5242924;
    public static final int CURLINFO_TLS_SSL_PTR = 4194349;
    public static final int CURLINFO_HTTP_VERSION = 0x20002E;
    public static final int CURLINFO_PROXY_SSL_VERIFYRESULT = 0x20002F;
    @Deprecated
    public static final int CURLINFO_PROTOCOL = 0x200030;
    public static final int CURLINFO_SCHEME = 0x100031;
    public static final int CURLINFO_TOTAL_TIME_T = 6291506;
    public static final int CURLINFO_NAMELOOKUP_TIME_T = 0x600033;
    public static final int CURLINFO_CONNECT_TIME_T = 6291508;
    public static final int CURLINFO_PRETRANSFER_TIME_T = 6291509;
    public static final int CURLINFO_STARTTRANSFER_TIME_T = 0x600036;
    public static final int CURLINFO_REDIRECT_TIME_T = 6291511;
    public static final int CURLINFO_APPCONNECT_TIME_T = 6291512;
    public static final int CURLINFO_RETRY_AFTER = 6291513;
    public static final int CURLINFO_EFFECTIVE_METHOD = 1048634;
    public static final int CURLINFO_PROXY_ERROR = 2097211;
    public static final int CURLINFO_REFERER = 1048636;
    public static final int CURLINFO_CAINFO = 1048637;
    public static final int CURLINFO_CAPATH = 1048638;
    public static final int CURLINFO_XFER_ID = 6291519;
    public static final int CURLINFO_CONN_ID = 0x600040;
    public static final int CURLE_OK = 0;
    public static final int CURLE_UNSUPPORTED_PROTOCOL = 1;
    public static final int CURLE_FAILED_INIT = 2;
    public static final int CURLE_URL_MALFORMAT = 3;
    public static final int CURLE_NOT_BUILT_IN = 4;
    public static final int CURLE_COULDNT_RESOLVE_PROXY = 5;
    public static final int CURLE_COULDNT_RESOLVE_HOST = 6;
    public static final int CURLE_COULDNT_CONNECT = 7;
    public static final int CURLE_WEIRD_SERVER_REPLY = 8;
    public static final int CURLE_REMOTE_ACCESS_DENIED = 9;
    public static final int CURLE_FTP_ACCEPT_FAILED = 10;
    public static final int CURLE_FTP_WEIRD_PASS_REPLY = 11;
    public static final int CURLE_FTP_ACCEPT_TIMEOUT = 12;
    public static final int CURLE_FTP_WEIRD_PASV_REPLY = 13;
    public static final int CURLE_FTP_WEIRD_227_FORMAT = 14;
    public static final int CURLE_FTP_CANT_GET_HOST = 15;
    public static final int CURLE_HTTP2 = 16;
    public static final int CURLE_FTP_COULDNT_SET_TYPE = 17;
    public static final int CURLE_PARTIAL_FILE = 18;
    public static final int CURLE_FTP_COULDNT_RETR_FILE = 19;
    public static final int CURLE_OBSOLETE20 = 20;
    public static final int CURLE_QUOTE_ERROR = 21;
    public static final int CURLE_HTTP_RETURNED_ERROR = 22;
    public static final int CURLE_WRITE_ERROR = 23;
    public static final int CURLE_OBSOLETE24 = 24;
    public static final int CURLE_UPLOAD_FAILED = 25;
    public static final int CURLE_READ_ERROR = 26;
    public static final int CURLE_OUT_OF_MEMORY = 27;
    public static final int CURLE_OPERATION_TIMEDOUT = 28;
    public static final int CURLE_OBSOLETE29 = 29;
    public static final int CURLE_FTP_PORT_FAILED = 30;
    public static final int CURLE_FTP_COULDNT_USE_REST = 31;
    public static final int CURLE_OBSOLETE32 = 32;
    public static final int CURLE_RANGE_ERROR = 33;
    public static final int CURLE_HTTP_POST_ERROR = 34;
    public static final int CURLE_SSL_CONNECT_ERROR = 35;
    public static final int CURLE_BAD_DOWNLOAD_RESUME = 36;
    public static final int CURLE_FILE_COULDNT_READ_FILE = 37;
    public static final int CURLE_LDAP_CANNOT_BIND = 38;
    public static final int CURLE_LDAP_SEARCH_FAILED = 39;
    public static final int CURLE_OBSOLETE40 = 40;
    public static final int CURLE_FUNCTION_NOT_FOUND = 41;
    public static final int CURLE_ABORTED_BY_CALLBACK = 42;
    public static final int CURLE_BAD_FUNCTION_ARGUMENT = 43;
    public static final int CURLE_OBSOLETE44 = 44;
    public static final int CURLE_INTERFACE_FAILED = 45;
    public static final int CURLE_OBSOLETE46 = 46;
    public static final int CURLE_TOO_MANY_REDIRECTS = 47;
    public static final int CURLE_UNKNOWN_OPTION = 48;
    public static final int CURLE_SETOPT_OPTION_SYNTAX = 49;
    public static final int CURLE_OBSOLETE50 = 50;
    public static final int CURLE_OBSOLETE51 = 51;
    public static final int CURLE_GOT_NOTHING = 52;
    public static final int CURLE_SSL_ENGINE_NOTFOUND = 53;
    public static final int CURLE_SSL_ENGINE_SETFAILED = 54;
    public static final int CURLE_SEND_ERROR = 55;
    public static final int CURLE_RECV_ERROR = 56;
    public static final int CURLE_OBSOLETE57 = 57;
    public static final int CURLE_SSL_CERTPROBLEM = 58;
    public static final int CURLE_SSL_CIPHER = 59;
    public static final int CURLE_PEER_FAILED_VERIFICATION = 60;
    public static final int CURLE_BAD_CONTENT_ENCODING = 61;
    public static final int CURLE_OBSOLETE62 = 62;
    public static final int CURLE_FILESIZE_EXCEEDED = 63;
    public static final int CURLE_USE_SSL_FAILED = 64;
    public static final int CURLE_SEND_FAIL_REWIND = 65;
    public static final int CURLE_SSL_ENGINE_INITFAILED = 66;
    public static final int CURLE_LOGIN_DENIED = 67;
    public static final int CURLE_TFTP_NOTFOUND = 68;
    public static final int CURLE_TFTP_PERM = 69;
    public static final int CURLE_REMOTE_DISK_FULL = 70;
    public static final int CURLE_TFTP_ILLEGAL = 71;
    public static final int CURLE_TFTP_UNKNOWNID = 72;
    public static final int CURLE_REMOTE_FILE_EXISTS = 73;
    public static final int CURLE_TFTP_NOSUCHUSER = 74;
    public static final int CURLE_CONV_FAILED = 75;
    public static final int CURLE_OBSOLETE76 = 76;
    public static final int CURLE_SSL_CACERT_BADFILE = 77;
    public static final int CURLE_REMOTE_FILE_NOT_FOUND = 78;
    public static final int CURLE_SSH = 79;
    public static final int CURLE_SSL_SHUTDOWN_FAILED = 80;
    public static final int CURLE_AGAIN = 81;
    public static final int CURLE_SSL_CRL_BADFILE = 82;
    public static final int CURLE_SSL_ISSUER_ERROR = 83;
    public static final int CURLE_FTP_PRET_FAILED = 84;
    public static final int CURLE_RTSP_CSEQ_ERROR = 85;
    public static final int CURLE_RTSP_SESSION_ERROR = 86;
    public static final int CURLE_FTP_BAD_FILE_LIST = 87;
    public static final int CURLE_CHUNK_FAILED = 88;
    public static final int CURLE_NO_CONNECTION_AVAILABLE = 89;
    public static final int CURLE_SSL_PINNEDPUBKEYNOTMATCH = 90;
    public static final int CURLE_SSL_INVALIDCERTSTATUS = 91;
    public static final int CURLE_HTTP2_STREAM = 92;
    public static final int CURLE_RECURSIVE_API_CALL = 93;
    public static final int CURLE_AUTH_ERROR = 94;
    public static final int CURLE_HTTP3 = 95;
    public static final int CURLE_QUIC_CONNECT_ERROR = 96;
    public static final int CURLE_PROXY = 97;
    public static final int CURLE_SSL_CLIENTCERT = 98;
    public static final int CURLVERSION_FIRST = 0;
    public static final int CURLVERSION_SECOND = 1;
    public static final int CURLVERSION_THIRD = 2;
    public static final int CURLVERSION_FOURTH = 3;
    public static final int CURLVERSION_FIFTH = 4;
    public static final int CURLVERSION_SIXTH = 5;
    public static final int CURLVERSION_SEVENTH = 6;
    public static final int CURLVERSION_EIGHTH = 7;
    public static final int CURLVERSION_NINTH = 8;
    public static final int CURLVERSION_TENTH = 9;
    public static final int CURLVERSION_ELEVENTH = 11;
    public static final int CURLVERSION_NOW = 11;
    public static final int CURL_VERSION_IPV6 = 1;
    @Deprecated
    public static final int CURL_VERSION_KERBEROS4 = 2;
    public static final int CURL_VERSION_SSL = 4;
    public static final int CURL_VERSION_LIBZ = 8;
    public static final int CURL_VERSION_NTLM = 16;
    @Deprecated
    public static final int CURL_VERSION_GSSNEGOTIATE = 32;
    public static final int CURL_VERSION_DEBUG = 64;
    public static final int CURL_VERSION_ASYNCHDNS = 128;
    public static final int CURL_VERSION_SPNEGO = 256;
    public static final int CURL_VERSION_LARGEFILE = 512;
    public static final int CURL_VERSION_IDN = 1024;
    public static final int CURL_VERSION_SSPI = 2048;
    public static final int CURL_VERSION_CONV = 4096;
    public static final int CURL_VERSION_CURLDEBUG = 8192;
    public static final int CURL_VERSION_TLSAUTH_SRP = 16384;
    public static final int CURL_VERSION_NTLM_WB = 32768;
    public static final int CURL_VERSION_HTTP2 = 65536;
    public static final int CURL_VERSION_GSSAPI = 131072;
    public static final int CURL_VERSION_KERBEROS5 = 262144;
    public static final int CURL_VERSION_UNIX_SOCKETS = 524288;
    public static final int CURL_VERSION_PSL = 0x100000;
    public static final int CURL_VERSION_HTTPS_PROXY = 0x200000;
    public static final int CURL_VERSION_MULTI_SSL = 0x400000;
    public static final int CURL_VERSION_BROTLI = 0x800000;
    public static final int CURL_VERSION_ALTSVC = 0x1000000;
    public static final int CURL_VERSION_HTTP3 = 0x2000000;
    public static final int CURL_VERSION_ZSTD = 0x4000000;
    public static final int CURL_VERSION_UNICODE = 0x8000000;
    public static final int CURL_VERSION_HSTS = 0x10000000;
    public static final int CURL_VERSION_GSASL = 0x20000000;
    public static final int CURL_SEEKFUNC_OK = 0;
    public static final int CURL_SEEKFUNC_FAIL = 1;
    public static final int CURL_SEEKFUNC_CANTSEEK = 2;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    public static final long CURL_READFUNC_ABORT = 0x10000000L;
    public static final long CURL_READFUNC_PAUSE = 0x10000001L;
    public static final long CURL_PROGRESSFUNC_CONTINUE = 0x10000001L;
    public static final long CURL_WRITEFUNC_PAUSE = 0x10000001L;
    public static final long CURL_WRITEFUNC_ERROR = 0xFFFFFFFFL;
    public static final int CURLM_CALL_MULTI_PERFORM = -1;
    public static final int CURLM_OK = 0;
    public static final int CURLM_BAD_HANDLE = 1;
    public static final int CURLM_BAD_EASY_HANDLE = 2;
    public static final int CURLM_OUT_OF_MEMORY = 3;
    public static final int CURLM_INTERNAL_ERROR = 4;
    public static final int CURLM_BAD_SOCKET = 5;
    public static final int CURLM_UNKNOWN_OPTION = 6;
    public static final int CURLM_ADDED_ALREADY = 7;
    public static final int CURLM_RECURSIVE_API_CALL = 8;
    public static final int CURLM_WAKEUP_FAILURE = 9;
    public static final int CURLM_BAD_FUNCTION_ARGUMENT = 10;
    public static final int CURLM_ABORTED_BY_CALLBACK = 11;
    public static final int CURLM_UNRECOVERABLE_POLL = 12;
    public static final int CURLMSG_DONE = 1;
    public static final int CURLMOPT_SOCKETFUNCTION = 20001;
    public static final int CURLMOPT_SOCKETDATA = 10002;
    public static final int CURLMOPT_PIPELINING = 2;
    public static final int CURLMOPT_TIMERFUNCTION = 20004;
    public static final int CURLMOPT_TIMERDATA = 10005;
    public static final int CURLMOPT_MAXCONNECTS = 6;
    public static final int CURLMOPT_MAX_HOST_CONNECTIONS = 7;
    public static final int CURLMOPT_MAX_PIPELINE_LENGTH = 8;
    public static final int CURLMOPT_CONTENT_LENGTH_PENALTY_SIZE = 30009;
    public static final int CURLMOPT_CHUNK_LENGTH_PENALTY_SIZE = 30010;
    public static final int CURLMOPT_PIPELINING_SITE_BL = 10011;
    public static final int CURLMOPT_PIPELINING_SERVER_BL = 10012;
    public static final int CURLMOPT_MAX_TOTAL_CONNECTIONS = 13;
    public static final int CURLMOPT_PUSHFUNCTION = 20014;
    public static final int CURLMOPT_PUSHDATA = 10015;
    public static final int CURLMOPT_MAX_CONCURRENT_STREAMS = 16;
    public static final int CURLPAUSE_RECV = 1;
    public static final int CURLPAUSE_RECV_CONT = 0;
    public static final int CURLPAUSE_SEND = 4;
    public static final int CURLPAUSE_SEND_CONT = 0;
    public static final int CURLPAUSE_ALL = 5;
    public static final int CURLPAUSE_CONT = 0;

    private CURL() {
    }

    public static void setLibCurlName(String name) {
        if (CURL != null) {
            throw new IllegalStateException("CURL already initialized.");
        }
        LIB_CURL_OVERRIDE = name;
    }

    public static Library getLbCURL() {
        if (CURL == null) {
            String lib = System.getProperty("net.covers1624.curl4j.libcurl.name", "curl");
            if (LIB_CURL_OVERRIDE != null) {
                lib = LIB_CURL_OVERRIDE;
            }
            CURL = LibraryLoader.loadLibrary(lib);
        }
        return CURL;
    }

    public static String curl_version() {
        return Functions.ncurl_version(Functions.curl_version);
    }

    @NativeType(value="curl_version_info_data *")
    public static curl_version_info_data curl_version_info() {
        return new curl_version_info_data(Functions.ncurl_version_info(Functions.curl_version_info));
    }

    public static void curl_global_init(long flags) {
        Functions.ncurl_global_init(Functions.curl_global_init, flags);
    }

    public static void curl_global_cleanup() {
        Functions.ncurl_global_cleanup(Functions.curl_global_cleanup);
    }

    @NativeType(value="CURL *")
    public static long curl_easy_init() {
        return Functions.ncurl_easy_init(Functions.curl_easy_init);
    }

    public static void curl_easy_reset(@NativeType(value="CURL *") long curl) {
        Functions.ncurl_easy_reset(Functions.curl_easy_reset, curl);
    }

    @NativeType(value="CURLcode")
    public static int curl_easy_setopt(@NativeType(value="CURL *") long curl, @NativeType(value="CURLoption") int opt, long value) {
        return Functions.ncurl_easy_setopt(Functions.curl_easy_setopt, curl, opt, value);
    }

    @NativeType(value="CURLcode")
    public static int curl_easy_setopt(@NativeType(value="CURL *") long curl, @NativeType(value="CURLoption") int opt, boolean value) {
        return net.covers1624.curl4j.CURL.curl_easy_setopt(curl, opt, value ? 1L : 0L);
    }

    @NativeType(value="CURLcode")
    public static int curl_easy_setopt(@NativeType(value="CURL *") long curl, @NativeType(value="CURLoption") int opt, String value) {
        return Functions.ncurl_easy_setopt(Functions.curl_easy_setopt, curl, opt, value);
    }

    @NativeType(value="CURLcode")
    public static int curl_easy_setopt(@NativeType(value="CURL *") long curl, @NativeType(value="CURLoption") int opt, CurlCallback func) {
        return Functions.ncurl_easy_setopt(Functions.curl_easy_setopt, curl, opt, func.getFunctionAddress());
    }

    @NativeType(value="CURLcode")
    public static int curl_easy_setopt(@NativeType(value="CURL *") long curl, @NativeType(value="CURLoption") int opt, @Nullable curl_slist slist) {
        return Functions.ncurl_easy_setopt(Functions.curl_easy_setopt, curl, opt, slist != null ? slist.address : 0L);
    }

    @NativeType(value="CURLcode")
    public static int curl_easy_setopt(@NativeType(value="CURL *") long curl, @NativeType(value="CURLoption") int opt, @Nullable curl_blob blob) {
        return Functions.ncurl_easy_setopt(Functions.curl_easy_setopt, curl, opt, blob != null ? blob.address : 0L);
    }

    @NativeType(value="CURLcode")
    public static int curl_easy_getinfo(@NativeType(value="CURL *") long curl, @NativeType(value="CURLINFO") int opt, Pointer value) {
        return Functions.ncurl_easy_getinfo(Functions.curl_easy_getinfo, curl, opt, value.address);
    }

    @Nullable
    public static String curl_easy_getinfo_String(@NativeType(value="CURL *") long curl, @NativeType(value="CURLINFO") int opt) {
        if ((opt & 0xF00000) != 0x100000) {
            throw new IllegalArgumentException("Provided 'opt' does not return a string type.");
        }
        try (Memory.Stack stack = Memory.pushStack();){
            Pointer pointer = stack.mallocPointer();
            int ret = net.covers1624.curl4j.CURL.curl_easy_getinfo(curl, opt, pointer);
            if (ret != 0) {
                throw new IllegalStateException("CURL error querying info: " + net.covers1624.curl4j.CURL.curl_easy_strerror(ret));
            }
            Pointer strPtr = pointer.readPointer();
            String string = strPtr != null ? strPtr.readUtf8Safe() : null;
            return string;
        }
    }

    public static long curl_easy_getinfo_long(@NativeType(value="CURL *") long curl, @NativeType(value="CURLINFO") int opt) {
        boolean isOffT;
        boolean isLong = (opt & 0xF00000) == 0x200000;
        boolean bl = isOffT = (opt & 0xF00000) == 0x600000;
        if (!isLong && !isOffT) {
            throw new IllegalArgumentException("Provided 'opt' does not return a long type.");
        }
        try (Memory.Stack stack = Memory.pushStack();){
            Pointer pointer = stack.mallocPointer();
            int ret = net.covers1624.curl4j.CURL.curl_easy_getinfo(curl, opt, pointer);
            if (ret != 0) {
                throw new IllegalStateException("CURL error querying info: " + net.covers1624.curl4j.CURL.curl_easy_strerror(ret));
            }
            long l = isLong ? pointer.readCLong() : pointer.readSizeT();
            return l;
        }
    }

    @NativeType(value="CURLcode")
    public static int curl_easy_perform(@NativeType(value="CURL *") long curl) {
        return Functions.ncurl_easy_perform(Functions.curl_easy_perform, curl);
    }

    @NativeType(value="CURLcode")
    public static int curl_easy_pause(@NativeType(value="CURL *") long curl, int bitmask) {
        return Functions.ncurl_easy_pause(Functions.curl_easy_pause, curl, bitmask);
    }

    public static String curl_easy_strerror(@NativeType(value="CURLcode") int errornum) {
        return Functions.ncurl_easy_strerror(Functions.curl_easy_strerror, errornum);
    }

    public static void curl_easy_cleanup(@NativeType(value="CURL *") long curl) {
        Functions.ncurl_easy_cleanup(Functions.curl_easy_cleanup, curl);
    }

    public static boolean isCurlImpersonateSupported() {
        return Functions.curl_easy_impersonate != 0L;
    }

    public static int curl_easy_impersonate(@NativeType(value="CURL *") long curl, String target, boolean default_headers) {
        return Functions.ncurl_easy_impersonate(Functions.curl_easy_impersonate, curl, target, default_headers);
    }

    @Nullable
    public static curl_slist curl_slist_append(@Nullable curl_slist list, String data) {
        long listPtr = list != null ? list.address : 0L;
        long ptr = Functions.ncurl_slist_append(Functions.curl_slist_append, listPtr, data);
        if (ptr == listPtr) {
            return list;
        }
        if (ptr == 0L) {
            return null;
        }
        return new curl_slist(ptr);
    }

    public static void curl_slist_free_all(@Nullable curl_slist list) {
        if (list == null) {
            return;
        }
        Functions.ncurl_slist_free_all(Functions.curl_slist_free_all, list.address);
    }

    @NativeType(value="curl_mime *")
    public static long curl_mime_init(@NativeType(value="CURL *") long curl) {
        return Functions.ncurl_mime_init(Functions.curl_mime_init, curl);
    }

    public static void curl_mime_free(@NativeType(value="curl_mime *") long mime) {
        Functions.ncurl_mime_free(Functions.curl_mime_free, mime);
    }

    @NativeType(value="curl_mimepart *")
    public static long curl_mime_addpart(@NativeType(value="curl_mime *") long mime) {
        return Functions.ncurl_mime_addpart(Functions.curl_mime_addpart, mime);
    }

    @NativeType(value="CURLcode")
    public static int curl_mime_name(@NativeType(value="curl_mime *") long mime, @Nullable String name) {
        return Functions.ncurl_mime_name(Functions.curl_mime_name, mime, name);
    }

    @NativeType(value="CURLcode")
    public static int curl_mime_filename(@NativeType(value="curl_mime *") long mime, @Nullable String filename) {
        return Functions.ncurl_mime_filename(Functions.curl_mime_filename, mime, filename);
    }

    @NativeType(value="CURLcode")
    public static int curl_mime_type(@NativeType(value="curl_mime *") long mime, String mimetype) {
        return Functions.ncurl_mime_type(Functions.curl_mime_type, mime, mimetype);
    }

    @NativeType(value="CURLcode")
    public static int curl_mime_data(@NativeType(value="curl_mime *") long mime, byte[] data) {
        return Functions.ncurl_mime_data(Functions.curl_mime_data, mime, data);
    }

    @Deprecated
    @NativeType(value="CURLcode")
    public static int curl_mime_data_cb(@NativeType(value="curl_mime *") long mime, long datasize, CurlReadCallback readfunc) {
        return Functions.ncurl_mime_data_cb(Functions.curl_mime_data_cb, mime, datasize, readfunc.getFunctionAddress(), 0L, 0L, 0L);
    }

    @NativeType(value="CURLcode")
    public static int curl_mime_data_cb(@NativeType(value="curl_mime *") long mime, long datasize, CurlReadCallback readfunc, CurlSeekCallback seekfunc) {
        return Functions.ncurl_mime_data_cb(Functions.curl_mime_data_cb, mime, datasize, readfunc.getFunctionAddress(), seekfunc.getFunctionAddress(), 0L, 0L);
    }

    @NativeType(value="CURLM *")
    public static long curl_multi_init() {
        return Functions.ncurl_multi_init(Functions.curl_multi_init);
    }

    public static void curl_multi_cleanup(@NativeType(value="CURLM *") long multi) {
        Functions.ncurl_multi_cleanup(Functions.curl_multi_cleanup, multi);
    }

    @NativeType(value="CURLMcode")
    public static int curl_multi_add_handle(@NativeType(value="CURLM *") long multi, @NativeType(value="CURL *") long curl) {
        return Functions.ncurl_multi_add_handle(Functions.curl_multi_add_handle, multi, curl);
    }

    @NativeType(value="CURLMcode")
    public static int curl_multi_remove_handle(@NativeType(value="CURLM *") long multi, @NativeType(value="CURL *") long curl) {
        return Functions.ncurl_multi_remove_handle(Functions.curl_multi_remove_handle, multi, curl);
    }

    @NativeType(value="CURLMcode")
    public static int curl_multi_perform(long multi, Pointer runningHandles) {
        return Functions.ncurl_multi_perform(Functions.curl_multi_perform, multi, runningHandles.address);
    }

    @NativeType(value="CURLMcode")
    public static int curl_multi_wait(long multi, int timeout, Pointer numHandles) {
        return Functions.ncurl_multi_wait(Functions.curl_multi_wait, multi, 0L, 0, timeout, numHandles.address);
    }

    @Nullable
    public static CURLMsg curl_multi_info_read(long multi, Pointer msgsInQueue) {
        long ret = Functions.ncurl_multi_info_read(Functions.curl_multi_info_read, multi, msgsInQueue.address);
        if (ret == 0L) {
            return null;
        }
        return new CURLMsg(ret);
    }

    @NativeType(value="CURLMcode")
    public static int curl_multi_timeout(long multi, Pointer millisecondsPtr) {
        return Functions.ncurl_multi_timeout(Functions.curl_multi_timeout, multi, millisecondsPtr.address);
    }

    @NativeType(value="CURLMcode")
    public static int curl_multi_setopt(long multi, int opt, long value) {
        return Functions.ncurl_multi_setopt(Functions.curl_multi_setopt, multi, opt, value);
    }

    @NativeType(value="CURLMcode")
    public static int curl_multi_setopt(long multi, int opt, CurlCallback callback) {
        return Functions.ncurl_multi_setopt(Functions.curl_multi_setopt, multi, opt, callback.getFunctionAddress());
    }

    public static String curl_multi_strerror(@NativeType(value="CURLMcode") int code) {
        return Functions.ncurl_multi_strerror(Functions.curl_multi_strerror, code);
    }

    public static final class Functions {
        private static final Library CURL = net.covers1624.curl4j.CURL.getLbCURL();
        public static final long curl_version = CURL.getFunction("curl_version");
        public static final long curl_version_info = CURL.getFunction("curl_version_info");
        public static final long curl_global_init = CURL.getFunction("curl_global_init");
        public static final long curl_global_cleanup = CURL.getFunction("curl_global_cleanup");
        public static final long curl_easy_init = CURL.getFunction("curl_easy_init");
        public static final long curl_easy_reset = CURL.getFunction("curl_easy_reset");
        public static final long curl_easy_perform = CURL.getFunction("curl_easy_perform");
        public static final long curl_easy_pause = CURL.getFunction("curl_easy_pause");
        public static final long curl_easy_setopt = CURL.getFunction("curl_easy_setopt");
        public static final long curl_easy_getinfo = CURL.getFunction("curl_easy_getinfo");
        public static final long curl_easy_strerror = CURL.getFunction("curl_easy_strerror");
        public static final long curl_easy_cleanup = CURL.getFunction("curl_easy_cleanup");
        public static final long curl_easy_impersonate = CURL.getOptionalFunction("curl_easy_impersonate");
        public static final long curl_slist_append = CURL.getFunction("curl_slist_append");
        public static final long curl_slist_free_all = CURL.getFunction("curl_slist_free_all");
        public static final long curl_mime_init = CURL.getFunction("curl_mime_init");
        public static final long curl_mime_free = CURL.getFunction("curl_mime_free");
        public static final long curl_mime_addpart = CURL.getFunction("curl_mime_addpart");
        public static final long curl_mime_name = CURL.getFunction("curl_mime_name");
        public static final long curl_mime_filename = CURL.getFunction("curl_mime_filename");
        public static final long curl_mime_type = CURL.getFunction("curl_mime_type");
        public static final long curl_mime_data = CURL.getFunction("curl_mime_data");
        public static final long curl_mime_data_cb = CURL.getFunction("curl_mime_data_cb");
        public static final long curl_multi_init = CURL.getFunction("curl_multi_init");
        public static final long curl_multi_cleanup = CURL.getFunction("curl_multi_cleanup");
        public static final long curl_multi_add_handle = CURL.getFunction("curl_multi_add_handle");
        public static final long curl_multi_remove_handle = CURL.getFunction("curl_multi_remove_handle");
        public static final long curl_multi_perform = CURL.getFunction("curl_multi_perform");
        public static final long curl_multi_wait = CURL.getFunction("curl_multi_wait");
        public static final long curl_multi_info_read = CURL.getFunction("curl_multi_info_read");
        public static final long curl_multi_timeout = CURL.getFunction("curl_multi_timeout");
        public static final long curl_multi_setopt = CURL.getFunction("curl_multi_setopt");
        public static final long curl_multi_strerror = CURL.getFunction("curl_multi_strerror");

        private Functions() {
        }

        public static native String ncurl_version(long var0);

        public static native long ncurl_version_info(long var0);

        public static native int ncurl_global_init(long var0, long var2);

        public static native void ncurl_global_cleanup(long var0);

        public static native long ncurl_easy_init(long var0);

        public static native void ncurl_easy_reset(long var0, long var2);

        public static native int ncurl_easy_perform(long var0, long var2);

        public static native int ncurl_easy_pause(long var0, long var2, int var4);

        public static native int ncurl_easy_setopt(long var0, long var2, int var4, long var5);

        public static native int ncurl_easy_setopt(long var0, long var2, int var4, String var5);

        public static native int ncurl_easy_getinfo(long var0, long var2, int var4, long var5);

        public static native String ncurl_easy_strerror(long var0, int var2);

        public static native void ncurl_easy_cleanup(long var0, long var2);

        public static native int ncurl_easy_impersonate(long var0, long var2, String var4, boolean var5);

        public static native long ncurl_slist_append(long var0, long var2, String var4);

        public static native void ncurl_slist_free_all(long var0, long var2);

        public static native long ncurl_mime_init(long var0, long var2);

        public static native void ncurl_mime_free(long var0, long var2);

        public static native long ncurl_mime_addpart(long var0, long var2);

        public static native int ncurl_mime_name(long var0, long var2, String var4);

        public static native int ncurl_mime_filename(long var0, long var2, String var4);

        public static native int ncurl_mime_type(long var0, long var2, String var4);

        public static native int ncurl_mime_data(long var0, long var2, byte[] var4);

        public static native int ncurl_mime_data_cb(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

        public static native long ncurl_multi_init(long var0);

        public static native void ncurl_multi_cleanup(long var0, long var2);

        public static native int ncurl_multi_add_handle(long var0, long var2, long var4);

        public static native int ncurl_multi_remove_handle(long var0, long var2, long var4);

        public static native int ncurl_multi_perform(long var0, long var2, long var4);

        public static native int ncurl_multi_wait(long var0, long var2, long var4, int var6, int var7, long var8);

        public static native long ncurl_multi_info_read(long var0, long var2, long var4);

        public static native int ncurl_multi_timeout(long var0, long var2, long var4);

        public static native int ncurl_multi_setopt(long var0, long var2, int var4, long var5);

        public static native String ncurl_multi_strerror(long var0, int var2);
    }
}

