/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.core;

import java.util.Locale;

public enum Architecture {
    X32,
    X64,
    ARM32,
    ARM64,
    UNKNOWN;

    public static final Architecture CURRENT;

    public String lowerName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static Architecture parse(String arch) {
        switch (arch.toLowerCase(Locale.ROOT)) {
            case "i386": 
            case "x86": {
                return X32;
            }
            case "x64": 
            case "x86_64": 
            case "amd64": {
                return X64;
            }
            case "arm": 
            case "armv7": 
            case "armv7l": {
                return ARM32;
            }
            case "armv8": 
            case "aarch64": {
                return ARM64;
            }
        }
        return UNKNOWN;
    }

    static {
        CURRENT = Architecture.parse(System.getProperty("os.arch"));
    }
}

