/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.core;

import java.util.Locale;

public enum OperatingSystem {
    WINDOWS,
    LINUX,
    MACOS,
    FREEBSD,
    UNKNOWN;

    public static final OperatingSystem CURRENT;

    public String lowerName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static OperatingSystem parse(String name) {
        if ((name = name.toLowerCase(Locale.ROOT)).contains("windows")) {
            return WINDOWS;
        }
        if (name.contains("linux")) {
            return LINUX;
        }
        if (name.contains("osx") || name.contains("os x") || name.contains("darwin")) {
            return MACOS;
        }
        if (name.contains("freebsd")) {
            return FREEBSD;
        }
        return UNKNOWN;
    }

    public boolean isLinux() {
        return this == LINUX;
    }

    static {
        CURRENT = OperatingSystem.parse(System.getProperty("os.name"));
    }
}

