/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.core;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.covers1624.curl4j.core.Memory;
import net.covers1624.curl4j.core.NativeTypes;
import net.covers1624.curl4j.core.Pointer;
import org.jetbrains.annotations.Nullable;

public class Struct {
    private final String name;
    private final List<Member<?>> members = new ArrayList();
    private boolean finished;
    private int sizeof;
    private int align = 0;

    @Deprecated
    public Struct() {
        this("$unknown$");
    }

    public Struct(String name) {
        this.name = name;
    }

    private <T> Member<T> addMember(Member<T> member) {
        if (this.finished) {
            throw new IllegalArgumentException("Finish has already been called.");
        }
        for (Member<?> m : this.members) {
            if (!m.name.equals(member.name)) continue;
            throw new IllegalArgumentException("Duplicate member name " + member.name);
        }
        this.members.add(member);
        this.sizeof = member.offset + member.size();
        this.align = Math.max(this.align, member.alignment());
        return member;
    }

    public Member<Integer> intMember(String name) {
        return this.addMember(new IntMember(this.sizeof, name));
    }

    public Member<@Nullable String> stringMember(String name) {
        return this.addMember(new StringMember(this.sizeof, name));
    }

    public Member<Long> longMember(String name) {
        return this.addMember(new CLongMember(this.sizeof, name));
    }

    public Member<Long> sizeTMember(String name) {
        return this.addMember(new SizeTMember(this.sizeof, name));
    }

    public Member<Set<String>> stringListMember(String name) {
        return this.addMember(new StringListMember(this.sizeof, name));
    }

    public Member<Pointer> pointerMember(String name) {
        return this.addMember(new PointerMember(this.sizeof, name));
    }

    public <T extends Pointer> Member<@Nullable T> structPointerMember(String name, final Function<Pointer, T> func) {
        return this.addMember(new Member<T>(this.sizeof, name){

            @Override
            public T read(long struct) {
                long addr = Memory.getAddress(struct + (long)this.offset);
                return addr != 0L ? (Pointer)func.apply(new Pointer(addr)) : null;
            }

            @Override
            public void write(long struct, T value) {
                throw new UnsupportedOperationException("Unable to set struct member yet.");
            }

            @Override
            public int size() {
                return NativeTypes.POINTER_SIZE;
            }
        });
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.sizeof = Struct.align(this.sizeof, this.align);
        this.finished = true;
    }

    public int getSize() {
        this.finish();
        return this.sizeof;
    }

    public int getAlign() {
        this.finish();
        return this.align;
    }

    private static int align(int o, int a) {
        return (o - 1 | a - 1) + 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("struct ").append(this.name).append(" ").append(" s:").append(this.getSize()).append(" a:").append(this.getAlign()).append(" {\n");
        int maxCharsName = 0;
        int maxCharsSize = 0;
        int maxCharsAlign = 0;
        int maxCharsOff = 0;
        for (Member<?> member : this.members) {
            maxCharsName = Math.max(maxCharsName, member.name.length());
            maxCharsSize = Math.max(maxCharsSize, Integer.toString(member.size()).length());
            maxCharsAlign = Math.max(maxCharsAlign, Integer.toString(member.alignment()).length());
            maxCharsOff = Math.max(maxCharsOff, Integer.toString(member.offset).length());
        }
        for (Member<?> member : this.members) {
            builder.append("\t").append(Struct.padString(member.name, maxCharsName)).append(" s:").append(Struct.padString(String.valueOf(member.size()), maxCharsSize)).append(" a:").append(Struct.padString(String.valueOf(member.alignment()), maxCharsAlign)).append(" o:").append(Struct.padString(String.valueOf(member.offset), maxCharsOff)).append("\n");
        }
        builder.append("}");
        return builder.toString();
    }

    private static String padString(String str, int toLen) {
        StringBuilder sb = new StringBuilder(str);
        for (int i = str.length(); i < toLen; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static class StringListMember
    extends Member<Set<String>> {
        private StringListMember(int offset, String name) {
            super(offset, name);
        }

        @Override
        public Set<String> read(long struct) {
            LinkedHashSet<String> protocols = new LinkedHashSet<String>();
            long ptr = Memory.getAddress(struct + (long)this.offset);
            while (Memory.getByte(ptr) != 0) {
                protocols.add(Memory.readUtf8(Memory.getAddress(ptr)));
                ptr += (long)NativeTypes.POINTER_SIZE;
            }
            return protocols;
        }

        @Override
        public void write(long struct, Set<String> value) {
            throw new UnsupportedOperationException("Unable to set StringList yet.");
        }

        @Override
        public int size() {
            return NativeTypes.CLONG_SIZE;
        }
    }

    private static class PointerMember
    extends Member<Pointer> {
        private PointerMember(int offset, String name) {
            super(offset, name);
        }

        @Override
        public Pointer read(long struct) {
            return new Pointer(Memory.getAddress(struct + (long)this.offset));
        }

        @Override
        public void write(long struct, Pointer value) {
            Memory.putAddress(struct + (long)this.offset, value.address);
        }

        @Override
        public int size() {
            return NativeTypes.POINTER_SIZE;
        }
    }

    private static class SizeTMember
    extends Member<Long> {
        private SizeTMember(int offset, String name) {
            super(offset, name);
        }

        @Override
        public Long read(long struct) {
            return Memory.getSizeT(struct + (long)this.offset);
        }

        @Override
        public void write(long struct, Long value) {
            Memory.putSizeT(struct + (long)this.offset, value);
        }

        @Override
        public int size() {
            return NativeTypes.SIZE_T_SIZE;
        }
    }

    private static class CLongMember
    extends Member<Long> {
        private CLongMember(int offset, String name) {
            super(offset, name);
        }

        @Override
        public Long read(long struct) {
            return Memory.getCLong(struct + (long)this.offset);
        }

        @Override
        public void write(long struct, Long value) {
            Memory.putCLong(struct + (long)this.offset, value);
        }

        @Override
        public int size() {
            return NativeTypes.CLONG_SIZE;
        }
    }

    private static class StringMember
    extends Member<String> {
        private StringMember(int offset, String name) {
            super(offset, name);
        }

        @Override
        public String read(long struct) {
            return Memory.readUtf8(Memory.getAddress(struct + (long)this.offset));
        }

        @Override
        public void write(long struct, String value) {
            throw new UnsupportedOperationException("Unable to set Strings yet.");
        }

        @Override
        public int size() {
            return NativeTypes.POINTER_SIZE;
        }
    }

    private static class IntMember
    extends Member<Integer> {
        private IntMember(int offset, String name) {
            super(offset, name);
        }

        @Override
        public Integer read(long struct) {
            return Memory.getInt(struct + (long)this.offset);
        }

        @Override
        public void write(long struct, Integer value) {
            Memory.putInt(struct + (long)this.offset, value);
        }

        @Override
        public int size() {
            return NativeTypes.CINT_SIZE;
        }
    }

    public static abstract class Member<T> {
        public final int offset;
        public final String name;

        private Member(int offset, String name) {
            this.offset = Struct.align(offset, this.alignment());
            this.name = name;
        }

        public T read(Pointer pointer) {
            return this.read(pointer.address);
        }

        public abstract T read(long var1);

        public void write(Pointer pointer, T value) {
            this.write(pointer.address, value);
        }

        public abstract void write(long var1, T var3);

        public abstract int size();

        public int alignment() {
            return this.size();
        }
    }
}

