/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.curl_slist;
import net.covers1624.curl4j.util.CurlBindable;
import org.jetbrains.annotations.Nullable;

public class SListHeaderWrapper
implements AutoCloseable,
CurlBindable {
    private final List<String> headers = new ArrayList<String>();
    @Nullable
    private curl_slist list;
    private boolean closed;

    public SListHeaderWrapper(String ... headers) {
        Collections.addAll(this.headers, headers);
    }

    public SListHeaderWrapper(List<String> headers) {
        this.headers.addAll(headers);
    }

    public SListHeaderWrapper(Map<String, List<String>> headers) {
        headers.forEach((name, values) -> values.forEach(value -> this.headers.add(name + ": " + value)));
    }

    public curl_slist get() {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        if (this.headers.isEmpty()) {
            return null;
        }
        if (this.list == null) {
            for (String header : this.headers) {
                this.list = CURL.curl_slist_append(this.list, header);
            }
        }
        return this.list;
    }

    @Override
    public void apply(long curl) {
        CURL.curl_easy_setopt(curl, 10023, this.get());
    }

    @Override
    public void close() {
        CURL.curl_slist_free_all(this.list);
        this.closed = true;
    }
}

